/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph.primitives;

import org.openmali.FastMath;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Tuple3f;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.Geometry;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.TriangleArray;
import org.xith3d.scenegraph.primitives.GeomFactory;

public class Ellipsoid
extends Shape3D {
    public Ellipsoid(float rx, float ry, float rz, int slices, int stacks, int features, boolean colorAlpha, int texCoordsSize) {
        if (stacks < 2 || slices < 3) {
            throw new IllegalArgumentException("insufficient stacks or slices");
        }
        features |= 1;
        Point3f[] coords = new Point3f[3 * slices * 2 * (stacks - 1)];
        Point3f[][] buffer = new Point3f[2][stacks + 1];
        for (int j = 0; j <= stacks; ++j) {
            buffer[0][j] = new Point3f();
            buffer[0][j].setX(FastMath.sin((float)j * (float)Math.PI / (float)stacks));
            buffer[0][j].setY(0.0f);
            buffer[0][j].setZ(FastMath.cos((float)j * (float)Math.PI / (float)stacks));
        }
        int index = 0;
        for (int i = 0; i < slices; ++i) {
            int left = i % 2;
            int right = (i + 1) % 2;
            buffer[right][0] = new Point3f(0.0f, 0.0f, 1.0f);
            for (int j = 0; j < stacks; ++j) {
                buffer[right][j + 1] = new Point3f();
                buffer[right][j + 1].setX(FastMath.cos(2.0f * (float)(i + 1) * (float)Math.PI / (float)slices) * FastMath.sin((float)(j + 1) * (float)Math.PI / (float)stacks));
                buffer[right][j + 1].setY(FastMath.sin(2.0f * (float)(i + 1) * (float)Math.PI / (float)slices) * FastMath.sin((float)(j + 1) * (float)Math.PI / (float)stacks));
                buffer[right][j + 1].setZ(buffer[left][j + 1].getZ());
                if (j > 0) {
                    coords[index++] = buffer[left][j];
                    coords[index++] = buffer[left][j + 1];
                    coords[index++] = buffer[right][j];
                }
                if (j >= stacks - 1) continue;
                coords[index++] = buffer[right][j];
                coords[index++] = buffer[left][j + 1];
                coords[index++] = buffer[right][j + 1];
            }
        }
        Tuple3f[] vertices = new Point3f[coords.length];
        for (int i = 0; i < coords.length; ++i) {
            vertices[i] = new Point3f(coords[i]);
            vertices[i].mul(rx, ry, rz);
        }
        Colorf[] colors = null;
        if ((features & 4) != 0) {
            colors = new Colorf[vertices.length];
            for (int i = 0; i < colors.length; ++i) {
                colors[i] = colorAlpha ? new Colorf(coords[i].getX(), coords[i].getY(), coords[i].getZ(), 0.0f) : new Colorf(coords[i].getX(), coords[i].getY(), coords[i].getZ());
            }
        }
        TriangleArray geom = new TriangleArray(vertices.length);
        geom.makeInterleaved(features, colorAlpha, new int[]{texCoordsSize}, null);
        geom.setOptimization(Geometry.Optimization.USE_DISPLAY_LISTS);
        geom.setCoordinates(0, vertices);
        if (colors != null) {
            geom.setColors(0, colors);
        }
        super.setGeometry(geom);
    }

    public Ellipsoid(float rx, float ry, float rz, int slices, int stacks, Texture texture) {
        this(rx, ry, rz, slices, stacks, 11, false, 2);
        this.getAppearance(true).setTexture(texture);
    }

    public Ellipsoid(float rx, float ry, float rz, int slices, int stacks, String texture) {
        this(rx, ry, rz, slices, stacks, TextureLoader.getInstance().getTexture(texture));
    }

    public Ellipsoid(float rx, float ry, float rz, int slices, int stacks, Colorf color) {
        this(rx, ry, rz, slices, stacks, 3, false, 2);
        this.getAppearance(true).getColoringAttributes(true).setColor(color);
        if (color.hasAlpha()) {
            this.getAppearance(true).getTransparencyAttributes(true).setTransparency(color.getAlpha());
        }
    }

    public Ellipsoid(float rx, float ry, float rz, int slices, int stacks, Appearance app) {
        this(rx, ry, rz, slices, stacks, 3 | GeomFactory.getFeaturesFromAppearance(app), false, GeomFactory.getTexCoordsSize(app));
        this.setAppearance(app);
    }
}

