/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph.primitives;

import java.awt.Font;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Tuple2f;
import org.openmali.vecmath2.Tuple3f;
import org.xith3d.loaders.texture.TextureCreator;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.primitives.FixedSizedBillboard;

public class FixedSizedBillboardFactory {
    private FixedSizedBillboardFactory() {
    }

    public static FixedSizedBillboard createColoredBillboard(float width, float height, Colorf color) {
        FixedSizedBillboard billboard = new FixedSizedBillboard(null, width, height);
        billboard.getAppearance(true).setColor(color);
        return billboard;
    }

    public static FixedSizedBillboard createColoredBillboard(Tuple3f center, float width, float height, Colorf color) {
        FixedSizedBillboard billboard = new FixedSizedBillboard(center, width, height);
        billboard.getAppearance(true).setColor(color);
        return billboard;
    }

    public static FixedSizedBillboard createTexturedBillboard(Tuple3f center, float width, float height, Texture texture) {
        FixedSizedBillboard billboard = new FixedSizedBillboard(center, width, height);
        billboard.setTexture(texture, null, null);
        return billboard;
    }

    public static FixedSizedBillboard createTexturedBillboard(Tuple3f center, float width, float height, Texture texture, Tuple2f textureLowerLeft, Tuple2f textureUpperRight) {
        FixedSizedBillboard billboard = new FixedSizedBillboard(center, width, height);
        billboard.setTexture(texture, textureLowerLeft, textureUpperRight);
        return billboard;
    }

    public static FixedSizedBillboard createTexturedBillboard(Tuple3f center, float width, float height, String textureName, Tuple2f textureLowerLeft, Tuple2f textureUpperRight) {
        FixedSizedBillboard billboard = new FixedSizedBillboard(center, width, height);
        Texture2D texture = TextureLoader.getInstance().getTextureOrNull(textureName, Texture.MipmapMode.MULTI_LEVEL_MIPMAP);
        billboard.setTexture(texture, textureLowerLeft, textureUpperRight);
        return billboard;
    }

    public static FixedSizedBillboard createConstantSizeTexturedBillboard(int screenWidth, int screenHeight, String textureName, Tuple2f textureLowerLeft, Tuple2f textureUpperRight) {
        Texture2D texture = TextureLoader.getInstance().getTextureOrNull(textureName);
        return FixedSizedBillboardFactory.createConstantSizeTexturedBillboard(screenWidth, screenHeight, texture, textureLowerLeft, textureUpperRight);
    }

    public static FixedSizedBillboard createConstantSizeTexturedBillboard(int screenWidth, int screenHeight, Texture texture, Tuple2f textureLowerLeft, Tuple2f textureUpperRight) {
        FixedSizedBillboard billboard = new FixedSizedBillboard(null, 1.0f, 1.0f);
        billboard.setSizeOnScreen(screenWidth, screenHeight);
        billboard.setTexture(texture, textureLowerLeft, textureUpperRight);
        return billboard;
    }

    public static FixedSizedBillboard createConstantSizeTexturedBillboard(int screenWidth, int screenHeight, String texture) {
        return FixedSizedBillboardFactory.createConstantSizeTexturedBillboard(screenWidth, screenHeight, texture, null, null);
    }

    public static FixedSizedBillboard createConstantSizeTexturedBillboard(int screenWidth, int screenHeight, Texture texture) {
        return FixedSizedBillboardFactory.createConstantSizeTexturedBillboard(screenWidth, screenHeight, texture, null, null);
    }

    public static FixedSizedBillboard createConstantSizeTexturedBillboard(Texture texture) {
        return FixedSizedBillboardFactory.createConstantSizeTexturedBillboard(texture.getOriginalWidth(), texture.getOriginalHeight(), texture, null, null);
    }

    public static FixedSizedBillboard createConstantSizeTexturedBillboard(String texture) {
        return FixedSizedBillboardFactory.createConstantSizeTexturedBillboard(TextureLoader.getInstance().getTexture(texture));
    }

    public static FixedSizedBillboard createConstantSizedTextBillboard(String text, int alignment, Font font, Colorf color) {
        Texture2D texture = TextureCreator.createTexture(text, color, font, alignment);
        return FixedSizedBillboardFactory.createConstantSizeTexturedBillboard(texture);
    }
}

