/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph.primitives;

import org.jagatoo.opengl.enums.LinePattern;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Tuple3f;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.ColoringAttributes;
import org.xith3d.scenegraph.LineArray;
import org.xith3d.scenegraph.LineAttributes;
import org.xith3d.scenegraph.Shape3D;

public class Line
extends Shape3D {
    private float[] coords;

    public LineArray getGeometry() {
        return (LineArray)super.getGeometry();
    }

    public void setCoordinates(float[] coords) {
        this.coords = coords;
        this.getGeometry().setCoordinates(0, coords);
        this.setBoundsDirty();
    }

    public void setCoordinates(float x0, float y0, float z0, float x1, float y1, float z1) {
        this.setCoordinates(new float[]{x0, y0, z0, x1, y1, z1});
    }

    public void setCoordinates(float x1, float y1, float z1) {
        this.setCoordinates(0.0f, 0.0f, 0.0f, x1, y1, z1);
    }

    public void setCoordinates(Tuple3f start, Tuple3f end) {
        this.setCoordinates(start.getX(), start.getY(), start.getZ(), end.getX(), end.getY(), end.getZ());
    }

    public void setCoordinates(Tuple3f end) {
        this.setCoordinates(Point3f.ZERO, end);
    }

    public float[] getCoordinates() {
        return this.coords;
    }

    public void setColor(Colorf color) {
        this.getAppearance().getColoringAttributes().setColor(color);
        if (color.hasAlpha()) {
            this.getAppearance().getTransparencyAttributes(true).setTransparency(color.getAlpha());
        } else {
            this.getAppearance().setTransparencyAttributes(null);
        }
    }

    public Colorf getColor() {
        return this.getAppearance().getColoringAttributes().getColor();
    }

    public void setPattern(LinePattern pattern) {
        this.getAppearance().getLineAttributes().setLinePattern(pattern);
    }

    public LinePattern getPattern() {
        return this.getAppearance().getLineAttributes().getLinePattern();
    }

    public void setWidth(float width) {
        this.getAppearance().getLineAttributes().setLineWidth(width);
    }

    public float getWidth() {
        return this.getAppearance().getLineAttributes().getLineWidth();
    }

    public void setAntialiasingEnabled(boolean enabled) {
        this.getAppearance().getLineAttributes().setLineAntialiasingEnabled(enabled);
    }

    public boolean isAntialiasingEnabled() {
        return this.getAppearance().getLineAttributes().isLineAntialiasingEnabled();
    }

    public Line(Tuple3f start, Tuple3f end, float width, boolean antiAliasing, Colorf color, LinePattern linePattern) {
        boolean ib = this.isIgnoreBounds();
        this.setIgnoreBounds(true);
        this.setGeometry(new LineArray(2));
        this.setIgnoreBounds(ib);
        this.setCoordinates(start, end);
        this.updateBounds(true);
        this.setAppearance(new Appearance());
        ColoringAttributes ca = new ColoringAttributes();
        ca.setShadeModel(ColoringAttributes.SHADE_FLAT);
        this.getAppearance().setColoringAttributes(ca);
        this.setColor(color);
        this.getAppearance().setLineAttributes(new LineAttributes());
        this.setWidth(width);
        this.setPattern(linePattern);
        this.setAntialiasingEnabled(antiAliasing);
    }

    public Line(Tuple3f start, Tuple3f end, float width, boolean antiAliasing, Colorf color) {
        this(start, end, width, antiAliasing, color, LinePattern.SOLID);
    }

    public Line(Tuple3f start, Tuple3f end, float width, Colorf color) {
        this(start, end, width, false, color, LinePattern.SOLID);
    }

    public Line(Tuple3f start, Tuple3f end, boolean antiAliasing, Colorf color, LinePattern linePattern) {
        this(start, end, 1.0f, antiAliasing, color, linePattern);
    }

    public Line(Tuple3f start, Tuple3f end, Colorf color, LinePattern linePattern) {
        this(start, end, 1.0f, false, color, linePattern);
    }

    public Line(Tuple3f start, Tuple3f end, boolean antiAliasing, Colorf color) {
        this(start, end, 1.0f, antiAliasing, color, LinePattern.SOLID);
    }

    public Line(Tuple3f start, Tuple3f end, Colorf color) {
        this(start, end, 1.0f, false, color, LinePattern.SOLID);
    }

    public Line(Tuple3f end, float width, boolean antiAliasing, Colorf color, LinePattern linePattern) {
        this(new Point3f(0.0f, 0.0f, 0.0f), end, width, antiAliasing, color, linePattern);
    }

    public Line(Tuple3f end, float width, Colorf color, LinePattern linePattern) {
        this(new Point3f(0.0f, 0.0f, 0.0f), end, width, false, color, linePattern);
    }

    public Line(Tuple3f end, float width, boolean antiAliasing, Colorf color) {
        this(new Point3f(0.0f, 0.0f, 0.0f), end, width, antiAliasing, color, LinePattern.SOLID);
    }

    public Line(Tuple3f end, float width, Colorf color) {
        this(new Point3f(0.0f, 0.0f, 0.0f), end, width, false, color, LinePattern.SOLID);
    }

    public Line(Tuple3f end, boolean antiAliasing, Colorf color, LinePattern linePattern) {
        this(new Point3f(0.0f, 0.0f, 0.0f), end, 1.0f, antiAliasing, color, linePattern);
    }

    public Line(Tuple3f end, Colorf color, LinePattern linePattern) {
        this(new Point3f(0.0f, 0.0f, 0.0f), end, 1.0f, false, color, linePattern);
    }

    public Line(Tuple3f end, boolean antiAliasing, Colorf color) {
        this(new Point3f(0.0f, 0.0f, 0.0f), end, 1.0f, antiAliasing, color, LinePattern.SOLID);
    }

    public Line(Tuple3f end, Colorf color) {
        this(new Point3f(0.0f, 0.0f, 0.0f), end, 1.0f, false, color, LinePattern.SOLID);
    }
}

