/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph.primitives;

import org.jagatoo.opengl.enums.BlendMode;
import org.jagatoo.opengl.enums.TextureFormat;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.TexCoord2f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.ColoringAttributes;
import org.xith3d.scenegraph.Geometry;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.TransparencyAttributes;
import org.xith3d.scenegraph.TriangleFanArray;

public class Quad
extends Shape3D {
    private void checkVertexCoords(Tuple3f[] vertices) throws IllegalArgumentException {
        if (vertices == null) {
            throw new IllegalArgumentException("vertices cannot be null");
        }
        if (vertices.length != 4) {
            throw new IllegalArgumentException("vertices count must be 4 for a Quad");
        }
    }

    @Deprecated
    public void update(Tuple3f[] vertices) {
        this.checkVertexCoords(vertices);
        this.getGeometry().setCoordinate(0, vertices[0]);
        this.getGeometry().setCoordinate(1, vertices[1]);
        this.getGeometry().setCoordinate(2, vertices[3]);
        this.getGeometry().setCoordinate(3, vertices[2]);
    }

    @Deprecated
    public void update(Tuple3f ll, Tuple3f lr, Tuple3f ul, Tuple3f ur) {
        this.getGeometry().setCoordinate(0, ll);
        this.getGeometry().setCoordinate(1, lr);
        this.getGeometry().setCoordinate(2, ur);
        this.getGeometry().setCoordinate(3, ul);
    }

    private void setVertexCoords(Tuple3f ll, Tuple3f lr, Tuple3f ur, Tuple3f ul, Geometry geom) {
        geom.setCoordinate(0, ll);
        geom.setCoordinate(1, lr);
        geom.setCoordinate(2, ur);
        geom.setCoordinate(3, ul);
    }

    public void setVertexCoords(Tuple3f[] coords, Geometry geom) {
        this.checkVertexCoords(coords);
        this.setVertexCoords(coords[0], coords[1], coords[2], coords[3], geom);
    }

    public void setVertexCoords(Tuple3f ll, Tuple3f lr, Tuple3f ur, Tuple3f ul) {
        this.setVertexCoords(ll, lr, ur, ul, this.getGeometry());
    }

    public void setVertexCoords(Tuple3f[] coords) {
        this.setVertexCoords(coords, this.getGeometry());
    }

    private void setColor(float r, float g, float b, float a) {
        Appearance app = super.getAppearance(true);
        ColoringAttributes ca = app.getColoringAttributes();
        if (r < 0.0f) {
            if (ca != null) {
                app.setColoringAttributes(null);
            }
            return;
        }
        if (ca == null) {
            ca = new ColoringAttributes();
        }
        ca.setColor(r, g, b);
        app.setColoringAttributes(ca);
        this.setAlpha(a);
    }

    public void setColor(Colorf color) {
        if (color != null && color.hasAlpha()) {
            this.setColor(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
        } else if (color != null) {
            this.setColor(color.getRed(), color.getGreen(), color.getBlue(), this.getAlpha());
        } else {
            this.setColor(-1.0f, -1.0f, -1.0f, this.getAlpha());
        }
    }

    public Colorf getColor() {
        ColoringAttributes ca;
        Appearance appearance = super.getAppearance();
        if (appearance != null && (ca = appearance.getColoringAttributes()) != null) {
            return ca.getColor();
        }
        return null;
    }

    public void setAlpha(float alpha) {
        if (alpha > 0.0f) {
            Appearance app = super.getAppearance(true);
            TransparencyAttributes ta = app.getTransparencyAttributes();
            if (ta == null) {
                ta = new TransparencyAttributes(TransparencyAttributes.BLENDED, alpha);
            } else {
                ta.setTransparency(alpha);
            }
            app.setTransparencyAttributes(ta);
        } else if (super.getAppearance() != null) {
            super.getAppearance().setTransparencyAttributes(null);
        }
    }

    public float getAlpha() {
        TransparencyAttributes ta;
        Appearance appearance = super.getAppearance();
        if (appearance != null && (ta = appearance.getTransparencyAttributes()) != null) {
            return ta.getTransparency();
        }
        return -1.0f;
    }

    @Deprecated
    public void setTexturePosition(TexCoord2f[] textureCoordinates) {
        TriangleFanArray geometry = this.getGeometry();
        if (textureCoordinates == null) {
            geometry.setTextureCoordinate(0, 0, 0.0f, 0.0f);
            geometry.setTextureCoordinate(0, 1, 1.0f, 0.0f);
            geometry.setTextureCoordinate(0, 2, 1.0f, 1.0f);
            geometry.setTextureCoordinate(0, 3, 0.0f, 1.0f);
            return;
        }
        geometry.setTextureCoordinates(0, 0, textureCoordinates);
    }

    public void setTextureCoordinates(TexCoord2f[] textureCoordinates) {
        TriangleFanArray geometry = this.getGeometry();
        if (textureCoordinates == null) {
            geometry.setTextureCoordinate(0, 0, 0.0f, 0.0f);
            geometry.setTextureCoordinate(0, 1, 1.0f, 0.0f);
            geometry.setTextureCoordinate(0, 2, 1.0f, 1.0f);
            geometry.setTextureCoordinate(0, 3, 0.0f, 1.0f);
            return;
        }
        geometry.setTextureCoordinate(0, 0, textureCoordinates[0]);
        geometry.setTextureCoordinate(0, 1, textureCoordinates[1]);
        geometry.setTextureCoordinate(0, 2, textureCoordinates[2]);
        geometry.setTextureCoordinate(0, 3, textureCoordinates[3]);
    }

    public void setTexture(Texture texture) {
        Appearance app = this.getAppearance();
        if (app == null && texture != null) {
            app = new Appearance();
            this.setAppearance(app);
        }
        if (app != null) {
            app.setTexture(texture);
            if (texture.getFormat() == TextureFormat.RGBA) {
                TransparencyAttributes ta = app.getTransparencyAttributes();
                if (ta == null) {
                    ta = new TransparencyAttributes(TransparencyAttributes.BLENDED, 0.0f);
                } else {
                    ta.setMode(TransparencyAttributes.BLENDED);
                    ta.setTransparency(0.0f);
                }
                app.setTransparencyAttributes(ta);
            } else {
                app.setTransparencyAttributes(null);
            }
        }
        this.setAppearance(app);
    }

    public void setTexture(Texture texture, TexCoord2f[] textureCoordinates) {
        if (texture != null) {
            this.setTexture(texture);
            this.setTextureCoordinates(textureCoordinates);
        } else {
            Appearance app = this.getAppearance();
            if (app != null) {
                app.setTexture((Texture)null);
            }
        }
    }

    public void setTexture(String texture, TexCoord2f[] textureCoordinates) {
        this.setTexture(TextureLoader.getInstance().getTextureOrNull(texture, Texture.MipmapMode.MULTI_LEVEL_MIPMAP), textureCoordinates);
    }

    public void setTexture(String texture) {
        this.setTexture(TextureLoader.getInstance().getTextureOrNull(texture, Texture.MipmapMode.MULTI_LEVEL_MIPMAP));
    }

    public Texture getTexture() {
        if (this.getAppearance() == null) {
            return null;
        }
        return this.getAppearance().getTexture();
    }

    public TriangleFanArray getGeometry() {
        return (TriangleFanArray)super.getGeometry();
    }

    protected TriangleFanArray createGeometry() {
        return new TriangleFanArray(4);
    }

    protected void generateNormals(Geometry geom) {
        int numVertices = geom.getVertexCount();
        Point3f coordA = Point3f.fromPool();
        Point3f coordB = Point3f.fromPool();
        Point3f coordC = Point3f.fromPool();
        Vector3f vecBA = Vector3f.fromPool();
        Vector3f vecBC = Vector3f.fromPool();
        Vector3f normal = Vector3f.fromPool();
        for (int i = 0; i < numVertices; ++i) {
            int indexA = (i - 1 + numVertices) % numVertices;
            int indexC = (i + 1 + numVertices) % numVertices;
            geom.getCoordinate(indexA, coordA);
            geom.getCoordinate(i, coordB);
            geom.getCoordinate(indexC, coordC);
            vecBA.sub(coordB, coordA);
            vecBC.sub(coordB, coordC);
            normal.cross(vecBC, vecBA);
            normal.normalize();
            if (normal.getX() == -0.0f) {
                normal.setX(0.0f);
            }
            if (normal.getY() == -0.0f) {
                normal.setY(0.0f);
            }
            if (normal.getZ() == -0.0f) {
                normal.setZ(0.0f);
            }
            geom.setNormal(i, normal);
        }
        Vector3f.toPool(vecBC);
        Vector3f.toPool(vecBA);
        Vector3f.toPool(normal);
        Point3f.toPool(coordC);
        Point3f.toPool(coordB);
        Point3f.toPool(coordA);
    }

    private Quad(Tuple3f[] coords, boolean generateNormals, TexCoord2f[] textureCoords, Texture texture, float colorR, float colorG, float colorB, float colorA) {
        this.checkVertexCoords(coords);
        TriangleFanArray geometry = this.createGeometry();
        this.setVertexCoords(coords, geometry);
        if (generateNormals) {
            this.generateNormals(geometry);
        }
        super.setGeometry(geometry);
        boolean alphaBlending = false;
        if (texture != null) {
            this.setTexture(texture, textureCoords);
            boolean bl = alphaBlending = alphaBlending || texture.getFormat().hasAlpha();
        }
        if (colorR >= 0.0f) {
            this.setColor(colorR, colorG, colorB, colorA);
            boolean bl = alphaBlending = alphaBlending || colorA > 0.0f;
        }
        if (alphaBlending) {
            this.getAppearance(true).getTransparencyAttributes(true).setMode(BlendMode.BLENDED);
        }
    }

    public Quad(Point3f[] coords, boolean generateNormals, TexCoord2f[] textureCoords, Texture texture, Colorf color) {
        this(coords, generateNormals, textureCoords, texture, color != null ? color.getRed() : -1.0f, color != null ? color.getGreen() : -1.0f, color != null ? color.getBlue() : -1.0f, color != null && color.hasAlpha() ? color.getAlpha() : -1.0f);
    }

    public Quad(Point3f[] coords, boolean generateNormals, TexCoord2f[] textureCoords, String texture, Colorf color) {
        this(coords, generateNormals, textureCoords, TextureLoader.getInstance().getTextureOrNull(texture, Texture.MipmapMode.MULTI_LEVEL_MIPMAP), color);
    }

    public Quad(Point3f[] coords, boolean generateNormals, TexCoord2f[] textureCoords, Texture texture) {
        this(coords, generateNormals, textureCoords, texture, null);
    }

    public Quad(Point3f[] coords, boolean generateNormals, TexCoord2f[] textureCoords, String texture) {
        this(coords, generateNormals, textureCoords, texture, null);
    }

    public Quad(Point3f[] coords, boolean generateNormals, Colorf color) {
        this(coords, generateNormals, (TexCoord2f[])null, (Texture)null, color);
    }

    public Quad(Point3f[] coords, boolean generateNormals, String texture) {
        this(coords, generateNormals, (TexCoord2f[])null, texture, null);
    }

    public Quad(Point3f[] coords, boolean generateNormals) {
        this(coords, generateNormals, (TexCoord2f[])null, (Texture)null, null);
    }

    public Quad(Point3f[] coords, TexCoord2f[] textureCoords, Texture texture, Colorf color) {
        this(coords, true, textureCoords, texture, color);
    }

    public Quad(Point3f[] coords, TexCoord2f[] textureCoords, String texture, Colorf color) {
        this(coords, true, textureCoords, TextureLoader.getInstance().getTextureOrNull(texture, Texture.MipmapMode.MULTI_LEVEL_MIPMAP), color);
    }

    public Quad(Point3f[] coords, TexCoord2f[] textureCoords, Texture texture) {
        this(coords, true, textureCoords, texture, null);
    }

    public Quad(Point3f[] coords, TexCoord2f[] textureCoords, String texture) {
        this(coords, true, textureCoords, texture, null);
    }

    public Quad(Point3f[] coords, Colorf color) {
        this(coords, true, (TexCoord2f[])null, (Texture)null, color);
    }

    public Quad(Point3f[] coords, Texture texture) {
        this(coords, true, (TexCoord2f[])null, texture, null);
    }

    public Quad(Point3f[] coords, String texture) {
        this(coords, true, (TexCoord2f[])null, texture, null);
    }

    public Quad(Point3f[] coords) {
        this(coords, true, (TexCoord2f[])null, (Texture)null, null);
    }

    private static final Tuple3f[] convertVertices(Tuple3f[] vertices) {
        Tuple3f v = vertices[2];
        vertices[2] = vertices[3];
        vertices[3] = v;
        return vertices;
    }

    private static final TexCoord2f[] convertTexCoords(TexCoord2f[] texCoords) {
        if (texCoords == null) {
            return null;
        }
        TexCoord2f t = texCoords[2];
        texCoords[2] = texCoords[3];
        texCoords[3] = t;
        return texCoords;
    }

    @Deprecated
    public Quad(Tuple3f[] vertices, Texture texture, TexCoord2f[] textureCoords, Colorf color) {
        this(Quad.convertVertices(vertices), true, Quad.convertTexCoords(textureCoords), texture, color != null ? color.getRed() : -1.0f, color != null ? color.getGreen() : -1.0f, color != null ? color.getBlue() : -1.0f, color != null && color.hasAlpha() ? color.getAlpha() : -1.0f);
    }

    @Deprecated
    public Quad(Tuple3f[] vertices, String texture, TexCoord2f[] textureCoords, Colorf color) {
        this(vertices, TextureLoader.getInstance().getTextureOrNull(texture, Texture.MipmapMode.MULTI_LEVEL_MIPMAP), Quad.convertTexCoords(textureCoords), color);
    }

    @Deprecated
    public Quad(Tuple3f[] vertices, Texture texture, TexCoord2f[] textureCoords) {
        this(vertices, texture, Quad.convertTexCoords(textureCoords), null);
    }

    @Deprecated
    public Quad(String texture, Tuple3f[] vertices, TexCoord2f[] textureCoords) {
        this(vertices, texture, Quad.convertTexCoords(textureCoords), null);
    }

    @Deprecated
    public Quad(Tuple3f[] vertices, Colorf color) {
        this(vertices, (Texture)null, (TexCoord2f[])null, color);
    }

    @Deprecated
    public Quad(Tuple3f[] vertices, String texture) {
        this(vertices, texture, (TexCoord2f[])null, null);
    }

    @Deprecated
    public Quad(Tuple3f[] vertices) {
        this(vertices, (Texture)null, (TexCoord2f[])null, null);
    }
}

