/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph.primitives;

import org.openmali.types.twodee.Dim2f;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.TexCoord2f;
import org.openmali.vecmath2.Tuple2f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.TupleNf;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.primitives.Quad;

public class Rectangle
extends Quad {
    private final Point3f[] coords;
    private final Vector3f offset = new Vector3f(0.0f, 0.0f, 0.0f);
    private ZeroPointLocation zpl = null;
    private final Dim2f size;

    public void setTexturePosition(Tuple2f texLowerLeft, Tuple2f texUpperRight) {
        TexCoord2f[] textureCoordinates = new TexCoord2f[]{new TexCoord2f(0.0f, 0.0f), new TexCoord2f(1.0f, 0.0f), new TexCoord2f(1.0f, 1.0f), new TexCoord2f(0.0f, 1.0f)};
        if (texLowerLeft != null) {
            textureCoordinates[0].setS(texLowerLeft.getX());
            textureCoordinates[0].setT(texLowerLeft.getY());
            textureCoordinates[1].setT(texLowerLeft.getY());
            textureCoordinates[3].setS(texLowerLeft.getX());
        }
        if (texUpperRight != null) {
            textureCoordinates[1].setS(texUpperRight.getX());
            textureCoordinates[3].setT(texUpperRight.getY());
            textureCoordinates[2].setS(texUpperRight.getX());
            textureCoordinates[2].setT(texUpperRight.getY());
        }
        this.setTextureCoordinates(textureCoordinates);
    }

    public void setTexturePosition(Tuple2f texUpperRight) {
        this.setTexturePosition(null, texUpperRight);
    }

    public void setTexture(Texture texture, Tuple2f texLowerLeft, Tuple2f texUpperRight) {
        if (texture != null) {
            this.setTexture(texture);
            this.setTexturePosition(texLowerLeft, texUpperRight);
        } else {
            Appearance app = this.getAppearance();
            if (app != null) {
                app.setTexture((Texture)null);
            }
        }
    }

    public void setTexture(String texture, Tuple2f texLowerLeft, Tuple2f texUpperRight) {
        this.setTexture(TextureLoader.getInstance().getTextureOrNull(texture, Texture.MipmapMode.MULTI_LEVEL_MIPMAP), texLowerLeft, texUpperRight);
    }

    public void setTexture(String texture) {
        this.setTexture(TextureLoader.getInstance().getTextureOrNull(texture, Texture.MipmapMode.MULTI_LEVEL_MIPMAP));
    }

    public Texture getTexture() {
        if (this.getAppearance() == null) {
            return null;
        }
        return this.getAppearance().getTexture();
    }

    protected static Tuple3f createPosition(float width, float height, ZeroPointLocation zpl, float zOffset, Vector3f result) {
        float posX = 0.0f;
        switch (zpl) {
            case TOP_LEFT: 
            case CENTER_LEFT: 
            case BOTTOM_LEFT: {
                posX = width / 2.0f;
                break;
            }
            case TOP_CENTER: 
            case CENTER_CENTER: 
            case BOTTOM_CENTER: {
                posX = 0.0f;
                break;
            }
            case TOP_RIGHT: 
            case CENTER_RIGHT: 
            case BOTTOM_RIGHT: {
                posX = -width / 2.0f;
            }
        }
        float posY = 0.0f;
        switch (zpl) {
            case TOP_LEFT: 
            case TOP_CENTER: 
            case TOP_RIGHT: {
                posY = -height / 2.0f;
                break;
            }
            case CENTER_LEFT: 
            case CENTER_CENTER: 
            case CENTER_RIGHT: {
                posY = 0.0f;
                break;
            }
            case BOTTOM_LEFT: 
            case BOTTOM_CENTER: 
            case BOTTOM_RIGHT: {
                posY = height / 2.0f;
            }
        }
        result.set(posX, posY, zOffset);
        return result;
    }

    protected static Tuple3f createPosition(float width, float height, ZeroPointLocation zpl, Tuple3f offset) {
        float posX = 0.0f;
        switch (zpl) {
            case TOP_LEFT: 
            case CENTER_LEFT: 
            case BOTTOM_LEFT: {
                posX = width / 2.0f;
                break;
            }
            case TOP_CENTER: 
            case CENTER_CENTER: 
            case BOTTOM_CENTER: {
                posX = 0.0f;
                break;
            }
            case TOP_RIGHT: 
            case CENTER_RIGHT: 
            case BOTTOM_RIGHT: {
                posX = -width / 2.0f;
            }
        }
        float posY = 0.0f;
        switch (zpl) {
            case TOP_LEFT: 
            case TOP_CENTER: 
            case TOP_RIGHT: {
                posY = -height / 2.0f;
                break;
            }
            case CENTER_LEFT: 
            case CENTER_CENTER: 
            case CENTER_RIGHT: {
                posY = 0.0f;
                break;
            }
            case BOTTOM_LEFT: 
            case BOTTOM_CENTER: 
            case BOTTOM_RIGHT: {
                posY = height / 2.0f;
            }
        }
        return new Point3f(offset.getX() + posX, offset.getY() + posY, offset.getZ());
    }

    public Dim2f getSize() {
        return this.size;
    }

    public final float getWidth() {
        return this.size.getWidth();
    }

    public final float getHeight() {
        return this.size.getHeight();
    }

    public boolean resize(float width, float height, float xOffset, float yOffset, float zOffset) {
        if (width == this.size.getWidth() && height == this.size.getHeight() && xOffset == this.offset.getX() && yOffset == this.offset.getY() && zOffset == this.offset.getZ()) {
            return false;
        }
        this.offset.set(xOffset, yOffset, zOffset);
        this.coords[0].set(xOffset - width / 2.0f, yOffset - height / 2.0f, zOffset);
        this.coords[1].set(xOffset + width / 2.0f, yOffset - height / 2.0f, zOffset);
        this.coords[2].set(xOffset + width / 2.0f, yOffset + height / 2.0f, zOffset);
        this.coords[3].set(xOffset - width / 2.0f, yOffset + height / 2.0f, zOffset);
        this.setVertexCoords(this.coords);
        this.size.set(width, height);
        return true;
    }

    public final boolean resize(float width, float height, Tuple3f offset) {
        return this.resize(width, height, offset.getX(), offset.getY(), offset.getZ());
    }

    public final boolean resize(float width, float height) {
        if (this.zpl != null) {
            Rectangle.createPosition(width, height, this.zpl, this.offset.getZ(), this.offset);
        }
        return this.resize(width, height, this.offset);
    }

    public final boolean resize(Tuple2f size, float xOffset, float yOffset, float zOffset) {
        return this.resize(size.getX(), size.getY(), xOffset, yOffset, zOffset);
    }

    public final boolean resize(Tuple2f size, Tuple3f offset) {
        return this.resize(size.getX(), size.getY(), offset.getX(), offset.getY(), offset.getZ());
    }

    public final boolean resize(Tuple2f size) {
        return this.resize(size.getX(), size.getY(), this.offset);
    }

    public static Point3f[] createVertexCoords(float width, float height, float offX, float offY, float offZ) {
        Point3f[] coords = new Point3f[]{new Point3f(offX - width / 2.0f, offY - height / 2.0f, offZ), new Point3f(offX + width / 2.0f, offY - height / 2.0f, offZ), new Point3f(offX + width / 2.0f, offY + height / 2.0f, offZ), new Point3f(offX - width / 2.0f, offY + height / 2.0f, offZ)};
        return coords;
    }

    public static Point3f[] createVertexCoords(float width, float height, Tuple3f offset) {
        if (offset == null) {
            return Rectangle.createVertexCoords(width, height, 0.0f, 0.0f, 0.0f);
        }
        return Rectangle.createVertexCoords(width, height, offset.getX(), offset.getY(), offset.getZ());
    }

    public static TexCoord2f[] createTextureCoordinates(Tuple2f texLowerLeft, Tuple2f texUpperRight) {
        TexCoord2f[] textureCoordinates = new TexCoord2f[]{new TexCoord2f(0.0f, 0.0f), new TexCoord2f(1.0f, 0.0f), new TexCoord2f(1.0f, 1.0f), new TexCoord2f(0.0f, 1.0f)};
        if (texLowerLeft != null) {
            textureCoordinates[0].setS(texLowerLeft.getX());
            textureCoordinates[0].setT(texLowerLeft.getY());
            textureCoordinates[1].setT(texLowerLeft.getY());
            textureCoordinates[3].setS(texLowerLeft.getX());
        }
        if (texUpperRight != null) {
            textureCoordinates[1].setS(texUpperRight.getX());
            textureCoordinates[3].setT(texUpperRight.getY());
            textureCoordinates[2].setS(texUpperRight.getX());
            textureCoordinates[2].setT(texUpperRight.getY());
        }
        return textureCoordinates;
    }

    private Rectangle(float width, float height, Tuple3f offset, boolean generateNormals, Texture texture, Tuple2f texLowerLeft, Tuple2f texUpperRight, Colorf color) {
        super(Rectangle.createVertexCoords(width, height, offset), generateNormals, color == null ? Rectangle.createTextureCoordinates(texLowerLeft, texUpperRight) : null, texture, color);
        if (offset != null) {
            this.offset.set((TupleNf)offset);
        }
        this.coords = new Point3f[this.getGeometry().getVertexCount()];
        for (int i = 0; i < this.coords.length; ++i) {
            this.coords[i] = new Point3f();
            this.getGeometry().getCoordinate(i, this.coords[i]);
        }
        this.size = new Dim2f(width, height);
    }

    private Rectangle(float width, float height, Tuple3f offset, boolean generateNormals, String texture, Tuple2f texLowerLeft, Tuple2f texUpperRight, Colorf color) {
        this(width, height, offset, generateNormals, TextureLoader.getInstance().getTexture(texture), texLowerLeft, texUpperRight, color);
    }

    private Rectangle(float width, float height, ZeroPointLocation zpl, Tuple3f offset, boolean generateNormals, Texture texture, Tuple2f texLowerLeft, Tuple2f texUpperRight, Colorf color) {
        this(width, height, Rectangle.createPosition(width, height, zpl, offset), generateNormals, texture, texLowerLeft, texUpperRight, color);
        this.zpl = zpl;
    }

    private Rectangle(float width, float height, ZeroPointLocation zpl, Tuple3f offset, boolean generateNormals, String texture, Tuple2f texLowerLeft, Tuple2f texUpperRight, Colorf color) {
        this(width, height, Rectangle.createPosition(width, height, zpl, offset), generateNormals, TextureLoader.getInstance().getTexture(texture), texLowerLeft, texUpperRight, color);
        this.zpl = zpl;
    }

    private Rectangle(float width, float height, ZeroPointLocation zpl, float zOffset, boolean generateNormals, Texture texture, Tuple2f texLowerLeft, Tuple2f texUpperRight, Colorf color) {
        this(width, height, Rectangle.createPosition(width, height, zpl, zOffset, new Vector3f()), generateNormals, texture, texLowerLeft, texUpperRight, color);
        this.zpl = zpl;
    }

    private Rectangle(float width, float height, ZeroPointLocation zpl, float zOffset, boolean generateNormals, String texture, Tuple2f texLowerLeft, Tuple2f texUpperRight, Colorf color) {
        this(width, height, Rectangle.createPosition(width, height, zpl, zOffset, new Vector3f()), generateNormals, TextureLoader.getInstance().getTexture(texture), texLowerLeft, texUpperRight, color);
        this.zpl = zpl;
    }

    public Rectangle(float width, float height, Tuple3f offset, Texture texture, Tuple2f texLowerLeft, Tuple2f texUpperRight, Colorf color) {
        this(width, height, offset, true, texture, texLowerLeft, texUpperRight, color);
    }

    public Rectangle(float width, float height, Tuple3f offset, String texture, Tuple2f texLowerLeft, Tuple2f texUpperRight, Colorf color) {
        this(width, height, offset, true, texture, texLowerLeft, texUpperRight, color);
    }

    public Rectangle(float width, float height, Texture texture) {
        this(width, height, (Tuple3f)null, texture, null, null, null);
    }

    public Rectangle(float width, float height, String texture) {
        this(width, height, (Tuple3f)null, texture, null, null, null);
    }

    public Rectangle(float width, float height, Tuple3f offset, String texture) {
        this(width, height, offset, texture, null, null);
    }

    public Rectangle(float width, float height, float zOffset, String texture) {
        this(width, height, new Tuple3f(0.0f, 0.0f, zOffset), true, texture, null, null, null);
    }

    public Rectangle(float width, float height, float zOffset) {
        this(width, height, new Tuple3f(0.0f, 0.0f, zOffset), (Texture)null, null, null, null);
    }

    public Rectangle(float width, float height, Tuple3f offset) {
        this(width, height, offset, (Texture)null, null, null, null);
    }

    public Rectangle(float width, float height) {
        this(width, height, null, (Texture)null, null, null, null);
    }

    public Rectangle(float width, float height, Tuple3f offset, String texture, Tuple2f texLowerLeft, Tuple2f texUpperRight) {
        this(width, height, offset, texture, texLowerLeft, texUpperRight, null);
    }

    @Deprecated
    public Rectangle(Texture texture, float width, float height) {
        this(width, height, (Tuple3f)null, texture, null, null, null);
    }

    public Rectangle(float width, float height, Tuple3f offset, Texture texture) {
        this(width, height, offset, texture, null, null, null);
    }

    public Rectangle(float width, float height, float zOffset, Texture texture) {
        this(width, height, new Tuple3f(0.0f, 0.0f, zOffset), texture, null, null, null);
    }

    public Rectangle(float width, float height, float zOffset, Texture texture, Tuple2f texLowerLeft, Tuple2f texUpperRight) {
        this(width, height, new Tuple3f(0.0f, 0.0f, zOffset), texture, texLowerLeft, texUpperRight, null);
    }

    public Rectangle(float width, float height, Texture texture, Tuple2f texLowerLeft, Tuple2f texUpperRight) {
        this(width, height, (Tuple3f)null, texture, texLowerLeft, texUpperRight, null);
    }

    public Rectangle(float width, float height, Tuple3f offset, Texture texture, Tuple2f texLowerLeft, Tuple2f texUpperRight) {
        this(width, height, offset, texture, texLowerLeft, texUpperRight, null);
    }

    public Rectangle(float width, float height, Tuple3f offset, Colorf color) {
        this(width, height, offset, (Texture)null, null, null, color);
    }

    public Rectangle(float width, float height, float zOffset, Colorf color) {
        this(width, height, new Tuple3f(0.0f, 0.0f, zOffset), (Texture)null, null, null, color);
    }

    public Rectangle(float width, float height, Colorf color) {
        this(width, height, null, (Texture)null, null, null, color);
    }

    protected Rectangle(float width, float height, boolean generateNormals, ZeroPointLocation zpl, Texture texture) {
        this(width, height, zpl, 0.0f, generateNormals, texture, null, null, (Colorf)null);
    }

    public Rectangle(float width, float height, ZeroPointLocation zpl, Texture texture) {
        this(width, height, zpl, 0.0f, true, texture, null, null, (Colorf)null);
    }

    public Rectangle(float width, float height, ZeroPointLocation zpl, float zOffset, Texture texture) {
        this(width, height, zpl, zOffset, true, texture, null, null, (Colorf)null);
    }

    public Rectangle(float width, float height, ZeroPointLocation zpl, Texture texture, Tuple2f texLowerLeft, Tuple2f texUpperRight) {
        this(width, height, zpl, 0.0f, true, texture, texLowerLeft, texUpperRight, (Colorf)null);
    }

    public Rectangle(float width, float height, ZeroPointLocation zpl, float zOffset, Texture texture, Tuple2f texLowerLeft, Tuple2f texUpperRight) {
        this(width, height, zpl, zOffset, true, texture, texLowerLeft, texUpperRight, (Colorf)null);
    }

    public Rectangle(float width, float height, ZeroPointLocation zpl, String texture) {
        this(width, height, zpl, 0.0f, true, texture, null, null, null);
    }

    public Rectangle(float width, float height, ZeroPointLocation zpl, float zOffset, String texture) {
        this(width, height, zpl, zOffset, true, texture, null, null, null);
    }

    public Rectangle(float width, float height, ZeroPointLocation zpl, String texture, Tuple2f texLowerLeft, Tuple2f texUpperRight) {
        this(width, height, zpl, 0.0f, true, texture, texLowerLeft, texUpperRight, (Colorf)null);
    }

    public Rectangle(float width, float height, ZeroPointLocation zpl, float zOffset) {
        this(width, height, zpl, zOffset, true, (Texture)null, null, null, (Colorf)null);
    }

    public Rectangle(float width, float height, ZeroPointLocation zpl) {
        this(width, height, zpl, 0.0f, true, (Texture)null, null, null, (Colorf)null);
    }

    public Rectangle(float width, float height, ZeroPointLocation zpl, float zOffset, Colorf color) {
        this(width, height, zpl, zOffset, true, (Texture)null, null, null, color);
    }

    public Rectangle(float width, float height, ZeroPointLocation zpl, Colorf color) {
        this(width, height, zpl, 0.0f, true, (Texture)null, null, null, color);
    }

    public Rectangle(float width, float height, ZeroPointLocation zpl, Tuple3f offset, Colorf color) {
        this(width, height, zpl, offset, true, (Texture)null, null, null, color);
    }

    public Rectangle(float width, float height, ZeroPointLocation zpl, Tuple3f offset, String texture) {
        this(width, height, zpl, offset, true, texture, null, null, null);
    }

    public Rectangle(float width, float height, ZeroPointLocation zpl, Tuple3f offset, String texture, Tuple2f texLowerLeft, Tuple2f texUpperRight) {
        this(width, height, zpl, offset, true, texture, texLowerLeft, texUpperRight, null);
    }

    public Rectangle(float width, float height, ZeroPointLocation zpl, Tuple3f offset, Texture texture) {
        this(width, height, zpl, offset, true, texture, null, null, null);
    }

    public Rectangle(float width, float height, ZeroPointLocation zpl, Tuple3f offset, Texture texture, Tuple2f texLowerLeft, Tuple2f texUpperRight) {
        this(width, height, zpl, offset, true, texture, texLowerLeft, texUpperRight, null);
    }

    public static final Rectangle createWithoutNormals(float width, float height, Tuple3f offset, Texture texture, Tuple2f texLowerLeft, Tuple2f texUpperRight, Colorf color) {
        return new Rectangle(width, height, offset, false, texture, texLowerLeft, texUpperRight, color);
    }

    public static final Rectangle createWithoutNormals(float width, float height, Tuple3f offset, String texture, Tuple2f texLowerLeft, Tuple2f texUpperRight, Colorf color) {
        return new Rectangle(width, height, offset, false, texture, texLowerLeft, texUpperRight, color);
    }

    public static final Rectangle createWithoutNormals(float width, float height, Texture texture) {
        return new Rectangle(width, height, (Tuple3f)null, false, texture, null, null, null);
    }

    public static final Rectangle createWithoutNormals(float width, float height, String texture) {
        return new Rectangle(width, height, (Tuple3f)null, false, texture, null, null, null);
    }

    public static final Rectangle createWithoutNormals(float width, float height, Tuple3f offset, String texture) {
        return new Rectangle(width, height, offset, false, texture, null, null, null);
    }

    public static final Rectangle createWithoutNormals(float width, float height, float zOffset, String texture) {
        return new Rectangle(width, height, new Tuple3f(0.0f, 0.0f, zOffset), false, texture, null, null, null);
    }

    public static final Rectangle createWithoutNormals(float width, float height, float zOffset) {
        return new Rectangle(width, height, new Tuple3f(0.0f, 0.0f, zOffset), false, (Texture)null, null, null, null);
    }

    public static final Rectangle createWithoutNormals(float width, float height, Tuple3f offset) {
        return new Rectangle(width, height, offset, false, (Texture)null, null, null, null);
    }

    public static final Rectangle createWithoutNormals(float width, float height) {
        return new Rectangle(width, height, null, false, (Texture)null, null, null, null);
    }

    public static final Rectangle createWithoutNormals(float width, float height, Tuple3f offset, String texture, Tuple2f texLowerLeft, Tuple2f texUpperRight) {
        return new Rectangle(width, height, offset, false, texture, texLowerLeft, texUpperRight, null);
    }

    public static final Rectangle createWithoutNormals(float width, float height, Tuple3f offset, Texture texture) {
        return new Rectangle(width, height, offset, false, texture, null, null, null);
    }

    public static final Rectangle createWithoutNormals(float width, float height, float zOffset, Texture texture) {
        return new Rectangle(width, height, new Tuple3f(0.0f, 0.0f, zOffset), false, texture, null, null, null);
    }

    public static final Rectangle createWithoutNormals(float width, float height, float zOffset, Texture texture, Tuple2f texLowerLeft, Tuple2f texUpperRight) {
        return new Rectangle(width, height, new Tuple3f(0.0f, 0.0f, zOffset), false, texture, texLowerLeft, texUpperRight, null);
    }

    public static final Rectangle createWithoutNormals(float width, float height, Texture texture, Tuple2f texLowerLeft, Tuple2f texUpperRight) {
        return new Rectangle(width, height, (Tuple3f)null, false, texture, texLowerLeft, texUpperRight, null);
    }

    public static final Rectangle createWithoutNormals(float width, float height, Tuple3f offset, Texture texture, Tuple2f texLowerLeft, Tuple2f texUpperRight) {
        return new Rectangle(width, height, offset, false, texture, texLowerLeft, texUpperRight, null);
    }

    public static final Rectangle createWithoutNormals(float width, float height, Tuple3f offset, Colorf color) {
        return new Rectangle(width, height, offset, false, (Texture)null, null, null, color);
    }

    public static final Rectangle createWithoutNormals(float width, float height, float zOffset, Colorf color) {
        return new Rectangle(width, height, new Tuple3f(0.0f, 0.0f, zOffset), false, (Texture)null, null, null, color);
    }

    public static final Rectangle createWithoutNormals(float width, float height, Colorf color) {
        return new Rectangle(width, height, null, false, (Texture)null, null, null, color);
    }

    public static final Rectangle createWithoutNormals(float width, float height, ZeroPointLocation zpl, Texture texture) {
        return new Rectangle(width, height, zpl, 0.0f, false, texture, null, null, (Colorf)null);
    }

    public static final Rectangle createWithoutNormals(float width, float height, ZeroPointLocation zpl, float zOffset, Texture texture) {
        return new Rectangle(width, height, zpl, zOffset, false, texture, null, null, (Colorf)null);
    }

    public static final Rectangle createWithoutNormals(float width, float height, ZeroPointLocation zpl, Texture texture, Tuple2f texLowerLeft, Tuple2f texUpperRight) {
        return new Rectangle(width, height, zpl, 0.0f, false, texture, texLowerLeft, texUpperRight, (Colorf)null);
    }

    public static final Rectangle createWithoutNormals(float width, float height, ZeroPointLocation zpl, float zOffset, Texture texture, Tuple2f texLowerLeft, Tuple2f texUpperRight) {
        return new Rectangle(width, height, zpl, zOffset, false, texture, texLowerLeft, texUpperRight, (Colorf)null);
    }

    public static final Rectangle createWithoutNormals(float width, float height, ZeroPointLocation zpl, String texture) {
        return new Rectangle(width, height, zpl, 0.0f, false, texture, null, null, null);
    }

    public static final Rectangle createWithoutNormals(float width, float height, ZeroPointLocation zpl, float zOffset, String texture) {
        return new Rectangle(width, height, zpl, zOffset, false, texture, null, null, null);
    }

    public static final Rectangle createWithoutNormals(float width, float height, ZeroPointLocation zpl, String texture, Tuple2f texLowerLeft, Tuple2f texUpperRight) {
        return new Rectangle(width, height, zpl, 0.0f, false, texture, texLowerLeft, texUpperRight, null);
    }

    public static final Rectangle createWithoutNormals(float width, float height, ZeroPointLocation zpl, float zOffset) {
        return new Rectangle(width, height, zpl, 0.0f, false, (Texture)null, null, null, null);
    }

    public static final Rectangle createWithoutNormals(float width, float height, ZeroPointLocation zpl) {
        return new Rectangle(width, height, zpl, 0.0f, false, (Texture)null, null, null, null);
    }

    public static final Rectangle createWithoutNormals(float width, float height, ZeroPointLocation zpl, float zOffset, Colorf color) {
        return new Rectangle(width, height, zpl, zOffset, false, (Texture)null, null, null, color);
    }

    public static final Rectangle createWithoutNormals(float width, float height, ZeroPointLocation zpl, Colorf color) {
        return new Rectangle(width, height, zpl, 0.0f, false, (Texture)null, null, null, color);
    }

    public static final Rectangle createWithoutNormals(float width, float height, ZeroPointLocation zpl, Tuple3f offset, Colorf color) {
        return new Rectangle(width, height, zpl, offset, false, (Texture)null, null, null, color);
    }

    public static final Rectangle createWithoutNormals(float width, float height, ZeroPointLocation zpl, Tuple3f offset, String texture) {
        return new Rectangle(width, height, zpl, offset, false, texture, null, null, null);
    }

    public static final Rectangle createWithoutNormals(float width, float height, ZeroPointLocation zpl, Tuple3f offset, String texture, Tuple2f texLowerLeft, Tuple2f texUpperRight) {
        return new Rectangle(width, height, offset, false, texture, texLowerLeft, texUpperRight, null);
    }

    public static final Rectangle createWithoutNormals(float width, float height, ZeroPointLocation zpl, Tuple3f offset, Texture texture) {
        return new Rectangle(width, height, zpl, offset, false, texture, null, null, null);
    }

    public static final Rectangle createWithoutNormals(float width, float height, ZeroPointLocation zpl, Tuple3f offset, Texture texture, Tuple2f texLowerLeft, Tuple2f texUpperRight) {
        return new Rectangle(width, height, zpl, offset, false, texture, texLowerLeft, texUpperRight, null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ZeroPointLocation {
        TOP_LEFT,
        TOP_CENTER,
        TOP_RIGHT,
        CENTER_LEFT,
        CENTER_CENTER,
        CENTER_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_CENTER,
        BOTTOM_RIGHT;

    }
}

