/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph.primitives;

import org.jagatoo.opengl.enums.TextureBoundaryMode;
import org.jagatoo.opengl.enums.TextureFormat;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.TexCoord2f;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.render.BackgroundRenderPass;
import org.xith3d.render.BaseRenderPassConfig;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.Geometry;
import org.xith3d.scenegraph.GroupNode;
import org.xith3d.scenegraph.RenderingAttributes;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.TriangleStripArray;
import org.xith3d.scenegraph.View;
import org.xith3d.utility.texturing.CubeTextureSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SkyBox
extends BackgroundRenderPass {
    private static final boolean DEFAULT_TEXTURE_FLIP = false;
    private static final float DEFAULT_SIZE = 20.0f;

    public static <G extends GroupNode> G createSkyBoxGroup(float size, Texture[] textures, G group) {
        if (textures.length != 6) {
            throw new IllegalArgumentException("The given array of Textures MUST be of length 6.");
        }
        float halfSize = size / 2.0f;
        Point3f leftTopFront = new Point3f(-halfSize, halfSize, halfSize);
        Point3f rightTopFront = new Point3f(halfSize, halfSize, halfSize);
        Point3f rightBottomFront = new Point3f(halfSize, -halfSize, halfSize);
        Point3f leftBottomFront = new Point3f(-halfSize, -halfSize, halfSize);
        Point3f leftTopBack = new Point3f(-halfSize, halfSize, -halfSize);
        Point3f rightTopBack = new Point3f(halfSize, halfSize, -halfSize);
        Point3f rightBottomBack = new Point3f(halfSize, -halfSize, -halfSize);
        Point3f leftBottomBack = new Point3f(-halfSize, -halfSize, -halfSize);
        Point3f[][] vertices = new Point3f[][]{{leftTopFront, rightTopFront, leftBottomFront, rightBottomFront}, {rightTopFront, rightTopBack, rightBottomFront, rightBottomBack}, {rightTopBack, leftTopBack, rightBottomBack, leftBottomBack}, {leftTopBack, leftTopFront, leftBottomBack, leftBottomFront}, {leftTopBack, rightTopBack, leftTopFront, rightTopFront}, {leftBottomFront, rightBottomFront, leftBottomBack, rightBottomBack}};
        TexCoord2f[] texCoords = new TexCoord2f[]{new TexCoord2f(0.0f, 1.0f), new TexCoord2f(1.0f, 1.0f), new TexCoord2f(0.0f, 0.0f), new TexCoord2f(1.0f, 0.0f)};
        Shape3D[] sh = new Shape3D[6];
        RenderingAttributes ra = new RenderingAttributes();
        ra.setDepthBufferWriteEnabled(false);
        for (int i = 0; i < sh.length; ++i) {
            if (textures[i] == null) continue;
            TriangleStripArray quads = new TriangleStripArray(vertices[i].length);
            quads.setOptimization(Geometry.Optimization.USE_VBOS);
            quads.setCoordinates(0, vertices[i]);
            quads.setTextureCoordinates(0, 0, texCoords);
            Texture texture = textures[i];
            texture.setBoundaryModeS(TextureBoundaryMode.CLAMP_TO_EDGE);
            texture.setBoundaryModeT(TextureBoundaryMode.CLAMP_TO_EDGE);
            Appearance a = new Appearance();
            a.setRenderingAttributes(ra);
            a.setTexture(texture);
            sh[i] = new Shape3D(quads, a);
            group.addChild(sh[i]);
        }
        group.setPickableRecursive(false);
        return group;
    }

    public static <G extends GroupNode> G createSkyBoxGroup(Texture[] textures, G group) {
        return SkyBox.createSkyBoxGroup(20.0f, textures, group);
    }

    public static BranchGroup createSkyBoxGroup(float size, Texture[] textures) {
        BranchGroup skybox = new BranchGroup();
        SkyBox.createSkyBoxGroup(size, textures, skybox);
        return skybox;
    }

    public static final BranchGroup createSkyBoxGroup(Texture front, Texture right, Texture back, Texture left, Texture top, Texture bottom) {
        return SkyBox.createSkyBoxGroup(20.0f, new Texture[]{front, right, back, left, top, bottom});
    }

    public static final BranchGroup createSkyBoxGroup(String[] textures, boolean flipTextures) {
        return SkyBox.createSkyBoxGroup(textures[0], textures[1], textures[2], textures[3], textures[4], textures[5], flipTextures);
    }

    public static final BranchGroup createSkyBoxGroup(String[] textures) {
        return SkyBox.createSkyBoxGroup(textures, false);
    }

    private static Texture getTextureOrNull(String texture, boolean flipVertically) {
        if (texture == null) {
            return null;
        }
        TextureLoader tl = TextureLoader.getInstance();
        tl.getCache().pushEnabled(false);
        TextureLoader.FlipMode flipMode = flipVertically ? TextureLoader.FlipMode.NOT_FLIPPED : TextureLoader.FlipMode.FLIPPED_VERTICALLY;
        Texture2D tex = tl.getTexture(texture, flipMode, TextureFormat.RGB, Texture.MipmapMode.BASE_LEVEL);
        tl.getCache().popEnabled();
        tex.enableAutoFreeLocalData();
        return tex;
    }

    private static Texture[] createTexturesArray(String front, String right, String back, String left, String top, String bottom, boolean flipVertically) {
        Texture[] textures = new Texture[]{SkyBox.getTextureOrNull(front, flipVertically), SkyBox.getTextureOrNull(right, flipVertically), SkyBox.getTextureOrNull(back, flipVertically), SkyBox.getTextureOrNull(left, flipVertically), SkyBox.getTextureOrNull(top, flipVertically), SkyBox.getTextureOrNull(bottom, flipVertically)};
        for (int i = 0; i < textures.length; ++i) {
            textures[i].setBoundaryModeS(TextureBoundaryMode.CLAMP_TO_EDGE);
            textures[i].setBoundaryModeT(TextureBoundaryMode.CLAMP_TO_EDGE);
        }
        return textures;
    }

    public static final BranchGroup createSkyBoxGroup(String front, String right, String back, String left, String top, String bottom, boolean flipVertically) {
        return SkyBox.createSkyBoxGroup(20.0f, SkyBox.createTexturesArray(front, right, back, left, top, bottom, flipVertically));
    }

    public static final BranchGroup createSkyBoxGroup(String front, String right, String back, String left, String top, String bottom) {
        return SkyBox.createSkyBoxGroup(front, right, back, left, top, bottom, false);
    }

    public static final BranchGroup createSkyBoxGroup(CubeTextureSet textureSet) {
        return SkyBox.createSkyBoxGroup(textureSet.getFrontTexture(), textureSet.getRightTexture(), textureSet.getBackTexture(), textureSet.getLeftTexture(), textureSet.getTopTexture(), textureSet.getBottomTexture());
    }

    public SkyBox(Texture[] textures) {
        super(SkyBox.createSkyBoxGroup(20.0f, textures), new BaseRenderPassConfig(View.CameraMode.VIEW_FIXED_POSITION));
    }

    public SkyBox(Texture front, Texture right, Texture back, Texture left, Texture top, Texture bottom) {
        this(new Texture[]{front, right, back, left, top, bottom});
    }

    public SkyBox(String[] textures, boolean flipVertically) {
        this(textures[0], textures[1], textures[2], textures[3], textures[4], textures[5], flipVertically);
    }

    public SkyBox(String[] textures) {
        this(textures, false);
    }

    public SkyBox(String front, String right, String back, String left, String top, String bottom, boolean flipVertically) {
        this(SkyBox.createTexturesArray(front, right, back, left, top, bottom, flipVertically));
    }

    public SkyBox(String front, String right, String back, String left, String top, String bottom) {
        this(front, right, back, left, top, bottom, false);
    }

    public SkyBox(CubeTextureSet textureSet) {
        this(textureSet.getFrontTexture(), textureSet.getRightTexture(), textureSet.getBackTexture(), textureSet.getLeftTexture(), textureSet.getTopTexture(), textureSet.getBottomTexture());
    }
}

