/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph.primitives;

import org.openmali.FastMath;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.TexCoord2f;
import org.openmali.vecmath2.TexCoord3f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.Geometry;
import org.xith3d.scenegraph.IndexedTriangleArray;
import org.xith3d.scenegraph.IndexedTriangleStripArray;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.StaticTransform;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.TriangleArray;
import org.xith3d.scenegraph.TriangleStripArray;
import org.xith3d.scenegraph.primitives.GeomFactory;
import org.xith3d.scenegraph.primitives.GeometryConstruct;
import org.xith3d.scenegraph.primitives.GeometryType;

public class Torus
extends Shape3D {
    private static GeometryType geomConstructTypeHint = GeometryType.INDEXED_TRIANGLE_STRIP_ARRAY;

    public static void setGeometryConstructionTypeHint(GeometryType hint) {
        switch (hint) {
            case INDEXED_TRIANGLE_STRIP_ARRAY: 
            case INDEXED_TRIANGLE_ARRAY: 
            case TRIANGLE_STRIP_ARRAY: 
            case TRIANGLE_ARRAY: {
                geomConstructTypeHint = hint;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Currently " + Torus.class.getSimpleName() + " does not support " + (Object)((Object)hint));
            }
        }
    }

    public static GeometryType getGeometryConstructionTypeHint() {
        return geomConstructTypeHint;
    }

    private static void rotateTupleZ(Tuple3f t, float angle) {
        float sin = FastMath.sin(angle);
        float cos = FastMath.cos(angle);
        t.set(t.getX() * cos - t.getY() * sin, t.getX() * sin + t.getY() * cos, t.getZ());
    }

    public static GeometryConstruct createGeometryConstructITSA(float alpha, int radSlices, int conSlices, int features, boolean colorAlpha, int texCoordsSize) {
        int i;
        if (radSlices < 3 || conSlices < 3) {
            throw new IllegalArgumentException("radSlices and conSlices <=3");
        }
        float radius = (1.0f - alpha) / 2.0f;
        Tuple3f[] vertices = null;
        int[] indices = null;
        Vector3f[] normals = null;
        TexCoord2f[] texCoords2 = null;
        TexCoord3f[] texCoords3 = null;
        int stackLen = radSlices * 2 + 2;
        vertices = new Point3f[(radSlices + 1) * (conSlices + 1)];
        indices = new int[stackLen * conSlices];
        if ((features & 2) > 0) {
            normals = new Vector3f[vertices.length];
        }
        if ((features & 8) != 0) {
            if (texCoordsSize == 2) {
                texCoords2 = new TexCoord2f[vertices.length];
            } else if (texCoordsSize == 3) {
                texCoords3 = new TexCoord3f[vertices.length];
            }
        }
        for (int j = 0; j < conSlices + 1; ++j) {
            float angleXZl = (float)j * ((float)Math.PI * 2) / (float)conSlices;
            for (i = 0; i < radSlices + 1; ++i) {
                float angleXY = (float)i * ((float)Math.PI * 2) / (float)radSlices;
                float x = FastMath.cos(angleXY);
                float y = FastMath.sin(angleXY);
                int k = j * (radSlices + 1) + i;
                vertices[k] = new Point3f(alpha + radius + x * radius, 0.0f, -y * radius);
                Torus.rotateTupleZ(vertices[k], angleXZl);
                if (j < conSlices) {
                    int idx = j * stackLen + i * 2;
                    indices[idx + 0] = k;
                    indices[idx + 1] = k + radSlices + 1;
                }
                if (normals != null) {
                    normals[k] = new Vector3f(x * radius, 0.0f, -y * radius);
                    Torus.rotateTupleZ(normals[k], angleXZl);
                    normals[k].normalize();
                }
                if (texCoords2 != null) {
                    float tx = (float)i * 1.0f / (float)radSlices;
                    texCoords2[k] = new TexCoord2f(tx, (float)(j + 0) * 1.0f / (float)conSlices);
                }
                if (texCoords3 == null) continue;
                float tx = (float)i * 1.0f / (float)radSlices;
                texCoords3[k] = new TexCoord3f(tx, (float)(j + 0) * 1.0f / (float)conSlices, 0.0f);
            }
        }
        Colorf[] colors = null;
        if ((features & 4) != 0) {
            colors = GeomFactory.generateColors(colorAlpha, vertices);
        }
        int[] stripLengths = new int[conSlices];
        for (i = 0; i < conSlices; ++i) {
            stripLengths[i] = indices.length / conSlices;
        }
        if (texCoords3 != null) {
            return new GeometryConstruct(GeometryType.INDEXED_TRIANGLE_STRIP_ARRAY, vertices, normals, texCoords3, colors, indices, stripLengths);
        }
        return new GeometryConstruct(GeometryType.INDEXED_TRIANGLE_STRIP_ARRAY, vertices, normals, texCoords2, colors, indices, stripLengths);
    }

    public static IndexedTriangleStripArray createGeometryITSA(float alpha, int radSlices, int conSlices, int features, boolean colorAlpha, int texCoordsSize) {
        GeometryConstruct gcITSA = Torus.createGeometryConstructITSA(alpha, radSlices, conSlices, features |= 1, colorAlpha, texCoordsSize);
        return GeomFactory.createIndexedTriangleStripArray(gcITSA);
    }

    public static GeometryConstruct createGeometryConstructITA(float alpha, int radSlices, int conSlices, int features, boolean colorAlpha, int texCoordsSize) {
        GeometryConstruct gcITSA = Torus.createGeometryConstructITSA(alpha, radSlices, conSlices, features |= 1, colorAlpha, texCoordsSize);
        return GeomFactory.convertGeometryConstructITSA2ITA(gcITSA);
    }

    public static IndexedTriangleArray createGeometryITA(float alpha, int radSlices, int conSlices, int features, boolean colorAlpha, int texCoordsSize) {
        GeometryConstruct gcITSA = Torus.createGeometryConstructITSA(alpha, radSlices, conSlices, features |= 1, colorAlpha, texCoordsSize);
        return GeomFactory.createITAfromITSA(gcITSA);
    }

    public static GeometryConstruct createGeometryConstructTSA(float alpha, int radSlices, int conSlices, int features, boolean colorAlpha, int texCoordsSize) {
        GeometryConstruct gcITSA = Torus.createGeometryConstructITSA(alpha, radSlices, conSlices, features |= 1, colorAlpha, texCoordsSize);
        return GeomFactory.convertGeometryConstructITSA2TSA(gcITSA);
    }

    public static TriangleStripArray createGeometryTSA(float alpha, int radSlices, int conSlices, int features, boolean colorAlpha, int texCoordsSize) {
        GeometryConstruct gcITSA = Torus.createGeometryConstructITSA(alpha, radSlices, conSlices, features |= 1, colorAlpha, texCoordsSize);
        return GeomFactory.createTSAfromITSA(gcITSA);
    }

    public static GeometryConstruct createGeometryConstructTA(float alpha, int radSlices, int conSlices, int features, boolean colorAlpha, int texCoordsSize) {
        GeometryConstruct gcITSA = Torus.createGeometryConstructITSA(alpha, radSlices, conSlices, features |= 1, colorAlpha, texCoordsSize);
        return GeomFactory.convertGeometryConstructITSA2TA(gcITSA);
    }

    public static TriangleArray createGeometryTA(float alpha, int radSlices, int conSlices, int features, boolean colorAlpha, int texCoordsSize) {
        GeometryConstruct gcITSA = Torus.createGeometryConstructITSA(alpha, radSlices, conSlices, features |= 1, colorAlpha, texCoordsSize);
        return GeomFactory.createTAfromITSA(gcITSA);
    }

    public static Geometry createGeometry(float alpha, int radSlices, int conSlices, int features, boolean colorAlpha, int texCoordsSize) {
        switch (Torus.getGeometryConstructionTypeHint()) {
            case INDEXED_TRIANGLE_STRIP_ARRAY: {
                return Torus.createGeometryITSA(alpha, radSlices, conSlices, features, colorAlpha, texCoordsSize);
            }
            case INDEXED_TRIANGLE_ARRAY: {
                return Torus.createGeometryITA(alpha, radSlices, conSlices, features, colorAlpha, texCoordsSize);
            }
            case TRIANGLE_STRIP_ARRAY: {
                return Torus.createGeometryTSA(alpha, radSlices, conSlices, features, colorAlpha, texCoordsSize);
            }
            case TRIANGLE_ARRAY: {
                return Torus.createGeometryTA(alpha, radSlices, conSlices, features, colorAlpha, texCoordsSize);
            }
        }
        throw new Error(Torus.getGeometryConstructionTypeHint().getCorrespondingClass().getSimpleName() + " creation is not yet implemented.");
    }

    private Torus(Geometry geom) {
        super(geom);
    }

    public Torus(float alpha, int radSlices, int conSlices, int features, boolean colorAlpha, int texCoordsSize) {
        this(Torus.createGeometry(alpha, radSlices, conSlices, features, colorAlpha, texCoordsSize));
    }

    public Torus(float radius, float alpha, int radSlices, int conSlices, int features, boolean colorAlpha, int texCoordsSize) {
        this(alpha, radSlices, conSlices, features, colorAlpha, texCoordsSize);
        StaticTransform.scale(this, radius);
    }

    public Torus(float alpha, int radSlices, int conSlices, Texture texture) {
        this(alpha, radSlices, conSlices, 11, false, 2);
        this.getAppearance(true).setTexture(texture);
    }

    public Torus(float radius, float alpha, int radSlices, int conSlices, Texture texture) {
        this(alpha, radSlices, conSlices, texture);
        StaticTransform.scale(this, radius);
    }

    public Torus(float alpha, int radSlices, int conSlices, String texture) {
        this(alpha, radSlices, conSlices, TextureLoader.getInstance().getTexture(texture));
    }

    public Torus(float radius, float alpha, int radSlices, int conSlices, String texture) {
        this(radius, alpha, radSlices, conSlices, TextureLoader.getInstance().getTexture(texture));
    }

    public Torus(float alpha, int radSlices, int conSlices, Colorf color) {
        this(alpha, radSlices, conSlices, 3, false, 2);
        this.getAppearance(true).getColoringAttributes(true).setColor(color);
        if (color != null && color.hasAlpha()) {
            this.getAppearance(true).getTransparencyAttributes(true).setTransparency(color.getAlpha());
        }
    }

    public Torus(float radius, float alpha, int radSlices, int conSlices, Colorf color) {
        this(alpha, radSlices, conSlices, color);
        StaticTransform.scale(this, radius);
    }

    public Torus(float alpha, int radSlices, int conSlices, Appearance app) {
        this(alpha, radSlices, conSlices, 3 | GeomFactory.getFeaturesFromAppearance(app), false, GeomFactory.getTexCoordsSize(app));
        this.setAppearance(app);
    }

    public Torus(float radius, float alpha, int radSlices, int conSlices, Appearance app) {
        this(alpha, radSlices, conSlices, app);
        StaticTransform.scale(this, radius);
    }
}

