/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph.traversal.impl;

import org.jagatoo.util.errorhandling.UnsupportedFunction;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.Group;
import org.xith3d.scenegraph.Material;
import org.xith3d.scenegraph.Node;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.traversal.impl.AppearanceTraversal;
import org.xith3d.scenegraph.traversal.impl.MaterialTraversal;
import org.xith3d.scenegraph.traversal.impl.PickableTraversal;
import org.xith3d.scenegraph.traversal.impl.PolygonCounter;
import org.xith3d.scenegraph.traversal.impl.ShapeFinder;

public class SGUtils {
    public static int getPolygonCount(Node node2) {
        if (node2 instanceof Group) {
            Group group = (Group)node2;
            return PolygonCounter.getPolygonCount(group);
        }
        throw new UnsupportedFunction("Cannot count polygons on type " + node2.getClass().getName());
    }

    public static int getPolygonCount(Group group) {
        return PolygonCounter.getPolygonCount(group);
    }

    public static Shape3D findFirstShape(Group group) {
        return ShapeFinder.findFirstShape(group);
    }

    public static void setAllAppearances(Group group, Appearance app) {
        group.traverse(new AppearanceTraversal(app));
    }

    public static void setAllMaterials(Group group, Material mat) {
        group.traverse(new MaterialTraversal(mat));
    }

    public static void setAllPickable(Group group, boolean pickable) {
        group.traverse(new PickableTraversal(pickable));
    }
}

