/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.schedops.properties;

import org.xith3d.loop.UpdatingThread;
import org.xith3d.loop.opscheduler.Interval;

public abstract class ValueInterpolator
extends Interval {
    private long startTime;
    private final long totalTime;
    private final float startVal;
    private final float endVal;
    private final float deltaVal;

    public final long getStartTime() {
        return this.startTime;
    }

    public final long getTotalTime() {
        return this.totalTime;
    }

    public final float getStartValue() {
        return this.startVal;
    }

    public final float getEndValue() {
        return this.endVal;
    }

    public final float getDeltaValue() {
        return this.deltaVal;
    }

    protected void onIntervalStarted(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        this.startTime = gameTime;
    }

    protected abstract void applyValue(float var1);

    protected void applyNormValue(float normValue) {
        this.applyValue(this.startVal + this.deltaVal * normValue);
    }

    protected void onInterpolationFinished() {
        this.kill();
    }

    protected void onIntervalHit(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        float normValue = (float)(gameTime - this.startTime) / (float)this.totalTime;
        boolean isEnd = false;
        if (normValue >= 1.0f) {
            isEnd = true;
            normValue = 1.0f;
        }
        this.applyNormValue(normValue);
        if (isEnd) {
            this.onInterpolationFinished();
        }
    }

    public ValueInterpolator(long totalTime, long resolution, float startVal, float endVal) {
        super(resolution);
        this.totalTime = totalTime;
        this.startVal = startVal;
        this.endVal = endVal;
        this.deltaVal = endVal - startVal;
    }

    public ValueInterpolator(long totalTime, float startVal, float endVal) {
        this(totalTime, 30L, startVal, endVal);
    }

    public ValueInterpolator(long totalTime, long resolution) {
        this(totalTime, resolution, 0.0f, 1.0f);
    }

    public ValueInterpolator(long totalTime) {
        this(totalTime, 30L, 0.0f, 1.0f);
    }
}

