/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.selection;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import org.openmali.vecmath2.Tuple2i;
import org.openmali.vecmath2.Tuple3f;
import org.xith3d.selection.ContextMenuProvider;
import org.xith3d.selection.MenuAction;
import org.xith3d.selection.Selectable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AWTContextMenuProvider
implements ContextMenuProvider {
    private static final String PROP_SWING_ACTION = "SWING_ACTION";
    public static final String PROP_MOUSE_COORDS = "mouseCoords";
    public static final String PROP_WORLD_COORDS = "worldCoords";
    public static final String PROP_SELECTION = "selection";
    public static final String PROP_SELECTED_CONTEXT = "selectedContext";
    private JPopupMenu menu = new JPopupMenu();
    private Component component;

    @Override
    public void showContextMenu(Tuple2i mouseCoords, Tuple3f worldCoords, List<Selectable> selection, List<Selectable> selectedContext) {
        int i;
        this.menu.removeAll();
        ArrayList<MenuAction> result = new ArrayList<MenuAction>();
        for (i = 0; i < selection.size(); ++i) {
            Selectable selectable = selection.get(i);
            List<MenuAction> actions = selectable.lookup(MenuAction.class);
            result.addAll(actions);
        }
        for (i = 0; i < result.size(); ++i) {
            final MenuAction action = (MenuAction)result.get(i);
            action.setProperty(PROP_MOUSE_COORDS, mouseCoords);
            action.setProperty(PROP_WORLD_COORDS, worldCoords);
            action.setProperty(PROP_SELECTION, selection);
            action.setProperty(PROP_SELECTED_CONTEXT, selectedContext);
            AbstractAction swingAction = (AbstractAction)action.getProperty(PROP_SWING_ACTION);
            if (swingAction == null) {
                swingAction = new AbstractAction(action.getName()){
                    private static final long serialVersionUID = 1L;

                    public void actionPerformed(ActionEvent e) {
                        action.onActionPerformed();
                    }
                };
                action.setProperty(PROP_SWING_ACTION, swingAction);
            }
            if (action == MenuAction.SEPARATOR) {
                this.menu.addSeparator();
                continue;
            }
            this.menu.add(swingAction);
        }
        this.menu.show(this.component, mouseCoords.getX(), mouseCoords.getY());
    }

    public AWTContextMenuProvider(Component component) {
        this.component = component;
    }
}

