/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.selection;

import org.openmali.spatial.bodies.Frustum;
import org.openmali.spatial.bodies.Plane;
import org.openmali.vecmath2.Point3f;
import org.xith3d.picking.PickPool;
import org.xith3d.picking.PickRay;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.RenderPassConfig;
import org.xith3d.scenegraph._SG_PrivilegedAccess;
import org.xith3d.selection.MovementConstraints;

public class ViewConstraints
implements MovementConstraints {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeNewPosition(RenderPassConfig rpc, Canvas3D canvas, int x, int y, Point3f p0, Point3f newPosition) {
        Plane movementPlane = Plane.fromPool();
        PickRay pickRay = PickPool.allocatePickRay();
        try {
            if (rpc != null) {
                _SG_PrivilegedAccess.set(canvas.getView(), true, rpc);
            }
            Frustum frustum = rpc != null && rpc.getViewport() != null ? canvas.getView().getFrustum(rpc.getViewport()) : canvas.getView().getFrustum(canvas);
            frustum.getPlaneNear(movementPlane);
            float d = -(movementPlane.getNX() * p0.getX() + movementPlane.getNY() * p0.getY() + movementPlane.getNZ() * p0.getZ());
            movementPlane.setD(d);
            pickRay.recalculate(rpc, canvas, x, y);
            movementPlane.intersects(pickRay, newPosition);
        }
        finally {
            if (rpc != null) {
                _SG_PrivilegedAccess.set(canvas.getView(), false, rpc);
            }
            PickPool.deallocatePickRay(pickRay);
            Plane.toPool(movementPlane);
        }
    }
}

