/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.sound;

import java.util.ArrayList;
import org.openmali.vecmath2.Tuple3f;
import org.xith3d.sound.SoundBuffer;
import org.xith3d.sound.SoundException;
import org.xith3d.sound.SoundSource;
import org.xith3d.utility.logging.X3DLog;

public abstract class SoundDriver {
    protected final ArrayList<SoundSource> sources = new ArrayList();
    protected final ArrayList<SoundSource> availableSources = new ArrayList();
    protected final ArrayList<SoundBuffer> buffers = new ArrayList();
    private float listenerVolume = 1.0f;
    private float dopplerVelocity = 1.0f;
    private float dopplerFactor = 0.0f;
    private boolean online = false;

    protected void setOnline(boolean online) {
        this.online = online;
    }

    public final boolean isOnline() {
        return this.online;
    }

    protected abstract void startImpl();

    public final void start() {
        this.startImpl();
        this.setOnline(true);
    }

    public abstract void newFrameSync();

    public abstract void newFrameAsync();

    public void setListenerVelocity(Tuple3f velocity) {
    }

    public void setListenerPosition(Tuple3f position) {
    }

    public void setListenerOrientation(Tuple3f direction, Tuple3f up) {
    }

    public void setListenerVolume(float gain) {
        this.listenerVolume = gain;
    }

    public final float getListenerVolume() {
        return this.listenerVolume;
    }

    public void setDopplerVelocity(float velocity) {
        this.dopplerVelocity = velocity;
    }

    public final float getDopplerVelocity() {
        return this.dopplerVelocity;
    }

    public void setDopplerFactor(float factor) {
        this.dopplerFactor = factor;
    }

    public final float getDopplerFactor() {
        return this.dopplerFactor;
    }

    protected abstract SoundSource createSoundSource();

    public SoundSource allocateSoundSource() throws SoundException {
        if (this.availableSources.size() == 0) {
            throw new SoundException("no sound sources available");
        }
        SoundSource s = this.availableSources.remove(this.availableSources.size() - 1);
        this.sources.add(s);
        return s;
    }

    public abstract SoundBuffer allocateSoundBuffer();

    public boolean delete(SoundSource source) {
        if (this.sources.remove(source)) {
            this.availableSources.add(source);
            return true;
        }
        return false;
    }

    public boolean delete(SoundBuffer buffer) {
        return false;
    }

    public final int getNumAvailableSources() {
        return this.availableSources.size();
    }

    public final int getNumActiveSources() {
        return this.sources.size();
    }

    public final int getNumSources() {
        return this.sources.size() + this.availableSources.size();
    }

    protected abstract void shutdownImpl();

    public final void shutdown() {
        if (!this.isOnline()) {
            return;
        }
        this.shutdownImpl();
        this.setOnline(false);
    }

    private void allocateAvailableSources() {
        while (this.availableSources.size() < 60) {
            try {
                this.availableSources.add(this.createSoundSource());
            }
            catch (Error e) {
                X3DLog.print(e);
                break;
            }
        }
    }

    protected abstract void initSoundDevice();

    protected SoundDriver() {
        this.initSoundDevice();
        this.allocateAvailableSources();
        this.setListenerVolume(1.0f);
        this.setDopplerVelocity(1.0f);
        this.setDopplerFactor(0.0f);
    }
}

