/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.sound;

import java.util.ArrayList;
import java.util.HashMap;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.scenegraph.BackgroundSound;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.PointSound;
import org.xith3d.scenegraph.Sound;
import org.xith3d.scenegraph.View;
import org.xith3d.sound.SoundContainer;
import org.xith3d.sound.SoundDriver;
import org.xith3d.sound.SoundSource;
import org.xith3d.sound.drivers.javasound.SoundDriverImpl;
import org.xith3d.utility.logging.X3DLog;

public class SoundProcessor {
    private static final SoundProcessor INSTANCE = new SoundProcessor();
    private SoundDriver soundDriver = null;
    private final HashMap<BranchGroup, ArrayList<Sound>> soundNodes = new HashMap();
    private long lastFrameId = -1L;

    public static final SoundProcessor getInstance() {
        return INSTANCE;
    }

    public void setSoundDriver(SoundDriver soundDriver) {
        if (soundDriver == this.soundDriver) {
            return;
        }
        if (this.soundDriver != null) {
            this.soundDriver.shutdown();
        }
        this.soundDriver = soundDriver;
        soundDriver.start();
    }

    public final SoundDriver getSoundDriver() {
        return this.soundDriver;
    }

    public void addSound(Sound sound, BranchGroup rootBranch) {
        ArrayList<Sound> list = this.soundNodes.get(rootBranch);
        if (list == null) {
            list = new ArrayList();
            this.soundNodes.put(rootBranch, list);
        }
        list.add(sound);
        X3DLog.debug("A ", sound.getClass().getSimpleName(), " has been added to the SoundProcesor ", this);
    }

    public boolean removeSound(Sound sound) {
        for (ArrayList<Sound> list : this.soundNodes.values()) {
            if (!list.remove(sound)) continue;
            X3DLog.debug("A ", sound.getClass().getSimpleName(), " has been removed from the SoundProcesor ", this);
            return true;
        }
        return false;
    }

    public void clearSoundList() {
        X3DLog.debug("Sound list has been cleared in the SoundProcesor ", this);
        this.soundNodes.clear();
    }

    private void process(Sound sound, Point3f soundLoc, View view, Point3f listenerPosition) {
        boolean activate;
        if (this.soundDriver == null || !this.soundDriver.isOnline()) {
            return;
        }
        if (!sound.isEnabled() && !sound.isPlaying()) {
            return;
        }
        if (sound.isDisabled()) {
            return;
        }
        boolean isBackgroundSound = sound instanceof BackgroundSound;
        boolean setSoundLoc = false;
        if (!sound.isEnabled()) {
            activate = false;
        } else if (isBackgroundSound) {
            activate = true;
        } else {
            setSoundLoc = true;
            sound.getWorldTransform().get(soundLoc);
            float squaredDist = soundLoc.distanceSquared(listenerPosition);
            activate = squaredDist < view.getSoundActivationRadius() * view.getSoundActivationRadius();
        }
        try {
            SoundSource ss = sound.getSource();
            if (!activate) {
                if (ss == null) {
                    return;
                }
                if (ss.isPlaying()) {
                    ss.pause();
                    sound.setDeactivated(true);
                }
                return;
            }
            if (ss == null) {
                SoundContainer sc = sound.getSoundContainer();
                try {
                    ss = this.soundDriver.allocateSoundSource();
                    ss.setContainer(sc);
                    ss.setLoop(sound.isContinuousEnabled());
                    if (isBackgroundSound) {
                        ss.setRolloffFactor(0.0f);
                        ss.setRelative(true);
                        ss.setPosition(0.0f, 0.0f, 0.0f);
                    } else {
                        float ref;
                        PointSound ps = (PointSound)sound;
                        float max = ps.getMaxDistance();
                        if (max == -1.0f) {
                            max = view.getSoundActivationRadius();
                        }
                        if ((ref = ps.getReferenceDistance()) == -1.0f) {
                            ref = 0.17f * max;
                        }
                        ss.setMaxDistance(max * 0.9f);
                        ss.setReferenceDistance(ref);
                        ss.setMaxVolume(ps.getMaxVolume());
                        ss.setMinVolume(ps.getMinVolume());
                        ss.setRolloffFactor(ps.getRolloffFactor());
                        ss.setRelative(false);
                        X3DLog.debug("max distance = ", Float.valueOf(max * 0.9f), ", ", "ref = ", Float.valueOf(ref), ", ", "max vol = ", Float.valueOf(ps.getMaxVolume()), ", ", "min vol = ", Float.valueOf(ps.getMinVolume()), ", ", "vol = ", Float.valueOf(sound.getInitialGain()));
                    }
                    ss.setVolume(sound.getInitialGain());
                    sound.setSource(ss);
                }
                catch (Throwable t) {
                    X3DLog.print(t);
                    t.printStackTrace();
                    sound.setDisabled(true);
                    return;
                }
            }
            if (setSoundLoc) {
                ss.setPosition(soundLoc);
            }
            if (sound.isPaused()) {
                if (sound.isPlaying()) {
                    ss.pause();
                }
            } else if (sound.isEnabled() && !sound.isPlaying()) {
                if (sound.wasRestarted() || sound.wasDeactivated()) {
                    ss.rewind();
                    ss.play();
                    sound.setRestarted(false);
                    sound.setDeactivated(false);
                }
            } else if (!sound.isEnabled() && sound.isPlaying()) {
                ss.pause();
            }
        }
        catch (Throwable t) {
            X3DLog.print(t);
            t.printStackTrace();
            this.soundDriver = null;
        }
    }

    private void update(View view, Point3f listenerPosition) {
        if (this.soundDriver != null && this.soundDriver.isOnline()) {
            Vector3f facingDirection = Vector3f.fromPool();
            Vector3f upDirection = Vector3f.fromPool();
            this.soundDriver.setListenerPosition(listenerPosition);
            view.getFacingDirection(facingDirection);
            view.getUpDirection(upDirection);
            this.soundDriver.setListenerOrientation(facingDirection, upDirection);
            Vector3f.toPool(upDirection);
            Vector3f.toPool(facingDirection);
        }
    }

    public void processAll(BranchGroup rootBranch, View view, long frameId, boolean force) {
        ArrayList<Sound> soundList = this.soundNodes.get(rootBranch);
        if (soundList == null) {
            return;
        }
        Point3f listenerPosition = Point3f.fromPool();
        view.getPosition(listenerPosition);
        if (frameId > this.lastFrameId || force) {
            if (!force) {
                this.lastFrameId = frameId;
            }
            if (this.soundNodes.size() > 0) {
                this.update(view, listenerPosition);
            }
        }
        X3DLog.debug("We have ", this.soundNodes.size(), " Sound Nodes to process in the sound processor ", this);
        Point3f soundLoc = Point3f.fromPool();
        for (int i = 0; i < soundList.size(); ++i) {
            this.process(soundList.get(i), soundLoc, view, listenerPosition);
        }
        Point3f.toPool(soundLoc);
        Point3f.toPool(listenerPosition);
    }

    public void processAll(BranchGroup rootBranch, View view, long frameId) {
        this.processAll(rootBranch, view, frameId, false);
    }

    private SoundProcessor() {
        this.setSoundDriver(new SoundDriverImpl());
    }
}

