/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.sound.drivers.lwjgl;

import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.AL10;
import org.openmali.vecmath2.Tuple3f;
import org.xith3d.sound.SoundBuffer;
import org.xith3d.sound.SoundDriver;
import org.xith3d.sound.SoundSource;
import org.xith3d.sound.drivers.lwjgl.SoundBufferImpl;
import org.xith3d.sound.drivers.lwjgl.SoundSourceImpl;
import org.xith3d.utility.logging.X3DLog;

public class SoundDriverImpl
extends SoundDriver {
    protected String decodeSoundError(int error) {
        switch (error) {
            case 0: {
                return "NO ERROR";
            }
            case 40962: {
                return "INVALID ENUM";
            }
            case 40963: {
                return "INVALID VALUE";
            }
            case 40961: {
                return "INVALID NAME";
            }
            case 40964: {
                return "INVALID OPERATION";
            }
            case 40965: {
                return "OUT OF MEMORY";
            }
        }
        return "UNKNOWN ERROR";
    }

    protected void checkError() {
        int error = AL10.alGetError();
        if (error != 0) {
            throw new Error(this.decodeSoundError(error));
        }
    }

    protected void startImpl() {
    }

    public void newFrameSync() {
        int[] sourceList = new int[this.sources.size()];
        for (int i = 0; i < sourceList.length; ++i) {
            SoundSourceImpl ss = (SoundSourceImpl)this.sources.get(i);
            sourceList[i] = ss.handle;
            ss.stop();
        }
    }

    public void newFrameAsync() {
    }

    public void setListenerVelocity(Tuple3f velocity) {
        AL10.alListener3f(4102, velocity.getX(), velocity.getY(), velocity.getZ());
        this.checkError();
        super.setListenerVelocity(velocity);
    }

    public void setListenerPosition(Tuple3f position) {
        AL10.alListener3f(4100, position.getX(), position.getY(), position.getZ());
        this.checkError();
        super.setListenerPosition(position);
    }

    public void setListenerOrientation(Tuple3f direction, Tuple3f up) {
        FloatBuffer orientation = BufferUtils.createFloatBuffer(6).put(new float[]{direction.getX(), direction.getY(), direction.getZ(), up.getX(), up.getY(), up.getZ()});
        orientation.rewind();
        AL10.alListener(4111, orientation);
        super.setListenerOrientation(direction, up);
    }

    public void setListenerVolume(float gain) {
        AL10.alListenerf(4106, gain);
        this.checkError();
        super.setListenerVolume(gain);
    }

    public void setDopplerVelocity(float velocity) {
        AL10.alDopplerVelocity(velocity);
        this.checkError();
        super.setDopplerVelocity(velocity);
    }

    public void setDopplerFactor(float factor) {
        AL10.alDopplerFactor(factor);
        super.setDopplerFactor(factor);
    }

    protected SoundSource createSoundSource() {
        return new SoundSourceImpl(this);
    }

    public SoundBuffer allocateSoundBuffer() {
        return new SoundBufferImpl();
    }

    public boolean delete(SoundSource source) {
        if (super.delete(source)) {
            ((SoundSourceImpl)source).releaseCachedResources();
            return true;
        }
        return false;
    }

    protected void shutdownImpl() {
        SoundSourceImpl ss;
        int j;
        int[] sourceList = new int[this.sources.size() + this.availableSources.size()];
        int i = 0;
        for (j = 0; j < this.sources.size(); ++j) {
            ss = (SoundSourceImpl)this.sources.get(j);
            sourceList[i++] = ss.handle;
            ss.stop();
        }
        for (j = 0; j < this.availableSources.size(); ++j) {
            ss = (SoundSourceImpl)this.availableSources.get(j);
            sourceList[i++] = ss.handle;
            ss.stop();
        }
        if (sourceList.length > 0) {
            IntBuffer sources = BufferUtils.createIntBuffer(sourceList.length).put(sourceList);
            sources.rewind();
            AL10.alDeleteSources(sources);
            this.checkError();
        }
        int[] bufferList = new int[this.buffers.size()];
        int j2 = 0;
        while (i < bufferList.length) {
            SoundBufferImpl ss2 = (SoundBufferImpl)this.buffers.get(j2);
            bufferList[j2] = ss2.handle;
            ++j2;
        }
        if (bufferList.length > 0) {
            IntBuffer buffers = BufferUtils.createIntBuffer(bufferList.length).put(bufferList);
            buffers.rewind();
            AL10.alDeleteBuffers(buffers);
            this.checkError();
        }
        AL.destroy();
    }

    protected void initSoundDevice() {
        try {
            AL.create(System.getProperty("XITH3D_OPENAL_DEVICE"), 44100, 60, false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.checkError();
        AL10.alDistanceModel(53249);
        this.checkError();
    }

    public SoundDriverImpl() {
        X3DLog.debug("LWJGL OpenAL sound driver initialized with ", this.availableSources.size(), " available sources");
    }
}

