/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.spatial.clipping;

import java.util.ArrayList;
import java.util.List;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.TupleNf;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Polygon {
    private List<Tuple3f> vertices;

    public List<Tuple3f> getVertices() {
        return this.vertices;
    }

    public void add(Tuple3f v) {
        this.vertices.add(v);
    }

    public void add(float x, float y, float z) {
        this.add(new Point3f(x, y, z));
    }

    public boolean contains(Tuple3f point) {
        for (int i = 0; i < this.vertices.size(); ++i) {
            Tuple3f vert = this.vertices.get(i);
            if (!((TupleNf)vert).equals(point)) continue;
            return true;
        }
        return false;
    }

    public List<Polygon> getAsTriangles() {
        ArrayList<Polygon> list = new ArrayList<Polygon>();
        if (this.vertices.size() == 3) {
            list.add(this);
            return list;
        }
        if (this.vertices.size() > 3) {
            Tuple3f origin = this.vertices.get(0);
            for (int i = 1; i < this.vertices.size() - 1; ++i) {
                Polygon tri = new Polygon();
                Tuple3f v2 = this.vertices.get(i);
                Tuple3f v3 = this.vertices.get(i + 1);
                tri.add(origin);
                tri.add(v2);
                tri.add(v3);
                list.add(tri);
            }
            return list;
        }
        return null;
    }

    public void print() {
        System.out.println("Number of vertices in polygon is " + this.vertices.size());
        for (int i = 0; i < this.vertices.size(); ++i) {
            System.out.println("  P" + i + ": " + this.vertices.get(i));
        }
    }

    public Polygon(List<Tuple3f> vertices) {
        this.vertices = vertices;
    }

    public Polygon() {
        this.vertices = new ArrayList<Tuple3f>();
    }
}

