/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.terrain;

import java.util.ArrayList;
import org.openmali.FastMath;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Tuple3f;
import org.xith3d.scenegraph.Group;
import org.xith3d.scenegraph.LODSwitch;
import org.xith3d.scenegraph.LazyLoadable;
import org.xith3d.scenegraph.StaticTransform;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.terrain.GridResourceProvider;
import org.xith3d.terrain.GridSampler;
import org.xith3d.terrain.GridSurface;
import org.xith3d.terrain.GridTriangulator;
import org.xith3d.terrain.SimpleGridResourceProvider;
import org.xith3d.terrain.TerrainTile;

public class ChunkedTerrain
extends Group
implements LazyLoadable {
    private ArrayList<GridSampler> samplers;
    private ArrayList<GridSurface> surfaces;
    private GridResourceProvider resourceProvider;
    private Point3f location;
    private Tuple3f dimension;
    private float scale = 1.0f;
    private float height = 1.0f;
    private float x;
    private float y;
    private float z;
    private float parentYOffset;
    private int tilesPerSide;
    private float s1 = 0.0f;
    private float t1 = 0.0f;
    private float s2 = 1.0f;
    private float t2 = 1.0f;
    private int spatialTreeDepth = 2;
    private int geomTreeDepth;
    private int maxGeomTreeDepth;
    private int complexity = 4;
    private float baseTolerance = 0.1f;
    private boolean isSetUp = false;
    private boolean isLazy = false;
    private Group content = null;

    public ChunkedTerrain(GridSampler gridSampler, GridSurface gridShader, float x, float y, float z, float scale, float height) {
        this(new SimpleGridResourceProvider(gridSampler, gridShader), x, y, z, scale, height);
    }

    public ChunkedTerrain(GridResourceProvider resourceProvider, float x, float y, float z, float scale, float height) {
        this(resourceProvider, x, y, z, scale, height, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0, 2, false);
    }

    protected ChunkedTerrain(Spec spec) {
        this(spec.resourceProvider, spec.x, spec.y, spec.z, spec.scale, spec.height);
    }

    protected ChunkedTerrain(GridResourceProvider resourceProvider, float x, float y, float z, float scale, float height, float s1, float t1, float s2, float t2, float parentYOffset, int geomTreeDepth, int maxGeomTreeDepth, boolean lazy) {
        this.resourceProvider = resourceProvider;
        this.x = x;
        this.y = y;
        this.z = z;
        this.scale = scale;
        this.height = height;
        this.geomTreeDepth = geomTreeDepth;
        this.maxGeomTreeDepth = maxGeomTreeDepth;
        this.s1 = s1;
        this.t1 = t1;
        this.s2 = s2;
        this.t2 = t2;
        this.parentYOffset = parentYOffset;
        this.isLazy = lazy;
        this.dimension = new Tuple3f(scale, height, scale);
        this.location = new Point3f(x, y, z);
        this.tilesPerSide = FastMath.pow(2, this.spatialTreeDepth);
        this.samplers = new ArrayList(this.tilesPerSide * this.tilesPerSide);
        this.surfaces = new ArrayList(this.tilesPerSide * this.tilesPerSide);
        if (!lazy) {
            this.prepare();
            this.setUp();
        } else {
            this.content = new Group();
        }
    }

    public float getHeight() {
        return this.height;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getZ() {
        return this.z;
    }

    public Point3f getLocation() {
        return this.location;
    }

    public Tuple3f getDimension() {
        return this.dimension;
    }

    public float pickY(float x, float z) {
        float s = Math.max(0.0f, Math.min(1.0f, (x - this.x) / this.scale - this.s1));
        float t = Math.max(0.0f, Math.min(1.0f, (z - this.z) / this.scale - this.t1));
        GridSampler gridSampler = this.resourceProvider.findSampler(s, t, s, t, -1);
        return gridSampler.sampleHeight(s, t) * this.height + this.y;
    }

    private void addTreeLevel(Group parent, int x1, int z1, int x2, int z2, int l) {
        int xc = (x1 + x2) / 2;
        int zc = (z1 + z2) / 2;
        if (l == this.spatialTreeDepth - 1) {
            this.addTiles(parent, x1, z1, xc, zc);
            this.addTiles(parent, xc, z1, x2, zc);
            this.addTiles(parent, xc, zc, x2, z2);
            this.addTiles(parent, x1, zc, xc, z2);
            return;
        }
        Group nwGroup = new Group();
        this.addTreeLevel(nwGroup, x1, z1, xc, zc, ++l);
        parent.addChild(nwGroup);
        Group neGroup = new Group();
        this.addTreeLevel(neGroup, xc, z1, x2, zc, l);
        parent.addChild(neGroup);
        Group seGroup = new Group();
        this.addTreeLevel(seGroup, xc, zc, x2, z2, l);
        parent.addChild(seGroup);
        Group swGroup = new Group();
        this.addTreeLevel(swGroup, x1, zc, xc, z2, l);
        parent.addChild(swGroup);
    }

    private void addTiles(Group group, int x1, int z1, int x2, int z2) {
        float ds = this.s2 - this.s1;
        float dt = this.t2 - this.t1;
        for (int ix = x1; ix < x2; ++ix) {
            for (int iz = z1; iz < z2; ++iz) {
                GridSampler gridSampler = this.resourceProvider.findSampler(this.s1 + ds / (float)this.tilesPerSide * (float)ix, this.t1 + dt / (float)this.tilesPerSide * (float)iz, this.s1 + ds / (float)this.tilesPerSide * (float)(ix + 1), this.t1 + dt / (float)this.tilesPerSide * (float)(iz + 1), this.geomTreeDepth);
                GridSurface gridSurface = this.resourceProvider.findSurface(this.s1 + ds / (float)this.tilesPerSide * (float)ix, this.t1 + dt / (float)this.tilesPerSide * (float)iz, this.s1 + ds / (float)this.tilesPerSide * (float)(ix + 1), this.t1 + dt / (float)this.tilesPerSide * (float)(iz + 1), this.geomTreeDepth);
                this.samplers.add(gridSampler);
                this.surfaces.add(gridSurface);
                float xoffset = this.scale / (float)this.tilesPerSide / 2.0f;
                GridTriangulator triangulator = new GridTriangulator(gridSampler, this.complexity, this.height, 0.0f - xoffset, 0.0f - xoffset, this.scale / (float)this.tilesPerSide - xoffset, this.scale / (float)this.tilesPerSide - xoffset, this.s1 + ds / (float)this.tilesPerSide * (float)ix, this.t1 + dt / (float)this.tilesPerSide * (float)iz, this.s1 + ds / (float)this.tilesPerSide * (float)(ix + 1), this.t1 + dt / (float)this.tilesPerSide * (float)(iz + 1), this.baseTolerance);
                float yoffset = triangulator.getMinY() + (triangulator.getMaxY() - triangulator.getMinY()) / 2.0f;
                TerrainTile terrainTile = new TerrainTile(gridSampler, gridSurface, triangulator, this.geomTreeDepth);
                StaticTransform.translate(terrainTile, 0.0f, -yoffset, 0.0f);
                TransformGroup transform = new TransformGroup(new Transform3D(this.x + this.scale / (float)this.tilesPerSide * (float)ix + xoffset, this.y + yoffset - this.parentYOffset, this.z + this.scale / (float)this.tilesPerSide * (float)iz + xoffset));
                if (this.geomTreeDepth < this.maxGeomTreeDepth) {
                    float threshold = this.scale / (float)this.tilesPerSide * 1.5f;
                    LODSwitch lodSwitch = new LODSwitch();
                    ChunkedTerrain subTerrain = new ChunkedTerrain(this.resourceProvider, 0.0f - xoffset, 0.0f, 0.0f - xoffset, this.scale / (float)this.tilesPerSide, this.height, this.s1 + ds / (float)this.tilesPerSide * (float)ix, this.t1 + dt / (float)this.tilesPerSide * (float)iz, this.s1 + ds / (float)this.tilesPerSide * (float)(ix + 1), this.t1 + dt / (float)this.tilesPerSide * (float)(iz + 1), yoffset, this.geomTreeDepth + 1, this.maxGeomTreeDepth, true);
                    lodSwitch.addLODItem(terrainTile, threshold, Float.MAX_VALUE);
                    lodSwitch.addLODItem(subTerrain, 0.0f, threshold);
                    transform.addChild(lodSwitch);
                } else {
                    transform.addChild(terrainTile);
                }
                group.addChild(transform);
            }
        }
    }

    public void prepare() {
        if (!this.isSetUp) {
            this.addTreeLevel(this.isLazy ? this.content : this, 0, 0, this.tilesPerSide, this.tilesPerSide, 0);
        }
    }

    public void setUp() {
        if (!this.isSetUp) {
            if (this.isLazy) {
                this.addChild(this.content);
            }
            this.isSetUp = true;
        }
    }

    public void tearDown() {
        if (this.isLazy && this.isSetUp) {
            this.removeChild(this.content);
            this.content = new Group();
            this.isSetUp = false;
        }
    }

    public boolean isSetUp() {
        return this.isSetUp;
    }

    public void cleanUp() {
        if (this.isLazy && this.isSetUp) {
            int i;
            int size = this.samplers.size();
            for (i = 0; i < size; ++i) {
                this.resourceProvider.releaseSampler(this.samplers.remove(0));
            }
            size = this.surfaces.size();
            for (i = 0; i < size; ++i) {
                this.resourceProvider.releaseSurface(this.surfaces.remove(0));
            }
        }
    }

    protected static class Spec {
        public GridResourceProvider resourceProvider;
        public float x;
        public float y;
        public float z;
        public float scale;
        public float height;

        public Spec() {
        }

        public Spec(GridResourceProvider resourceProvider, float x, float y, float z, float scale, float height) {
            this.resourceProvider = resourceProvider;
            this.x = x;
            this.y = y;
            this.z = z;
            this.scale = scale;
            this.height = height;
        }
    }
}

