/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.terrain.legacy;

import java.io.IOException;
import org.xith3d.io.InvalidFormat;
import org.xith3d.io.Scribable;
import org.xith3d.io.ScribeInputStream;
import org.xith3d.io.ScribeOutputStream;
import org.xith3d.io.UnscribableNodeEncountered;
import org.xith3d.utility.logging.X3DLog;

public class TerrainDataBank
implements Scribable {
    public static final int MUL_VERTEX = 5;
    public static final int MUL_ERROR = 6;
    public static final int MUL_SUB_ENABLED = 2;
    public static final int MUL_CHILD = 4;
    public static final int MUL_STATIC = 1;
    public static final int MUL_DIRTY = 1;
    public static final int MUL_NEXT = 1;
    public static final int MUL_ENABLED = 1;
    public static final int MUL_MINMAX = 1;
    private static final int EXTENT_NODES = 10000;
    private int[] child;
    private int[] childBank;
    protected int[] handles;
    private float[] y;
    private short[] error;
    private short[] minY;
    private short[] maxY;
    private byte[] enabledFlags;
    private byte[] subEnabledCount;
    private byte[] dataStatic;
    private byte[] dataDirty;
    private int[] next;
    private boolean compressed = false;
    private int bankId;
    protected TerrainDataBank newBank = null;
    private int maxNodes = 0;
    protected int freeList = 0;
    private int freeHandle = 0;

    public boolean isCompressed() {
        return this.compressed;
    }

    private static void copy(TerrainDataBank db, TerrainDataBank d) {
        System.arraycopy(db.child, 0, d.child, 0, db.child.length);
        System.arraycopy(db.childBank, 0, d.childBank, 0, db.childBank.length);
        System.arraycopy(db.y, 0, d.y, 0, db.y.length);
        System.arraycopy(db.minY, 0, d.minY, 0, db.minY.length);
        System.arraycopy(db.maxY, 0, d.maxY, 0, db.maxY.length);
        System.arraycopy(db.error, 0, d.error, 0, db.error.length);
        System.arraycopy(db.enabledFlags, 0, d.enabledFlags, 0, db.enabledFlags.length);
        System.arraycopy(db.subEnabledCount, 0, d.subEnabledCount, 0, db.subEnabledCount.length);
        System.arraycopy(db.dataStatic, 0, d.dataStatic, 0, db.dataStatic.length);
        System.arraycopy(db.dataDirty, 0, d.dataDirty, 0, db.dataDirty.length);
        System.arraycopy(db.next, 0, d.next, 0, db.next.length);
    }

    private void deleteData() {
        this.child = null;
        this.childBank = null;
        this.y = null;
        this.minY = null;
        this.maxY = null;
        this.error = null;
        this.enabledFlags = null;
        this.subEnabledCount = null;
        this.dataStatic = null;
        this.dataDirty = null;
        this.handles = null;
        this.next = null;
    }

    public static TerrainDataBank expand(TerrainDataBank db) {
        TerrainDataBank d = new TerrainDataBank(db.bankId, db.maxNodes + 10000);
        d.freeList = db.maxNodes;
        if (db.handles.length >= d.maxNodes) {
            X3DLog.debug("keeping bigger handle size");
            d.handles = new int[db.handles.length];
            System.arraycopy(db.handles, 0, d.handles, 0, db.handles.length);
            d.freeHandle = db.freeHandle;
        } else {
            X3DLog.debug("extanding handle size for bank ", db.bankId, " from ", db.handles.length, " to ", d.maxNodes);
            System.arraycopy(db.handles, 0, d.handles, 0, db.handles.length);
            d.handles[d.handles.length - 1] = -db.freeHandle;
            d.freeHandle = db.handles.length;
        }
        TerrainDataBank.copy(db, d);
        db.newBank = d;
        db.deleteData();
        return d;
    }

    public void delete(int node2) {
        if (this.bankId == 11 && node2 == 13) {
            X3DLog.debug("node 11/13 deleted");
        }
        for (int i = 0; i < 4; ++i) {
            this.setChild(node2, i, -1);
            this.setChildBank(node2, i, -1);
        }
        this.next[this.handles[node2]] = this.freeList;
        this.freeList = this.handles[node2];
        this.handles[node2] = -this.freeHandle;
        this.freeHandle = node2;
    }

    private static int copyNode(int node2, TerrainDataBank source, TerrainDataBank dest) {
        int n = dest.freeList;
        if (n == -1) {
            throw new Error("Out of quad nodes to allocate");
        }
        dest.freeList = dest.next[n];
        dest.next[n] = -1;
        dest.handles[node2] = n;
        try {
            System.arraycopy(source.y, source.handles[node2] * 5, dest.y, dest.handles[node2] * 5, 5);
            System.arraycopy(source.minY, source.handles[node2] * 1, dest.minY, dest.handles[node2] * 1, 1);
            System.arraycopy(source.maxY, source.handles[node2] * 1, dest.maxY, dest.handles[node2] * 1, 1);
            System.arraycopy(source.error, source.handles[node2] * 6, dest.error, dest.handles[node2] * 6, 6);
            System.arraycopy(source.enabledFlags, source.handles[node2] * 1, dest.enabledFlags, dest.handles[node2] * 1, 1);
            System.arraycopy(source.subEnabledCount, source.handles[node2] * 2, dest.subEnabledCount, dest.handles[node2] * 2, 2);
            System.arraycopy(source.dataStatic, source.handles[node2] * 1, dest.dataStatic, dest.handles[node2] * 1, 1);
            System.arraycopy(source.dataDirty, source.handles[node2] * 1, dest.dataDirty, dest.handles[node2] * 1, 1);
            System.arraycopy(source.child, source.handles[node2] * 4, dest.child, dest.handles[node2] * 4, 4);
            System.arraycopy(source.childBank, source.handles[node2] * 4, dest.childBank, dest.handles[node2] * 4, 4);
        }
        catch (Throwable e) {
            X3DLog.exception("Error attempting to compress");
            X3DLog.exception("  node = ", node2);
            X3DLog.exception("  source location = ", source.handles[node2]);
            X3DLog.exception("  dest location = ", dest.handles[node2]);
            throw new Error(e);
        }
        return n;
    }

    public static TerrainDataBank compress(TerrainDataBank db) {
        int i;
        int i2;
        int num = 0;
        for (i2 = 0; i2 < db.maxNodes; ++i2) {
            if (db.next[i2] != -1) continue;
            ++num;
        }
        X3DLog.debug("compressing bank ", db.bankId, " to ", num, " nodes from ", db.maxNodes);
        for (i2 = 0; i2 < db.maxNodes * 4; ++i2) {
            if (db.childBank[i2] == -1 || db.bankId == db.childBank[i2]) continue;
            X3DLog.error("we encountered a node in bank ", db.bankId, " that has a child in bank ", db.childBank[i2]);
            X3DLog.error("index is ", i2);
            throw new Error("Child exists outside of bank");
        }
        TerrainDataBank d = new TerrainDataBank(db.bankId, num + 10);
        d.handles = new int[db.handles.length];
        System.arraycopy(db.handles, 0, d.handles, 0, db.handles.length);
        d.freeHandle = db.freeHandle;
        db.newBank = d;
        for (i = 0; i < db.handles.length; ++i) {
            if (db.handles[i] < 0) continue;
            TerrainDataBank.copyNode(i, db, d);
        }
        d.compressed = true;
        db.deleteData();
        for (i = 0; i < d.handles.length; ++i) {
            if (d.handles[i] < 0) continue;
            for (int j = 0; j < 4; ++j) {
                int child = d.getChild(i, j);
                if (child == -1 || d.handles[child] >= 0) continue;
                throw new Error("Terrain Data Bank handles are corrupt");
            }
        }
        for (i = 0; i < d.maxNodes * 4; ++i) {
            if (d.childBank[i] == -1 || d.bankId == d.childBank[i]) continue;
            X3DLog.error("POST COMPRESSION ERROR");
            X3DLog.error("we encountered a node in bank ", d.bankId, " that has a child in bank ", d.childBank[i]);
            throw new Error("Child exists outside of bank");
        }
        return d;
    }

    public TerrainDataBank() {
    }

    public TerrainDataBank(int bankId, int max) {
        this.bankId = bankId;
        this.initialize(max);
    }

    public int allocateNode() {
        int n = this.freeList;
        if (n == -1) {
            throw new Error("Out of quad nodes to allocate");
        }
        int h = this.freeHandle;
        if (h < 0) {
            throw new Error("out of handles to allocate");
        }
        this.freeList = this.next[n];
        this.next[n] = -1;
        if (this.handles[this.freeHandle] >= 0) {
            X3DLog.error("we are allocating a handle already allocated!");
            System.exit(0);
        }
        this.freeHandle = -this.handles[h];
        this.handles[h] = n;
        for (int i = 0; i < 4; ++i) {
            this.child[n * 4 + i] = -1;
        }
        if (this.bankId == 11 && h == 13) {
            X3DLog.debug("node 11/13 allocated");
        }
        return h;
    }

    public float getY(int node2, int index) {
        return this.y[this.handles[node2] * 5 + index];
    }

    public void setY(int node2, int index, float val) {
        this.y[this.handles[node2] * 5 + index] = val;
    }

    public short getError(int node2, int index) {
        return this.error[this.handles[node2] * 6 + index];
    }

    public void setError(int node2, int index, short val) {
        this.error[this.handles[node2] * 6 + index] = val;
    }

    public int getChild(int node2, int index) {
        if (this.bankId == 11 && this.child[this.handles[node2] * 4 + index] == 13) {
            X3DLog.debug("node 11/13 is child ", index, " of node ", node2);
        }
        return this.child[this.handles[node2] * 4 + index];
    }

    public int getChildBank(int node2, int index) {
        return this.childBank[this.handles[node2] * 4 + index];
    }

    public void setChild(int node2, int index, int val) {
        this.child[this.handles[node2] * 4 + index] = val;
    }

    public void setChildBank(int node2, int index, int val) {
        this.childBank[this.handles[node2] * 4 + index] = val;
    }

    public byte getSubEnabledCount(int node2, int index) {
        return this.subEnabledCount[this.handles[node2] * 2 + index];
    }

    public void setSubEnabledCount(int node2, int index, byte val) {
        this.subEnabledCount[this.handles[node2] * 2 + index] = val;
    }

    public short getMinY(int node2) {
        return this.minY[this.handles[node2] * 1];
    }

    public void setMinY(int node2, short val) {
        this.minY[this.handles[node2] * 1] = val;
    }

    public byte getEnabledFlags(int node2) {
        return this.enabledFlags[this.handles[node2] * 1];
    }

    public void setEnabledFlags(int node2, byte val) {
        this.enabledFlags[this.handles[node2] * 1] = val;
    }

    public short getMaxY(int node2) {
        return this.maxY[this.handles[node2] * 1];
    }

    public void setMaxY(int node2, short val) {
        this.maxY[this.handles[node2] * 1] = val;
    }

    public boolean getStatic(int node2) {
        return this.dataStatic[this.handles[node2] * 1] == 1;
    }

    public void setStatic(int node2, boolean val) {
        this.dataStatic[this.handles[node2] * 1] = val ? (byte)1 : 0;
    }

    public boolean getDirty(int node2) {
        return this.dataDirty[this.handles[node2] * 1] == 1;
    }

    public void setDirty(int node2, boolean val) {
        this.dataDirty[this.handles[node2] * 1] = val ? (byte)1 : 0;
    }

    public void setNext(int node2, int val) {
        this.next[this.handles[node2] * 1] = val;
    }

    public int getNext(int node2) {
        return this.next[this.handles[node2] * 1];
    }

    public void initialize(int max) {
        int i;
        this.handles = new int[max];
        this.child = new int[max * 4];
        this.childBank = new int[max * 4];
        this.y = new float[max * 5];
        this.enabledFlags = new byte[max * 1];
        this.error = new short[max * 6];
        this.minY = new short[max * 1];
        this.maxY = new short[max * 1];
        this.subEnabledCount = new byte[max * 2];
        this.dataDirty = new byte[max * 1];
        this.dataStatic = new byte[max * 1];
        this.maxNodes = max;
        this.next = new int[max * 1];
        for (i = 0; i < max; ++i) {
            this.next[i] = i + 1;
            this.handles[i] = -i - 1;
        }
        for (i = 0; i < max * 4; ++i) {
            this.child[i] = -1;
            this.childBank[i] = -1;
        }
        this.next[max - 1] = -1;
    }

    public void load(ScribeInputStream in) throws InvalidFormat, IOException {
        this.bankId = in.readInt();
        this.maxNodes = in.readInt();
        this.freeList = in.readInt();
        this.freeHandle = in.readInt();
        this.handles = in.readIntArray();
        this.next = in.readIntArray();
        this.child = in.readIntArray();
        this.childBank = in.readIntArray();
        this.y = in.readFloatArray();
        this.subEnabledCount = in.readByteArray();
        this.enabledFlags = in.readByteArray();
        this.dataStatic = in.readByteArray();
        this.dataDirty = in.readByteArray();
        this.error = in.readShortArray();
        this.minY = in.readShortArray();
        this.maxY = in.readShortArray();
    }

    public void save(ScribeOutputStream out) throws UnscribableNodeEncountered, IOException {
        out.writeInt(this.bankId);
        out.writeInt(this.maxNodes);
        out.writeInt(this.freeList);
        out.writeInt(this.freeHandle);
        out.writeIntArray(this.handles);
        out.writeIntArray(this.next);
        out.writeIntArray(this.child);
        out.writeIntArray(this.childBank);
        out.writeFloatArray(this.y);
        out.writeByteArray(this.subEnabledCount);
        out.writeByteArray(this.enabledFlags);
        out.writeByteArray(this.dataStatic);
        out.writeByteArray(this.dataDirty);
        out.writeShortArray(this.error);
        out.writeShortArray(this.minY);
        out.writeShortArray(this.maxY);
    }
}

