/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import javax.swing.JFrame;
import org.jagatoo.commandline.ArgumentsRegistry;
import org.jagatoo.commandline.CommandlineParser;
import org.jagatoo.commandline.CommandlineParsingException;
import org.xith3d.loop.InputAdapterRenderLoop;
import org.xith3d.loop.RenderLoop;
import org.xith3d.loop.RenderLoopListener;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.Canvas3DFactory;
import org.xith3d.render.config.CanvasConstructionInfo;
import org.xith3d.render.config.DisplayMode;
import org.xith3d.render.config.DisplayModeSelector;
import org.xith3d.render.config.OpenGLLayer;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.commandline.XithArgumentsHandler;
import org.xith3d.utility.commandline.XithArgumentsRegistry;

public abstract class Xith3DTest
extends InputAdapterRenderLoop {
    private static final OpenGLLayer FALLBACK_DEFAULT_OGLLAYER = OpenGLLayer.LWJGL;
    public static OpenGLLayer DEFAULT_OGL_LAYER = OpenGLLayer.getDefault();
    public static final DisplayMode DEFAULT_DISPLAY_MODE;
    public static final DisplayMode.FullscreenMode DEFAULT_FULLSCREEN;
    public static final boolean DEFAULT_VSYNC;
    private FinishListener finishListener = null;

    protected static final CanvasConstructionInfo createCCI(OpenGLLayer oglLayer, DisplayMode displayMode, DisplayMode.FullscreenMode fullscreen, boolean vsyncEnabled, String title) {
        if (oglLayer != null && !oglLayer.equals(DEFAULT_OGL_LAYER)) {
            displayMode = DisplayModeSelector.getImplementation(oglLayer).getBestMode(displayMode.getWidth(), displayMode.getHeight(), displayMode.getBPP(), displayMode.getFrequency());
        }
        if (oglLayer == null) {
            oglLayer = OpenGLLayer.getDefault();
        }
        return new CanvasConstructionInfo(oglLayer, displayMode, fullscreen, vsyncEnabled, title);
    }

    protected static final CanvasConstructionInfo createCCI(DisplayMode displayMode, DisplayMode.FullscreenMode fullscreen, boolean vsyncEnabled, String title) {
        return Xith3DTest.createCCI(null, displayMode, fullscreen, vsyncEnabled, title);
    }

    protected static final CanvasConstructionInfo createCCI(DisplayMode displayMode, boolean vsyncEnabled, String title) {
        return Xith3DTest.createCCI(displayMode, DEFAULT_FULLSCREEN, vsyncEnabled, title);
    }

    protected static final CanvasConstructionInfo createCCI(boolean vsyncEnabled, String title) {
        return Xith3DTest.createCCI(DEFAULT_DISPLAY_MODE, vsyncEnabled, title);
    }

    protected static final CanvasConstructionInfo createCCI(OpenGLLayer oglLayer, boolean vsyncEnabled, String title) {
        return Xith3DTest.createCCI(oglLayer, DEFAULT_DISPLAY_MODE, DEFAULT_FULLSCREEN, vsyncEnabled, title);
    }

    protected static final CanvasConstructionInfo createCCI(OpenGLLayer oglLayer, String title) {
        return Xith3DTest.createCCI(oglLayer, DEFAULT_DISPLAY_MODE, DEFAULT_FULLSCREEN, DEFAULT_VSYNC, title);
    }

    protected static final CanvasConstructionInfo createCCI(String title) {
        return Xith3DTest.createCCI(DEFAULT_VSYNC, title);
    }

    private Canvas3D createCanvasWithOwner(CanvasConstructionInfo cci, String title) {
        System.err.println("Warning: Standalone-incapable OpenGLLayer selected. Wrapping in dummy frame. Things may not work as expected.");
        cci.setFullscreenMode(DisplayMode.FullscreenMode.WINDOWED);
        DisplayMode displayMode = cci.getDisplayMode();
        Point upperLeft = null;
        final JFrame frame = new JFrame(title);
        ((Container)frame).setLayout(null);
        frame.setSize(displayMode.getWidth(), displayMode.getHeight());
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                Xith3DTest.this.end();
            }
        });
        Canvas3D canvas = Canvas3DFactory.create(cci, frame instanceof JFrame ? frame.getContentPane() : frame);
        frame.setVisible(true);
        Thread.yield();
        Insets insets = frame.getInsets();
        Dimension frameSize = new Dimension(displayMode.getWidth() + insets.left + insets.right, displayMode.getHeight() + insets.top + insets.bottom);
        frame.setSize(frameSize);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        upperLeft = new Point((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        frame.setLocation(upperLeft);
        Thread.yield();
        frame.setResizable(false);
        Dimension size = frame.getSize();
        frame.setSize(size.width - 2, size.height - 2);
        Thread.yield();
        if (frame.getLocation().x == 0 && frame.getLocation().y == 0) {
            frame.setLocation(upperLeft);
        }
        this.addRenderLoopListener(new RenderLoopListener(){

            public void onRenderLoopStarted(RenderLoop rl) {
            }

            public void onRenderLoopPaused(RenderLoop rl, long gameTime, UpdatingThread.TimingMode timingMode, int pauseMode) {
            }

            public void onRenderLoopResumed(RenderLoop rl, long gameTime, UpdatingThread.TimingMode timingMode, int pauseMode) {
            }

            public void onRenderLoopStopped(RenderLoop rl, long gameTime, UpdatingThread.TimingMode timingMode, float averageFPS) {
                frame.setVisible(false);
                frame.dispose();
            }
        });
        return canvas;
    }

    protected Canvas3D createCanvas(CanvasConstructionInfo cci, String title) {
        if (!cci.getOpenGLLayer().isStandaloneCapable()) {
            return this.createCanvasWithOwner(cci, title);
        }
        return Canvas3DFactory.create(cci, this.getClass().getSimpleName());
    }

    public static final BasicApplicationArguments parseCommandLine(String[] args) throws CommandlineParsingException {
        XithArgumentsHandler handler = new XithArgumentsHandler();
        ArgumentsRegistry argReg = XithArgumentsRegistry.createStandardArgumentsRegistry();
        CommandlineParser parser = new CommandlineParser(argReg, handler);
        parser.parseCommandline(args);
        if (handler.helpRequested()) {
            argReg.dump();
            System.exit(0);
        }
        return handler.getArguments();
    }

    protected void exit() {
        if (this.finishListener != null) {
            this.finishListener.onTestFinished();
        } else {
            super.exit();
        }
    }

    public void begin(FinishListener finishListener) {
        this.finishListener = finishListener;
        this.begin(RenderLoop.RunMode.RUN_IN_SAME_THREAD);
    }

    public void begin(FinishListener finishListener, RenderLoop.RunMode runMode) {
        this.finishListener = finishListener;
        this.begin(runMode);
    }

    protected Xith3DTest(Float maxFPS) {
        super(maxFPS == null ? Float.MAX_VALUE : maxFPS.floatValue());
    }

    static {
        try {
            String defaultOGLLayer = System.getProperty("org.xith3d.test.OpenGLLayer.default", FALLBACK_DEFAULT_OGLLAYER.name());
            DEFAULT_OGL_LAYER = OpenGLLayer.valueOf(defaultOGLLayer);
            if (DEFAULT_OGL_LAYER != null) {
                DEFAULT_OGL_LAYER = FALLBACK_DEFAULT_OGLLAYER;
            }
        }
        catch (Throwable t) {
            DEFAULT_OGL_LAYER = FALLBACK_DEFAULT_OGLLAYER;
        }
        DEFAULT_DISPLAY_MODE = DisplayModeSelector.getImplementation(DEFAULT_OGL_LAYER).getBestMode(800, 600, 32);
        DEFAULT_FULLSCREEN = DisplayMode.WINDOWED;
        DEFAULT_VSYNC = DisplayMode.VSYNC_ENABLED;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Description {
        public String[] fulltext();

        public String[] authors();
    }

    public static interface FinishListener {
        public void onTestFinished();
    }
}

