/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jagatoo.util.classes.AnnotationCriterium;
import org.jagatoo.util.classes.ClassSearcher;
import org.xith3d.loop.RenderLoop;
import org.xith3d.render.config.DisplayMode;
import org.xith3d.render.config.FSAA;
import org.xith3d.render.config.OpenGLLayer;
import org.xith3d.test.Xith3DTest;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.launching.DisplayOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Xith3DTestLauncher
extends DisplayOptions
implements TreeSelectionListener,
Xith3DTest.FinishListener {
    private static final long serialVersionUID = 703711773159507726L;
    private static final String[] TEST_PACKAGES_TITLES = new String[]{"Testcases", "Benchmarks", "Demos"};
    private static final String[] TEST_PACKAGES_PREFIXES = new String[]{"org.xith3d.test", "org.xith3d.benchmarks", "org.xith3d.demos"};
    protected boolean currentMouseYInv;
    private JCheckBox mouseYInvCheck;
    private JTabbedPane testTab;
    private JTree[] testTrees;
    private JTextComponent descriptionPane;
    private String currentTest;
    private JCheckBox returnSelector;
    private boolean returnSelectorState;
    private Map<TreeNode, String> treeNodes2TestClassMap;
    private Map<String, DefaultMutableTreeNode> testClasses2treeNodesMap;
    private Map<DefaultMutableTreeNode, Integer> treeNodes2TreeIndexMap;
    private Map<String, String> testClassesDescriptions;
    private Map<String, String[]> testClassesAuthors;
    private boolean testRunning = false;
    private boolean success = false;

    @Override
    protected File getPropertiesFileFolder() {
        return super.getPropertiesFileFolder();
    }

    @Override
    protected String getPropertiesFilename() {
        return "testlauncher_selection.properties";
    }

    @Override
    protected String getPropertiesComment() {
        return "Last selected items in the Xith3DTestLauncher";
    }

    @Override
    protected void restoreSelections(Properties props) throws Throwable {
        super.restoreSelections(props);
        this.setCurrentMouseYInverted(Boolean.valueOf(props.getProperty("testlauncher.mouseYInverted", "true")));
        this.setCurrentTest(props.getProperty("testlauncher.selectedTest", null));
        this.setReturnSelectorState(Boolean.parseBoolean(props.getProperty("testlauncher.returnBit", "false")));
    }

    @Override
    protected Properties createProperties() {
        Properties props = super.createProperties();
        props.setProperty("testlauncher.mouseYInverted", String.valueOf(this.getCurrentMouseYInverted()));
        props.setProperty("testlauncher.selectedTest", String.valueOf(this.getCurrentTest()));
        props.setProperty("testlauncher.returnBit", String.valueOf(this.returnSelectorState));
        return props;
    }

    @Override
    public void onTestFinished() {
        this.testRunning = false;
        this.setVisible(true);
    }

    @Override
    protected boolean onStartButtonClicked() {
        this.success = false;
        this.testRunning = true;
        new Thread("Xith3DTestLauncher Thread"){

            public void run() {
                Xith3DTestLauncher.this.success = Xith3DTestLauncher.runTest(Xith3DTestLauncher.this.getCurrentTest(), Xith3DTestLauncher.this.getCurrentOGLLayer(), Xith3DTestLauncher.this.getCurrentDisplayMode(), Xith3DTestLauncher.this.getCurrentFullscreenMode(), Xith3DTestLauncher.this.getCurrentVSync(), Xith3DTestLauncher.this.getCurrentFSAA(), Xith3DTestLauncher.this.getCurrentMouseYInverted(), Xith3DTestLauncher.this.getReturnSelectorState() ? Xith3DTestLauncher.this : null);
            }
        }.start();
        return this.success;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (e.getSource() instanceof JCheckBox) {
            if (e.getActionCommand().equals("RETURN_SELECTOR")) {
                this.returnSelectorState = ((JCheckBox)e.getSource()).isSelected();
            } else if (e.getActionCommand().startsWith("MOUSE_Y_INV::")) {
                this.currentMouseYInv = ((JCheckBox)e.getSource()).isSelected();
            }
        }
    }

    public void setCurrentMouseYInverted(boolean inv) {
        this.mouseYInvCheck.setSelected(inv);
        this.currentMouseYInv = inv;
    }

    public boolean getCurrentMouseYInverted() {
        return this.currentMouseYInv;
    }

    public void setCurrentTest(String testName) {
        if (testName == null) {
            throw new IllegalArgumentException("testName MUST NOT be null");
        }
        DefaultMutableTreeNode node2 = this.testClasses2treeNodesMap.get(testName);
        if (node2 == null) {
            throw new IllegalArgumentException("A test class with this name does not exist");
        }
        TreePath path = new TreePath(node2.getPath());
        Integer treeIndex = this.treeNodes2TreeIndexMap.get(node2);
        JTree testTree = this.testTrees[treeIndex];
        testTree.setSelectionPath(path);
        testTree.scrollPathToVisible(path);
        this.testTab.setSelectedIndex(treeIndex);
        this.currentTest = testName;
    }

    public String getCurrentTest() {
        return this.currentTest;
    }

    public void setReturnSelectorState(boolean state) {
        this.returnSelectorState = state;
        this.returnSelector.setSelected(state);
    }

    public boolean getReturnSelectorState() {
        return this.returnSelectorState;
    }

    private void displayDescription() {
        String desc = this.testClassesDescriptions.get(this.currentTest);
        String[] authors = this.testClassesAuthors.get(this.currentTest);
        if (desc != null || authors != null) {
            StringBuffer html = new StringBuffer("<font face=\"Verdana\" size=\"12px\">\n");
            html.append(desc);
            html.append('\n');
            if (authors.length > 0) {
                html.append("<br>\n");
            }
            for (String author : authors) {
                html.append("<br>\n");
                html.append("<b>@author</b> ");
                html.append(author);
                html.append('\n');
            }
            html.append("</font>");
            this.descriptionPane.setText(html.toString());
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        TreePath path = e.getNewLeadSelectionPath();
        if (path != null) {
            TreeNode node2 = (TreeNode)path.getPathComponent(path.getPathCount() - 1);
            this.currentTest = this.treeNodes2TestClassMap.get(node2);
            this.displayDescription();
        } else {
            this.currentTest = null;
        }
        this.setStartButtonEnabled(this.currentTest != null);
    }

    private void mapDescAnnotation(String className, Xith3DTest.Description annotation) {
        StringBuffer desc = new StringBuffer();
        for (String part : annotation.fulltext()) {
            if (desc.length() > 0) {
                desc.append('\n');
            }
            desc.append(part);
        }
        this.testClassesDescriptions.put(className, desc.toString());
        this.testClassesAuthors.put(className, annotation.authors());
    }

    private void buildTree(String pkgName, Integer pkgIndex, Map<String, Object> treeMap, DefaultMutableTreeNode rootNode) {
        ArrayList<DefaultMutableTreeNode> nodes = new ArrayList<DefaultMutableTreeNode>();
        for (String s : treeMap.keySet()) {
            DefaultMutableTreeNode node2 = new DefaultMutableTreeNode(s);
            nodes.add(node2);
            Object o = treeMap.get(s);
            if (o instanceof Map) {
                this.buildTree(pkgName, pkgIndex, (Map)o, node2);
                continue;
            }
            this.treeNodes2TestClassMap.put(node2, (String)o);
            this.testClasses2treeNodesMap.put((String)o, node2);
            this.treeNodes2TreeIndexMap.put(node2, pkgIndex);
        }
        Collections.sort(nodes, new NodeComparater());
        for (DefaultMutableTreeNode n : nodes) {
            rootNode.add(n);
        }
    }

    private Map<String, Map<String, Object>> buildHashTree(List<Class<?>> classes) {
        HashMap<String, Map<String, Object>> map0 = new HashMap<String, Map<String, Object>>();
        for (String pkgName : TEST_PACKAGES_PREFIXES) {
            map0.put(pkgName, new HashMap());
        }
        for (Class<?> clazz : classes) {
            for (String pkgName : TEST_PACKAGES_PREFIXES) {
                if (!clazz.getName().startsWith(pkgName + ".")) continue;
                String full = clazz.getName().substring(pkgName.length() + 1);
                String[] path = full.split("\\.");
                Map map = (Map)map0.get(pkgName);
                for (int i = 0; i < path.length; ++i) {
                    if (i < path.length - 1) {
                        HashMap m = (HashMap)map.get(path[i]);
                        if (m == null) {
                            m = new HashMap();
                            map.put(path[i], m);
                        }
                        map = m;
                        continue;
                    }
                    map.put(path[i], clazz.getName());
                }
            }
        }
        return map0;
    }

    private Map<String, Map<String, Object>> initTestSelectors() {
        this.testClassesDescriptions = new HashMap<String, String>();
        this.testClassesAuthors = new HashMap<String, String[]>();
        List<Class<?>> classes = ClassSearcher.findClasses(new AnnotationCriterium(Xith3DTest.Description.class){

            @Override
            public boolean check(Class<?> clazz) {
                Xith3DTest.Description descAnnot;
                boolean result = super.check(clazz);
                if (result && (descAnnot = clazz.getAnnotation(Xith3DTest.Description.class)) != null) {
                    Xith3DTestLauncher.this.mapDescAnnotation(clazz.getName(), descAnnot);
                }
                return result;
            }
        }, TEST_PACKAGES_PREFIXES);
        this.treeNodes2TestClassMap = new Hashtable<TreeNode, String>();
        this.testClasses2treeNodesMap = new Hashtable<String, DefaultMutableTreeNode>();
        this.treeNodes2TreeIndexMap = new Hashtable<DefaultMutableTreeNode, Integer>();
        return this.buildHashTree(classes);
    }

    private JScrollPane createTestSelector(String pkgName, Integer pkgIndex, Map<String, Object> treeMap) {
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode("Xith3D " + TEST_PACKAGES_TITLES[pkgIndex]);
        this.buildTree(pkgName, pkgIndex, treeMap, rootNode);
        final JTree testTree = new JTree(rootNode);
        testTree.setBorder(new EmptyBorder(3, 3, 3, 3));
        testTree.getSelectionModel().setSelectionMode(1);
        testTree.setRootVisible(true);
        testTree.addTreeSelectionListener(this);
        testTree.setExpandsSelectedPaths(true);
        this.testTrees[pkgIndex.intValue()] = testTree;
        JScrollPane scroller = new JScrollPane(testTree);
        scroller.setBorder(new BevelBorder(1));
        testTree.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                TreePath path;
                if (e.getClickCount() == 2 && (path = testTree.getLeadSelectionPath()) != null) {
                    TreeNode node2 = (TreeNode)path.getPathComponent(path.getPathCount() - 1);
                    String currentTest = (String)Xith3DTestLauncher.this.treeNodes2TestClassMap.get(node2);
                    if (currentTest != null) {
                        Xith3DTestLauncher.this.requestStart();
                    }
                }
            }
        });
        return scroller;
    }

    private JTabbedPane createTestSelectors() {
        JTabbedPane tab = new JTabbedPane(1, 0);
        Map<String, Map<String, Object>> treeMaps = this.initTestSelectors();
        this.testTrees = new JTree[TEST_PACKAGES_PREFIXES.length];
        for (int i = 0; i < TEST_PACKAGES_PREFIXES.length; ++i) {
            String pkgTitle = TEST_PACKAGES_TITLES[i];
            String pkgName = TEST_PACKAGES_PREFIXES[i];
            Map<String, Object> treeMap = treeMaps.get(pkgName);
            tab.addTab(pkgTitle, this.createTestSelector(pkgName, i, treeMap));
        }
        this.testTab = tab;
        return tab;
    }

    @Override
    protected JComponent createCenterComponent() {
        JTabbedPane comp = this.createTestSelectors();
        comp.setMinimumSize(new Dimension(150, 200));
        comp.setPreferredSize(new Dimension(300, 350));
        comp.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        return comp;
    }

    @Override
    protected JComponent createSouthComponent() {
        JEditorPane descPane = new JEditorPane("text/html", "");
        descPane.setCursor(new Cursor(2));
        descPane.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.descriptionPane = descPane;
        descPane.setEditable(false);
        JScrollPane scroller = new JScrollPane(descPane);
        scroller.setBorder(new BevelBorder(1));
        scroller.setMinimumSize(new Dimension(1, 100));
        scroller.setPreferredSize(new Dimension(Integer.MAX_VALUE, 100));
        scroller.setMaximumSize(new Dimension(Integer.MAX_VALUE, 100));
        return scroller;
    }

    protected JComponent createMouseYInvertedSelector() {
        JPanel panel = new JPanel(new GridLayout(1, 1));
        panel.setMinimumSize(new Dimension(1, 20));
        panel.setPreferredSize(new Dimension(1, 20));
        panel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.mouseYInvCheck = new JCheckBox("Mouse-Y inverted", this.currentMouseYInv);
        this.mouseYInvCheck.setActionCommand("MOUSE_Y_INV::");
        this.mouseYInvCheck.addActionListener(this);
        panel.add(this.mouseYInvCheck);
        return panel;
    }

    @Override
    protected JComponent createNorthWestComponent() {
        JPanel p = (JPanel)super.createNorthWestComponent();
        p.add(Box.createVerticalStrut(5));
        p.add(this.createMouseYInvertedSelector());
        return p;
    }

    @Override
    protected JComponent createNorthComponent() {
        final ImageIcon icon = new ImageIcon(this.getClass().getClassLoader().getResource("resources/org/xith3d/pictures/TestLauncher.png"));
        JComponent image = new JComponent(){
            private static final long serialVersionUID = 1L;

            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.drawImage(icon.getImage(), 0, 0, this.getWidth(), this.getHeight(), this);
            }
        };
        image.setMinimumSize(new Dimension(0, 80));
        image.setPreferredSize(new Dimension(Integer.MAX_VALUE, 80));
        image.setMaximumSize(new Dimension(Integer.MAX_VALUE, 80));
        return image;
    }

    @Override
    protected JComponent createFooterComponent() {
        JComponent buttonsPanel = super.createFooterComponent();
        JPanel wrapper = new JPanel(new BorderLayout());
        wrapper.add((Component)buttonsPanel, "Center");
        this.returnSelector = new JCheckBox("Return to Launcher after Test finished", true);
        this.returnSelectorState = true;
        this.returnSelector.setSelected(this.returnSelectorState);
        this.returnSelector.setActionCommand("RETURN_SELECTOR");
        this.returnSelector.addActionListener(this);
        wrapper.add((Component)this.returnSelector, "West");
        wrapper.setMinimumSize(buttonsPanel.getMinimumSize());
        wrapper.setPreferredSize(buttonsPanel.getPreferredSize());
        wrapper.setMaximumSize(buttonsPanel.getMaximumSize());
        return wrapper;
    }

    @Override
    protected Dimension buildGUI() {
        Dimension size = super.buildGUI();
        this.setStartButtonEnabled(false);
        return size;
    }

    protected Xith3DTestLauncher() {
        super("Xith3D Test Launcher", Xith3DTest.DEFAULT_OGL_LAYER, Xith3DTest.DEFAULT_DISPLAY_MODE, DisplayMode.FullscreenMode.WINDOWED, FSAA.OFF);
    }

    public static final boolean runTest(String testName, OpenGLLayer layer, DisplayMode displayMode, DisplayMode.FullscreenMode fullscreen, boolean vsync, FSAA fsaa, boolean mouseYInverted, Xith3DTest.FinishListener finishListener) {
        Class<?> cls;
        try {
            cls = Class.forName(testName, false, Xith3DTestLauncher.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        try {
            if (Xith3DTest.class.isAssignableFrom(cls)) {
                Xith3DTest test = (Xith3DTest)cls.getConstructor(BasicApplicationArguments.class).newInstance(new BasicApplicationArguments(layer, displayMode, fullscreen, vsync, fsaa, mouseYInverted));
                test.begin(finishListener);
            } else {
                RenderLoop test = (RenderLoop)cls.getConstructor(BasicApplicationArguments.class, Xith3DTest.FinishListener.class).newInstance(new BasicApplicationArguments(layer, displayMode, fullscreen, vsync, fsaa, mouseYInverted), finishListener);
                test.begin();
            }
        }
        catch (Throwable t) {
            if (t.getCause() != null) {
                t.getCause().printStackTrace();
            } else {
                t.printStackTrace();
            }
            if (finishListener != null) {
                finishListener.onTestFinished();
            } else {
                System.exit(1);
            }
            return false;
        }
        return true;
    }

    public static final boolean runTest(String testName) {
        return Xith3DTestLauncher.runTest(testName, OpenGLLayer.getDefault(), Xith3DTest.DEFAULT_DISPLAY_MODE, Xith3DTest.DEFAULT_FULLSCREEN, Xith3DTest.DEFAULT_VSYNC, FSAA.OFF, true, null);
    }

    public static void main(String[] args) throws Exception {
        if (args.length > 0) {
            boolean succ = Xith3DTestLauncher.runTest("org.xith3d.test." + args[0]);
            if (!succ) {
                System.err.println("ERROR starting the desired test.");
                System.exit(1);
            } else {
                System.exit(0);
            }
        } else {
            new Xith3DTestLauncher();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NodeComparater
    implements Comparator<DefaultMutableTreeNode> {
        private NodeComparater() {
        }

        @Override
        public int compare(DefaultMutableTreeNode n1, DefaultMutableTreeNode n2) {
            return String.CASE_INSENSITIVE_ORDER.compare((String)n1.getUserObject(), (String)n2.getUserObject());
        }
    }
}

