/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.coloring;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.DeviceComponent;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.devices.components.Keys;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.openmali.types.twodee.Sized2iRO;
import org.openmali.vecmath2.Colorf;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.render.Canvas3D;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.ColoringAttributes;
import org.xith3d.scenegraph.PolygonAttributes;
import org.xith3d.scenegraph.RenderingAttributes;
import org.xith3d.scenegraph.SceneGraph;
import org.xith3d.scenegraph.StaticTransform;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.scenegraph.primitives.Cube;
import org.xith3d.scenegraph.primitives.Rectangle;
import org.xith3d.schedops.movement.RotatableGroup;
import org.xith3d.schedops.movement.TransformationDirectives;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"Simple Xith3D Coloring Component Write enable/disable test."}, authors={"YVG"})
public class ColorComponentWriteTest
extends Xith3DTest {
    private RenderingAttributes ra;
    private int colorSet = 1;

    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case SPACE: {
                ++this.colorSet;
                this.ra.setColorWriteMask((this.colorSet & 1) != 0, (this.colorSet & 2) != 0, (this.colorSet & 4) != 0, false);
                break;
            }
            case ESCAPE: {
                this.end();
            }
        }
    }

    private void createSceneGraph(Xith3DEnvironment env) throws Exception {
        RotatableGroup testRotateYGroup = new RotatableGroup(new TransformationDirectives(0.0f, 0.1f, 0.0f));
        TransformGroup scaleTransform = new TransformGroup();
        Transform3D t = new Transform3D();
        t.setIdentity();
        scaleTransform.setTransform(t);
        testRotateYGroup.addChild(scaleTransform);
        Texture2D texture = TextureLoader.getInstance().getTexture("stone.jpg");
        this.ra = new RenderingAttributes();
        this.ra.setColorWriteMask(true, false, false, false);
        Rectangle rect = new Rectangle(0.6f, 0.6f, Colorf.WHITE);
        StaticTransform.translate(rect, -0.4f, -0.4f, 0.0f);
        Appearance app = rect.getAppearance(true);
        app.getColoringAttributes(true).setShadeModel(ColoringAttributes.SHADE_FLAT);
        app.setPolygonAttributes(new PolygonAttributes(PolygonAttributes.POLYGON_FILL, PolygonAttributes.CULL_NONE));
        app.setRenderingAttributes(this.ra);
        scaleTransform.addChild(rect);
        rect = new Rectangle(0.6f, 0.6f, Colorf.RED);
        StaticTransform.translate(rect, 0.4f, -0.4f, 0.0f);
        app = rect.getAppearance(true);
        app.setPolygonAttributes(new PolygonAttributes(PolygonAttributes.POLYGON_FILL, PolygonAttributes.CULL_NONE));
        app.getColoringAttributes(true).setShadeModel(ColoringAttributes.SHADE_FLAT);
        app.setRenderingAttributes(this.ra);
        scaleTransform.addChild(rect);
        rect = new Rectangle(0.6f, 0.6f, Colorf.GREEN);
        StaticTransform.translate(rect, -0.4f, 0.4f, 0.0f);
        app = rect.getAppearance(true);
        app.getColoringAttributes(true).setShadeModel(ColoringAttributes.SHADE_FLAT);
        app.setPolygonAttributes(new PolygonAttributes(PolygonAttributes.POLYGON_FILL, PolygonAttributes.CULL_NONE));
        app.setRenderingAttributes(this.ra);
        scaleTransform.addChild(rect);
        rect = new Rectangle(0.6f, 0.6f, Colorf.BLUE);
        StaticTransform.translate(rect, 0.4f, 0.4f, 0.0f);
        app = rect.getAppearance(true);
        app.getColoringAttributes(true).setShadeModel(ColoringAttributes.SHADE_FLAT);
        app.setPolygonAttributes(new PolygonAttributes(PolygonAttributes.POLYGON_FILL, PolygonAttributes.CULL_NONE));
        app.setRenderingAttributes(this.ra);
        scaleTransform.addChild(rect);
        Appearance a = new Appearance();
        a.setRenderingAttributes(this.ra);
        a.setPolygonAttributes(new PolygonAttributes(PolygonAttributes.POLYGON_FILL, PolygonAttributes.CULL_BACK));
        a.setTexture(texture);
        Cube cube = new Cube(0.8f, a);
        StaticTransform.translate(cube, 0.0f, 0.0f, -0.6f);
        scaleTransform.addChild(cube);
        env.addPerspectiveBranch().getBranchGroup().addChild(testRotateYGroup);
        this.getAnimator().addAnimatableObject(testRotateYGroup);
    }

    public ColorComponentWriteTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(0.0f, 0.0f, 3.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        this.createSceneGraph(env);
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        DeviceComponent[] comps = new DeviceComponent[]{Keys.SPACE};
        String[] boundActions = new String[]{"Toggle the color component write flags"};
        TestUtils.displayInputBindings((Sized2iRO)canvas, comps, boundActions, (SceneGraph)env);
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
    }

    public static void main(String[] args) throws Throwable {
        ColorComponentWriteTest test = new ColorComponentWriteTest(ColorComponentWriteTest.parseCommandLine(args));
        test.begin();
    }
}

