/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.etc;

import org.jagatoo.input.InputSystem;
import org.openmali.types.twodee.Sized2iRO;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.render.Canvas3D;
import org.xith3d.scenegraph.SceneGraph;
import org.xith3d.sound.SoundProcessor;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;
import org.xith3d.utility.general.Xith3DLogo;

@Xith3DTest.Description(fulltext={"Simple testcase featuring the Xith3DLogo."}, authors={"Marvin Froehlich (aka Qudus)"})
public class Xith3DLogoTest
extends Xith3DTest {
    public Xith3DLogoTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(this);
        SoundProcessor.getInstance().getSoundDriver().start();
        Xith3DLogo logo = new Xith3DLogo(env);
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
        TestUtils.displayInputBindings((Sized2iRO)canvas, null, (String[])null, (SceneGraph)env);
        logo.play(this.getOperationScheduler(), canvas, new Xith3DLogo.Xith3DLogoFinishListener(){

            public void onLogoFinished() {
                Xith3DLogoTest.this.end();
            }
        });
    }

    public static void main(String[] args) throws Throwable {
        Xith3DLogoTest test = new Xith3DLogoTest(Xith3DLogoTest.parseCommandLine(args));
        test.begin();
    }
}

