/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.geometry;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.DeviceComponent;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.devices.components.MouseAxis;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.jagatoo.opengl.enums.TextureBoundaryMode;
import org.openmali.FastMath;
import org.openmali.types.twodee.Sized2iRO;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.TexCoord2f;
import org.openmali.vecmath2.Vector3f;
import org.openmali.vecmath2.util.MatrixUtils;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.input.ObjectRotationInputHandler;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.render.Canvas3D;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.SceneGraph;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.scenegraph.TriangleArray;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"Simple test about building a chess-board."}, authors={"Marvin Froehlich (aka Qudus)"})
public class ChessBoardTest
extends Xith3DTest {
    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
            }
        }
    }

    private Shape3D createChessBoard(float size, float thickness, float borderWidth, float outerBorderThicknessFactor) {
        float halfSize = size / 2.0f;
        int res = 8;
        float halfThickness = thickness / 2.0f;
        float totalWidth = size + borderWidth;
        float fieldSize = size / 8.0f;
        float outerBorderThickness = thickness * outerBorderThicknessFactor;
        float borderAngle = FastMath.atan((thickness - outerBorderThickness) / borderWidth);
        float texCoordSOuter0 = 0.0f;
        float texCoordSInner0 = borderWidth / totalWidth;
        float texCoordSOuter1 = 1.0f;
        float texCoordSInner1 = 1.0f - texCoordSInner0;
        float texCoordTTop0 = 0.5f;
        float texCoordTTop1 = (1.0f - borderWidth / (borderWidth * 2.0f + outerBorderThickness)) * 0.5f;
        float texCoordTBottom0 = 0.0f;
        float texCoordTBottom1 = borderWidth / (borderWidth * 2.0f + outerBorderThickness) * 0.5f;
        int numBaseVertices = 48;
        Vector3f normalUp = new Vector3f(0.0f, 1.0f, 0.0f);
        Vector3f normalUp2 = new Vector3f(0.0f, 1.0f, 0.0f);
        Vector3f normalDown = new Vector3f(0.0f, -1.0f, 0.0f);
        Vector3f normalLeft = new Vector3f(-1.0f, 0.0f, 0.0f);
        Vector3f normalRight = new Vector3f(1.0f, 0.0f, 0.0f);
        Vector3f normalFront = new Vector3f(0.0f, 0.0f, 1.0f);
        Vector3f normalBack = new Vector3f(0.0f, 0.0f, -1.0f);
        TriangleArray geom = new TriangleArray(numBaseVertices * 2 + 72);
        Point3f bufferPoint = new Point3f();
        TexCoord2f bufferTexCoord = new TexCoord2f();
        int j = 0;
        int i = 0;
        while (i < 8) {
            geom.setCoordinate(j + 0, -halfSize, halfThickness, halfSize - fieldSize * (float)i);
            geom.setCoordinate(j + 1, halfSize, halfThickness, halfSize - fieldSize * (float)i);
            geom.setCoordinate(j + 2, -halfSize, halfThickness, halfSize - fieldSize * (float)(i + 1));
            geom.setCoordinate(j + 3, geom.getCoordinate(j + 1, bufferPoint));
            geom.setCoordinate(j + 4, geom.getCoordinate(j + 2, bufferPoint));
            geom.setCoordinate(j + 5, halfSize, halfThickness, halfSize - fieldSize * (float)(i + 1));
            geom.setCoordinate(j + 6, -halfSize, -halfThickness, halfSize - fieldSize * (float)i);
            geom.setCoordinate(j + 7, halfSize, -halfThickness, halfSize - fieldSize * (float)i);
            geom.setCoordinate(j + 8, -halfSize, -halfThickness, halfSize - fieldSize * (float)(i + 1));
            geom.setCoordinate(j + 9, geom.getCoordinate(j + 7, bufferPoint));
            geom.setCoordinate(j + 10, geom.getCoordinate(j + 8, bufferPoint));
            geom.setCoordinate(j + 11, halfSize, -halfThickness, halfSize - fieldSize * (float)(i + 1));
            geom.setNormal(j + 0, normalUp);
            geom.setNormal(j + 1, normalUp);
            geom.setNormal(j + 2, normalUp);
            geom.setNormal(j + 3, normalUp);
            geom.setNormal(j + 4, normalUp);
            geom.setNormal(j + 5, normalUp);
            geom.setNormal(j + 6, normalDown);
            geom.setNormal(j + 7, normalDown);
            geom.setNormal(j + 8, normalDown);
            geom.setNormal(j + 9, normalDown);
            geom.setNormal(j + 10, normalDown);
            geom.setNormal(j + 11, normalDown);
            boolean isOdd = i % 2 == 0;
            float s0 = isOdd ? 0.0f : 0.5f;
            float s1 = 1.0f * (float)(isOdd ? 8 : 9) / 2.0f;
            geom.setTextureCoordinate(0, j + 0, s0, 0.52f);
            geom.setTextureCoordinate(0, j + 0, s0, 0.52f);
            geom.setTextureCoordinate(0, j + 1, s1, 0.52f);
            geom.setTextureCoordinate(0, j + 2, s0, 0.52f);
            geom.setTextureCoordinate(0, j + 3, geom.getTextureCoordinate(0, j + 1, bufferTexCoord));
            geom.setTextureCoordinate(0, j + 4, geom.getTextureCoordinate(0, j + 2, bufferTexCoord));
            geom.setTextureCoordinate(0, j + 5, s1, 1.0f);
            geom.setTextureCoordinate(0, j + 6, geom.getTextureCoordinate(0, j + 0, bufferTexCoord));
            geom.setTextureCoordinate(0, j + 7, geom.getTextureCoordinate(0, j + 1, bufferTexCoord));
            geom.setTextureCoordinate(0, j + 8, geom.getTextureCoordinate(0, j + 2, bufferTexCoord));
            geom.setTextureCoordinate(0, j + 9, geom.getTextureCoordinate(0, j + 3, bufferTexCoord));
            geom.setTextureCoordinate(0, j + 10, geom.getTextureCoordinate(0, j + 4, bufferTexCoord));
            geom.setTextureCoordinate(0, j + 11, geom.getTextureCoordinate(0, j + 5, bufferTexCoord));
            ++i;
            j += 12;
        }
        geom.setCoordinate(j + 0, halfSize, halfThickness, halfSize);
        geom.setCoordinate(j + 1, -halfSize, halfThickness, halfSize);
        geom.setCoordinate(j + 2, halfSize + borderWidth, halfThickness - thickness + outerBorderThickness, halfSize + borderWidth);
        geom.setCoordinate(j + 3, geom.getCoordinate(j + 1, bufferPoint));
        geom.setCoordinate(j + 4, geom.getCoordinate(j + 2, bufferPoint));
        geom.setCoordinate(j + 5, -halfSize - borderWidth, halfThickness - thickness + outerBorderThickness, halfSize + borderWidth);
        geom.setCoordinate(j + 6, halfSize, -halfThickness, halfSize);
        geom.setCoordinate(j + 7, -halfSize, -halfThickness, halfSize);
        geom.setCoordinate(j + 8, halfSize + borderWidth, -halfThickness, halfSize + borderWidth);
        geom.setCoordinate(j + 9, geom.getCoordinate(j + 7, bufferPoint));
        geom.setCoordinate(j + 10, geom.getCoordinate(j + 8, bufferPoint));
        geom.setCoordinate(j + 11, -halfSize - borderWidth, -halfThickness, halfSize + borderWidth);
        geom.setCoordinate(j + 12, geom.getCoordinate(j + 2, bufferPoint));
        geom.setCoordinate(j + 13, geom.getCoordinate(j + 5, bufferPoint));
        geom.setCoordinate(j + 14, geom.getCoordinate(j + 8, bufferPoint));
        geom.setCoordinate(j + 15, geom.getCoordinate(j + 13, bufferPoint));
        geom.setCoordinate(j + 16, geom.getCoordinate(j + 14, bufferPoint));
        geom.setCoordinate(j + 17, geom.getCoordinate(j + 11, bufferPoint));
        MatrixUtils.getRotationMatrix(Vector3f.POSITIVE_X_AXIS, borderAngle).transform(normalUp, normalUp2);
        geom.setNormal(j + 0, normalUp2);
        geom.setNormal(j + 1, normalUp2);
        geom.setNormal(j + 2, normalUp2);
        geom.setNormal(j + 3, normalUp2);
        geom.setNormal(j + 4, normalUp2);
        geom.setNormal(j + 5, normalUp2);
        geom.setNormal(j + 6, normalDown);
        geom.setNormal(j + 7, normalDown);
        geom.setNormal(j + 8, normalDown);
        geom.setNormal(j + 9, normalDown);
        geom.setNormal(j + 10, normalDown);
        geom.setNormal(j + 11, normalDown);
        geom.setNormal(j + 12, normalFront);
        geom.setNormal(j + 13, normalFront);
        geom.setNormal(j + 14, normalFront);
        geom.setNormal(j + 15, normalFront);
        geom.setNormal(j + 16, normalFront);
        geom.setNormal(j + 17, normalFront);
        geom.setTextureCoordinate(0, j + 0, texCoordSInner1, 0.5f);
        geom.setTextureCoordinate(0, j + 1, texCoordSInner0, 0.5f);
        geom.setTextureCoordinate(0, j + 2, 1.0f, texCoordTTop1);
        geom.setTextureCoordinate(0, j + 3, geom.getTextureCoordinate(0, j + 1, bufferTexCoord));
        geom.setTextureCoordinate(0, j + 4, geom.getTextureCoordinate(0, j + 2, bufferTexCoord));
        geom.setTextureCoordinate(0, j + 5, 0.0f, texCoordTTop1);
        geom.setTextureCoordinate(0, j + 6, texCoordSInner1, 0.0f);
        geom.setTextureCoordinate(0, j + 7, texCoordSInner0, 0.0f);
        geom.setTextureCoordinate(0, j + 8, 1.0f, texCoordTBottom1);
        geom.setTextureCoordinate(0, j + 9, geom.getTextureCoordinate(0, j + 1, bufferTexCoord));
        geom.setTextureCoordinate(0, j + 10, geom.getTextureCoordinate(0, j + 2, bufferTexCoord));
        geom.setTextureCoordinate(0, j + 11, 0.0f, texCoordTBottom1);
        geom.setTextureCoordinate(0, j + 12, geom.getTextureCoordinate(0, j + 2, bufferTexCoord));
        geom.setTextureCoordinate(0, j + 13, geom.getTextureCoordinate(0, j + 5, bufferTexCoord));
        geom.setTextureCoordinate(0, j + 14, geom.getTextureCoordinate(0, j + 8, bufferTexCoord));
        geom.setTextureCoordinate(0, j + 15, geom.getTextureCoordinate(0, j + 13, bufferTexCoord));
        geom.setTextureCoordinate(0, j + 16, geom.getTextureCoordinate(0, j + 14, bufferTexCoord));
        geom.setTextureCoordinate(0, j + 17, geom.getTextureCoordinate(0, j + 11, bufferTexCoord));
        geom.setCoordinate((j += 18) + 0, halfSize, halfThickness, -halfSize);
        geom.setCoordinate(j + 1, -halfSize, halfThickness, -halfSize);
        geom.setCoordinate(j + 2, halfSize + borderWidth, halfThickness - thickness + outerBorderThickness, -halfSize - borderWidth);
        geom.setCoordinate(j + 3, geom.getCoordinate(j + 1, bufferPoint));
        geom.setCoordinate(j + 4, geom.getCoordinate(j + 2, bufferPoint));
        geom.setCoordinate(j + 5, -halfSize - borderWidth, halfThickness - thickness + outerBorderThickness, -halfSize - borderWidth);
        geom.setCoordinate(j + 6, halfSize, -halfThickness, -halfSize);
        geom.setCoordinate(j + 7, -halfSize, -halfThickness, -halfSize);
        geom.setCoordinate(j + 8, halfSize + borderWidth, -halfThickness, -halfSize - borderWidth);
        geom.setCoordinate(j + 9, geom.getCoordinate(j + 7, bufferPoint));
        geom.setCoordinate(j + 10, geom.getCoordinate(j + 8, bufferPoint));
        geom.setCoordinate(j + 11, -halfSize - borderWidth, -halfThickness, -halfSize - borderWidth);
        geom.setCoordinate(j + 12, geom.getCoordinate(j + 2, bufferPoint));
        geom.setCoordinate(j + 13, geom.getCoordinate(j + 5, bufferPoint));
        geom.setCoordinate(j + 14, geom.getCoordinate(j + 8, bufferPoint));
        geom.setCoordinate(j + 15, geom.getCoordinate(j + 13, bufferPoint));
        geom.setCoordinate(j + 16, geom.getCoordinate(j + 14, bufferPoint));
        geom.setCoordinate(j + 17, geom.getCoordinate(j + 11, bufferPoint));
        MatrixUtils.getRotationMatrix(Vector3f.NEGATIVE_X_AXIS, borderAngle).transform(normalUp, normalUp2);
        geom.setNormal(j + 0, normalUp2);
        geom.setNormal(j + 1, normalUp2);
        geom.setNormal(j + 2, normalUp2);
        geom.setNormal(j + 3, normalUp2);
        geom.setNormal(j + 4, normalUp2);
        geom.setNormal(j + 5, normalUp2);
        geom.setNormal(j + 6, normalDown);
        geom.setNormal(j + 7, normalDown);
        geom.setNormal(j + 8, normalDown);
        geom.setNormal(j + 9, normalDown);
        geom.setNormal(j + 10, normalDown);
        geom.setNormal(j + 11, normalDown);
        geom.setNormal(j + 12, normalBack);
        geom.setNormal(j + 13, normalBack);
        geom.setNormal(j + 14, normalBack);
        geom.setNormal(j + 15, normalBack);
        geom.setNormal(j + 16, normalBack);
        geom.setNormal(j + 17, normalBack);
        geom.setTextureCoordinate(0, j + 0, texCoordSInner1, 0.5f);
        geom.setTextureCoordinate(0, j + 1, texCoordSInner0, 0.5f);
        geom.setTextureCoordinate(0, j + 2, 1.0f, texCoordTTop1);
        geom.setTextureCoordinate(0, j + 3, geom.getTextureCoordinate(0, j + 1, bufferTexCoord));
        geom.setTextureCoordinate(0, j + 4, geom.getTextureCoordinate(0, j + 2, bufferTexCoord));
        geom.setTextureCoordinate(0, j + 5, 0.0f, texCoordTTop1);
        geom.setTextureCoordinate(0, j + 6, texCoordSInner1, 0.0f);
        geom.setTextureCoordinate(0, j + 7, texCoordSInner0, 0.0f);
        geom.setTextureCoordinate(0, j + 8, 1.0f, texCoordTBottom1);
        geom.setTextureCoordinate(0, j + 9, geom.getTextureCoordinate(0, j + 1, bufferTexCoord));
        geom.setTextureCoordinate(0, j + 10, geom.getTextureCoordinate(0, j + 2, bufferTexCoord));
        geom.setTextureCoordinate(0, j + 11, 0.0f, texCoordTBottom1);
        geom.setTextureCoordinate(0, j + 12, geom.getTextureCoordinate(0, j + 2, bufferTexCoord));
        geom.setTextureCoordinate(0, j + 13, geom.getTextureCoordinate(0, j + 5, bufferTexCoord));
        geom.setTextureCoordinate(0, j + 14, geom.getTextureCoordinate(0, j + 8, bufferTexCoord));
        geom.setTextureCoordinate(0, j + 15, geom.getTextureCoordinate(0, j + 13, bufferTexCoord));
        geom.setTextureCoordinate(0, j + 16, geom.getTextureCoordinate(0, j + 14, bufferTexCoord));
        geom.setTextureCoordinate(0, j + 17, geom.getTextureCoordinate(0, j + 11, bufferTexCoord));
        geom.setCoordinate((j += 18) + 0, -halfSize, halfThickness, halfSize);
        geom.setCoordinate(j + 1, -halfSize, halfThickness, -halfSize);
        geom.setCoordinate(j + 2, -halfSize - borderWidth, halfThickness - thickness + outerBorderThickness, halfSize + borderWidth);
        geom.setCoordinate(j + 3, geom.getCoordinate(j + 1, bufferPoint));
        geom.setCoordinate(j + 4, geom.getCoordinate(j + 2, bufferPoint));
        geom.setCoordinate(j + 5, -halfSize - borderWidth, halfThickness - thickness + outerBorderThickness, -halfSize - borderWidth);
        geom.setCoordinate(j + 6, -halfSize, -halfThickness, halfSize);
        geom.setCoordinate(j + 7, -halfSize, -halfThickness, -halfSize);
        geom.setCoordinate(j + 8, -halfSize - borderWidth, -halfThickness, halfSize + borderWidth);
        geom.setCoordinate(j + 9, geom.getCoordinate(j + 7, bufferPoint));
        geom.setCoordinate(j + 10, geom.getCoordinate(j + 8, bufferPoint));
        geom.setCoordinate(j + 11, -halfSize - borderWidth, -halfThickness, -halfSize - borderWidth);
        geom.setCoordinate(j + 12, geom.getCoordinate(j + 2, bufferPoint));
        geom.setCoordinate(j + 13, geom.getCoordinate(j + 5, bufferPoint));
        geom.setCoordinate(j + 14, geom.getCoordinate(j + 8, bufferPoint));
        geom.setCoordinate(j + 15, geom.getCoordinate(j + 13, bufferPoint));
        geom.setCoordinate(j + 16, geom.getCoordinate(j + 14, bufferPoint));
        geom.setCoordinate(j + 17, geom.getCoordinate(j + 11, bufferPoint));
        MatrixUtils.getRotationMatrix(Vector3f.POSITIVE_Z_AXIS, borderAngle).transform(normalUp, normalUp2);
        geom.setNormal(j + 0, normalUp2);
        geom.setNormal(j + 1, normalUp2);
        geom.setNormal(j + 2, normalUp2);
        geom.setNormal(j + 3, normalUp2);
        geom.setNormal(j + 4, normalUp2);
        geom.setNormal(j + 5, normalUp2);
        geom.setNormal(j + 6, normalDown);
        geom.setNormal(j + 7, normalDown);
        geom.setNormal(j + 8, normalDown);
        geom.setNormal(j + 9, normalDown);
        geom.setNormal(j + 10, normalDown);
        geom.setNormal(j + 11, normalDown);
        geom.setNormal(j + 12, normalLeft);
        geom.setNormal(j + 13, normalLeft);
        geom.setNormal(j + 14, normalLeft);
        geom.setNormal(j + 15, normalLeft);
        geom.setNormal(j + 16, normalLeft);
        geom.setNormal(j + 17, normalLeft);
        geom.setTextureCoordinate(0, j + 0, texCoordSInner1, 0.5f);
        geom.setTextureCoordinate(0, j + 1, texCoordSInner0, 0.5f);
        geom.setTextureCoordinate(0, j + 2, 1.0f, texCoordTTop1);
        geom.setTextureCoordinate(0, j + 3, geom.getTextureCoordinate(0, j + 1, bufferTexCoord));
        geom.setTextureCoordinate(0, j + 4, geom.getTextureCoordinate(0, j + 2, bufferTexCoord));
        geom.setTextureCoordinate(0, j + 5, 0.0f, texCoordTTop1);
        geom.setTextureCoordinate(0, j + 6, texCoordSInner1, 0.0f);
        geom.setTextureCoordinate(0, j + 7, texCoordSInner0, 0.0f);
        geom.setTextureCoordinate(0, j + 8, 1.0f, texCoordTBottom1);
        geom.setTextureCoordinate(0, j + 9, geom.getTextureCoordinate(0, j + 1, bufferTexCoord));
        geom.setTextureCoordinate(0, j + 10, geom.getTextureCoordinate(0, j + 2, bufferTexCoord));
        geom.setTextureCoordinate(0, j + 11, 0.0f, texCoordTBottom1);
        geom.setTextureCoordinate(0, j + 12, geom.getTextureCoordinate(0, j + 2, bufferTexCoord));
        geom.setTextureCoordinate(0, j + 13, geom.getTextureCoordinate(0, j + 5, bufferTexCoord));
        geom.setTextureCoordinate(0, j + 14, geom.getTextureCoordinate(0, j + 8, bufferTexCoord));
        geom.setTextureCoordinate(0, j + 15, geom.getTextureCoordinate(0, j + 13, bufferTexCoord));
        geom.setTextureCoordinate(0, j + 16, geom.getTextureCoordinate(0, j + 14, bufferTexCoord));
        geom.setTextureCoordinate(0, j + 17, geom.getTextureCoordinate(0, j + 11, bufferTexCoord));
        geom.setCoordinate((j += 18) + 0, halfSize, halfThickness, halfSize);
        geom.setCoordinate(j + 1, halfSize, halfThickness, -halfSize);
        geom.setCoordinate(j + 2, halfSize + borderWidth, halfThickness - thickness + outerBorderThickness, halfSize + borderWidth);
        geom.setCoordinate(j + 3, geom.getCoordinate(j + 1, bufferPoint));
        geom.setCoordinate(j + 4, geom.getCoordinate(j + 2, bufferPoint));
        geom.setCoordinate(j + 5, halfSize + borderWidth, halfThickness - thickness + outerBorderThickness, -halfSize - borderWidth);
        geom.setCoordinate(j + 6, halfSize, -halfThickness, halfSize);
        geom.setCoordinate(j + 7, halfSize, -halfThickness, -halfSize);
        geom.setCoordinate(j + 8, halfSize + borderWidth, -halfThickness, halfSize + borderWidth);
        geom.setCoordinate(j + 9, geom.getCoordinate(j + 7, bufferPoint));
        geom.setCoordinate(j + 10, geom.getCoordinate(j + 8, bufferPoint));
        geom.setCoordinate(j + 11, halfSize + borderWidth, -halfThickness, -halfSize - borderWidth);
        geom.setCoordinate(j + 12, geom.getCoordinate(j + 2, bufferPoint));
        geom.setCoordinate(j + 13, geom.getCoordinate(j + 5, bufferPoint));
        geom.setCoordinate(j + 14, geom.getCoordinate(j + 8, bufferPoint));
        geom.setCoordinate(j + 15, geom.getCoordinate(j + 13, bufferPoint));
        geom.setCoordinate(j + 16, geom.getCoordinate(j + 14, bufferPoint));
        geom.setCoordinate(j + 17, geom.getCoordinate(j + 11, bufferPoint));
        MatrixUtils.getRotationMatrix(Vector3f.NEGATIVE_Z_AXIS, borderAngle).transform(normalUp, normalUp2);
        geom.setNormal(j + 0, normalUp2);
        geom.setNormal(j + 1, normalUp2);
        geom.setNormal(j + 2, normalUp2);
        geom.setNormal(j + 3, normalUp2);
        geom.setNormal(j + 4, normalUp2);
        geom.setNormal(j + 5, normalUp2);
        geom.setNormal(j + 6, normalDown);
        geom.setNormal(j + 7, normalDown);
        geom.setNormal(j + 8, normalDown);
        geom.setNormal(j + 9, normalDown);
        geom.setNormal(j + 10, normalDown);
        geom.setNormal(j + 11, normalDown);
        geom.setNormal(j + 12, normalRight);
        geom.setNormal(j + 13, normalRight);
        geom.setNormal(j + 14, normalRight);
        geom.setNormal(j + 15, normalRight);
        geom.setNormal(j + 16, normalRight);
        geom.setNormal(j + 17, normalRight);
        geom.setTextureCoordinate(0, j + 0, texCoordSInner1, 0.5f);
        geom.setTextureCoordinate(0, j + 1, texCoordSInner0, 0.5f);
        geom.setTextureCoordinate(0, j + 2, 1.0f, texCoordTTop1);
        geom.setTextureCoordinate(0, j + 3, geom.getTextureCoordinate(0, j + 1, bufferTexCoord));
        geom.setTextureCoordinate(0, j + 4, geom.getTextureCoordinate(0, j + 2, bufferTexCoord));
        geom.setTextureCoordinate(0, j + 5, 0.0f, texCoordTTop1);
        geom.setTextureCoordinate(0, j + 6, texCoordSInner1, 0.0f);
        geom.setTextureCoordinate(0, j + 7, texCoordSInner0, 0.0f);
        geom.setTextureCoordinate(0, j + 8, 1.0f, texCoordTBottom1);
        geom.setTextureCoordinate(0, j + 9, geom.getTextureCoordinate(0, j + 1, bufferTexCoord));
        geom.setTextureCoordinate(0, j + 10, geom.getTextureCoordinate(0, j + 2, bufferTexCoord));
        geom.setTextureCoordinate(0, j + 11, 0.0f, texCoordTBottom1);
        geom.setTextureCoordinate(0, j + 12, geom.getTextureCoordinate(0, j + 2, bufferTexCoord));
        geom.setTextureCoordinate(0, j + 13, geom.getTextureCoordinate(0, j + 5, bufferTexCoord));
        geom.setTextureCoordinate(0, j + 14, geom.getTextureCoordinate(0, j + 8, bufferTexCoord));
        geom.setTextureCoordinate(0, j + 15, geom.getTextureCoordinate(0, j + 13, bufferTexCoord));
        geom.setTextureCoordinate(0, j + 16, geom.getTextureCoordinate(0, j + 14, bufferTexCoord));
        geom.setTextureCoordinate(0, j + 17, geom.getTextureCoordinate(0, j + 11, bufferTexCoord));
        Appearance app = new Appearance();
        Texture2D texture = TextureLoader.getInstance().getTexture("chessboard.jpg");
        texture.setBoundaryModes(TextureBoundaryMode.WRAP, TextureBoundaryMode.WRAP);
        app.setTexture(0, texture);
        Shape3D shape = new Shape3D(geom, app);
        return shape;
    }

    public ChessBoardTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(0.0f, 5.0f, 5.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        BranchGroup scene = new BranchGroup();
        Shape3D chessboard = this.createChessBoard(5.0f, 0.3f, 0.75f, 0.5f);
        TransformGroup tg = new TransformGroup();
        tg.addChild(chessboard);
        scene.addChild(tg);
        env.addPerspectiveBranch(scene);
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        DeviceComponent[] comps = new DeviceComponent[]{new MouseAxis(null, 'm', "Mouse drag")};
        String[] boundActions = new String[]{"Rotate the chessboard"};
        TestUtils.displayInputBindings((Sized2iRO)canvas, comps, boundActions, (SceneGraph)env);
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
        ObjectRotationInputHandler orih = new ObjectRotationInputHandler(tg);
        InputSystem.getInstance().addInputHandler(orih);
    }

    public static final void main(String[] args) throws Throwable {
        ChessBoardTest test = new ChessBoardTest(ChessBoardTest.parseCommandLine(args));
        test.begin();
    }
}

