/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.geometry;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.DeviceComponent;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.devices.components.Keys;
import org.jagatoo.input.devices.components.MouseAxis;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.openmali.types.twodee.Sized2iRO;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.input.FirstPersonInputHandler;
import org.xith3d.input.modules.fpih.FPIHInputAction;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.render.Canvas3D;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.Group;
import org.xith3d.scenegraph.SceneGraph;
import org.xith3d.scenegraph.Transformable;
import org.xith3d.scenegraph.primitives.Cylinder;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;
import org.xith3d.utility.geometry.NormalsVisualizer;

@Xith3DTest.Description(fulltext={"Simple test of the Cylinder primitive."}, authors={"Marvin Froehlich (aka Qudus)"})
public class CylinderTest
extends Xith3DTest {
    private NormalsVisualizer normals;

    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case N: {
                this.normals.setVisible(!this.normals.isVisible());
                break;
            }
            case ESCAPE: {
                this.end();
            }
        }
    }

    private BranchGroup createSceneGraph() {
        BranchGroup scene = new BranchGroup();
        Group group = new Group();
        scene.addChild(group);
        String texName = "precision.png";
        Cylinder shape = new Cylinder(1.0f, 3.0f, 1.0f, true, 32, texName);
        group.addChild(shape);
        this.normals = new NormalsVisualizer(shape);
        scene.addChild(this.normals);
        return scene;
    }

    public CylinderTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(0.0f, 0.0f, 5.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, this);
        env.getView().setFrontClipDistance(0.1f);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        BranchGroup rootBranch = this.createSceneGraph();
        env.addPerspectiveBranch(rootBranch);
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        DeviceComponent[] comps = new DeviceComponent[]{new MouseAxis(null, 'm', "FPS input"), Keys.N};
        String[] boundActions = new String[]{"Move around the cylinder", "Toggle normals visualization"};
        TestUtils.displayInputBindings((Sized2iRO)canvas, comps, boundActions, (SceneGraph)env);
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
        FirstPersonInputHandler fpih = FirstPersonInputHandler.createDefault((Transformable)env.getView(), (Sized2iRO)canvas, arguments.getMouseYInverted());
        fpih.getBindingsManager().unbind(FPIHInputAction.CROUCH);
        InputSystem.getInstance().addInputHandler(fpih);
    }

    public static final void main(String[] args) throws Throwable {
        CylinderTest test = new CylinderTest(CylinderTest.parseCommandLine(args));
        test.begin();
    }
}

