/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.geometry;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.openmali.types.twodee.Sized2iRO;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.TexCoord2f;
import org.openmali.vecmath2.Tuple3f;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.render.Canvas3D;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.SceneGraph;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.TriangleArray;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"Simple test of triangle array and textures."}, authors={"William Denniss"})
public class GeometryArrayTextureTest
extends Xith3DTest {
    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
            }
        }
    }

    private BranchGroup createScene() {
        BranchGroup m = new BranchGroup();
        Shape3D sh = new Shape3D();
        Point3f[] pts = new Point3f[]{new Point3f(-1.0f, -1.0f, 1.0f), new Point3f(-1.0f, -1.0f, -1.0f), new Point3f(1.0f, -1.0f, -1.0f), new Point3f(1.0f, -1.0f, 1.0f), new Point3f(0.0f, 1.0f, 0.0f)};
        Tuple3f[] coords = new Point3f[]{pts[0], pts[2], pts[1], pts[0], pts[3], pts[2], pts[0], pts[1], pts[4], pts[1], pts[2], pts[4], pts[2], pts[3], pts[4], pts[3], pts[0], pts[4]};
        TexCoord2f[] texCoords = new TexCoord2f[]{new TexCoord2f(0.0f, 0.0f), new TexCoord2f(1.0f, 0.0f), new TexCoord2f(1.0f, 1.0f), new TexCoord2f(1.0f, 1.0f), new TexCoord2f(0.0f, 1.0f), new TexCoord2f(0.0f, 0.0f), new TexCoord2f(0.0f, 0.0f), new TexCoord2f(1.0f, 0.0f), new TexCoord2f(1.0f, 1.0f), new TexCoord2f(1.0f, 1.0f), new TexCoord2f(0.0f, 1.0f), new TexCoord2f(0.0f, 0.0f), new TexCoord2f(0.0f, 0.0f), new TexCoord2f(1.0f, 0.0f), new TexCoord2f(1.0f, 1.0f), new TexCoord2f(1.0f, 1.0f), new TexCoord2f(0.0f, 1.0f), new TexCoord2f(0.0f, 0.0f)};
        TriangleArray ta = new TriangleArray(coords.length);
        ta.setCoordinates(0, coords);
        ta.setTextureCoordinates(0, 0, texCoords);
        ta.calculateFaceNormals();
        sh.setGeometry(ta);
        Texture2D texture = TextureLoader.getInstance().getTexture("rustycan.jpg");
        Appearance a = new Appearance();
        a.setTexture(texture);
        sh.setAppearance(a);
        m.addChild(sh);
        return m;
    }

    public GeometryArrayTextureTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(1.0f, 0.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        env.addPerspectiveBranch(this.createScene());
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        TestUtils.displayInputBindings((Sized2iRO)canvas, null, (String[])null, (SceneGraph)env);
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
    }

    public static void main(String[] args) throws Throwable {
        GeometryArrayTextureTest test = new GeometryArrayTextureTest(GeometryArrayTextureTest.parseCommandLine(args));
        test.begin();
    }
}

