/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.geometry;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.openmali.FastMath;
import org.openmali.types.twodee.Sized2iRO;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Tuple3f;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.render.Canvas3D;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.ColoringAttributes;
import org.xith3d.scenegraph.IndexedLineArray;
import org.xith3d.scenegraph.LineAttributes;
import org.xith3d.scenegraph.SceneGraph;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"Simple test of IndexedLineArray."}, authors={"Marvin Froehlich (aka Qudus)"})
public class IndexedLineArrayTest
extends Xith3DTest {
    private static final float RADIUS = 3.0f;
    private static final int ARC_DEG = 180;
    private static final float LINE_WIDTH = 1.0f;
    private static final Colorf LINE_COLOR = Colorf.RED;

    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
            }
        }
    }

    private Shape3D createLines() {
        Tuple3f[] coords = new Point3f[182];
        coords[0] = new Point3f(0.0f, 0.0f, 0.0f);
        for (int i = 0; i <= 180; ++i) {
            coords[i + 1] = new Point3f(FastMath.cos(FastMath.toRad(i)) * 3.0f, FastMath.sin(FastMath.toRad(i)) * 3.0f, 0.0f);
        }
        int[] indices = new int[362];
        for (int i = 0; i <= 180; ++i) {
            indices[i * 2 + 0] = 0;
            indices[i * 2 + 1] = i + 1;
        }
        IndexedLineArray ila = new IndexedLineArray(coords.length, indices.length);
        ila.setCoordinates(0, coords);
        ila.setIndex(indices);
        Appearance a = new Appearance();
        LineAttributes lineAttrs = new LineAttributes();
        lineAttrs.setLineWidth(1.0f);
        a.setLineAttributes(lineAttrs);
        a.setColoringAttributes(new ColoringAttributes(LINE_COLOR, ColoringAttributes.SHADE_FLAT));
        return new Shape3D(ila, a);
    }

    private BranchGroup createSceneGraph() throws Exception {
        BranchGroup scene = new BranchGroup();
        scene.addChild(this.createLines());
        return scene;
    }

    public IndexedLineArrayTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(this);
        env.addPerspectiveBranch(this.createSceneGraph());
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        TestUtils.displayInputBindings((Sized2iRO)canvas, null, (String[])null, (SceneGraph)env);
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
    }

    public static void main(String[] args) throws Throwable {
        IndexedLineArrayTest test = new IndexedLineArrayTest(IndexedLineArrayTest.parseCommandLine(args));
        test.begin();
    }
}

