/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.geometry;

import java.util.Random;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.DeviceComponent;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.devices.components.MouseAxis;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.openmali.types.twodee.Sized2iRO;
import org.openmali.vecmath2.Colorf;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.input.FirstPersonInputHandler;
import org.xith3d.input.modules.fpih.FPIHInputAction;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.render.Canvas3D;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.ColoringAttributes;
import org.xith3d.scenegraph.Geometry;
import org.xith3d.scenegraph.Group;
import org.xith3d.scenegraph.LineArray;
import org.xith3d.scenegraph.LineAttributes;
import org.xith3d.scenegraph.Node;
import org.xith3d.scenegraph.SceneGraph;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.scenegraph.Transformable;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.scenegraph.SkyBoxTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"This test case demonstrates the use of LineArray. The sky box test is in the background."}, authors={"Andrew Hanson (aka Patheros)"})
public class LineArrayTest
extends Xith3DTest {
    private Shape3D shape;
    private LineArray velLines;
    private float[] points = new float[60];
    private float[] pointDelta = new float[60];
    private static final float SIZE_SCALE = 10.0f;
    private static final float VEL_SCALE = 0.001f;
    private static final int LINE_COUNT = 10;

    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
            }
        }
    }

    private Group createLines() {
        Random rnd = new Random(System.nanoTime());
        for (int i = 0; i < 60; ++i) {
            this.points[i] = (1.0f * rnd.nextFloat() - 0.5f) * 10.0f;
            this.pointDelta[i] = (1.0f * rnd.nextFloat() - 0.5f) * 0.001f;
        }
        TransformGroup group = new TransformGroup();
        Appearance a = new Appearance();
        LineAttributes lineAtr = new LineAttributes();
        lineAtr.setLineWidth(3.0f);
        a.setLineAttributes(lineAtr);
        a.setColoringAttributes(new ColoringAttributes(Colorf.RED, ColoringAttributes.SHADE_FLAT));
        this.velLines = new LineArray(20);
        this.velLines.setOptimization(Geometry.Optimization.NONE);
        this.velLines.setCoordinates(0, this.points);
        this.shape = new Shape3D(this.velLines, a);
        group.addChild(this.shape);
        return group;
    }

    private BranchGroup createSceneGraph() throws Exception {
        return new BranchGroup((Node)this.createLines());
    }

    private void updateLines(long gameTime) {
        if (this.velLines != null) {
            for (int i = 0; i < 60; ++i) {
                int n = i;
                this.points[n] = this.points[n] + this.pointDelta[i] * (float)gameTime;
            }
            this.velLines.setCoordinates(0, this.points);
            this.shape.updateBounds(false);
        }
    }

    protected void prepareNextFrame(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        super.prepareNextFrame(gameTime, frameTime, timingMode);
        this.updateLines(timingMode.getMilliSeconds(frameTime));
    }

    public LineArrayTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        env.addRenderPass(SkyBoxTest.createSkyBox(resLoc.getResource("skyboxes/"), "normal"));
        env.addPerspectiveBranch(this.createSceneGraph());
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        DeviceComponent[] comps = new DeviceComponent[]{new MouseAxis(null, 'm', "FPS input")};
        String[] boundActions = new String[]{"Move in the scene"};
        TestUtils.displayInputBindings((Sized2iRO)canvas, comps, boundActions, (SceneGraph)env);
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
        FirstPersonInputHandler fpih = FirstPersonInputHandler.createDefault((Transformable)env.getView(), (Sized2iRO)canvas, arguments.getMouseYInverted());
        fpih.getBindingsManager().createDefaultBindings();
        fpih.getBindingsManager().unbind(FPIHInputAction.CROUCH);
        InputSystem.getInstance().addInputHandler(fpih);
    }

    public static void main(String[] args) throws Throwable {
        LineArrayTest test = new LineArrayTest(LineArrayTest.parseCommandLine(args));
        test.begin();
    }
}

