/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.geometry;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.openmali.types.twodee.Sized2iRO;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Matrix3f;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Tuple3f;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.render.Canvas3D;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.SceneGraph;
import org.xith3d.scenegraph.primitives.Line;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"This test case demonstrates the use of LineArray. The sky box test is in the background."}, authors={"Andrew Hanson (aka Patheros)"})
public class LineTest
extends Xith3DTest {
    private final Point3f lineStart = Point3f.newReadOnly(0.0f, 0.0f, 0.0f);
    private final Point3f lineEnd0 = Point3f.newReadOnly(3.0f, 0.0f, 0.0f);
    private final Point3f lineEnd = new Point3f();
    private final Matrix3f rotMat = new Matrix3f();
    private Line line;

    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
            }
        }
    }

    private BranchGroup createSceneGraph() throws Exception {
        this.line = new Line((Tuple3f)this.lineStart, this.lineEnd0, Colorf.RED);
        return new BranchGroup(this.line);
    }

    protected void prepareNextFrame(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        super.prepareNextFrame(gameTime, frameTime, timingMode);
        float gameSeconds = timingMode.getSecondsAsFloat(gameTime);
        float angle = gameSeconds * ((float)Math.PI * 2) / 10.0f % ((float)Math.PI * 2);
        this.rotMat.rotZ(angle);
        this.rotMat.transform(this.lineEnd0, this.lineEnd);
        this.line.setCoordinates(this.lineStart, this.lineEnd);
    }

    public LineTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(this);
        env.addPerspectiveBranch(this.createSceneGraph());
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        TestUtils.displayInputBindings((Sized2iRO)canvas, null, (String[])null, (SceneGraph)env);
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
    }

    public static void main(String[] args) throws Throwable {
        LineTest test = new LineTest(LineTest.parseCommandLine(args));
        test.begin();
    }
}

