/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.geometry;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.DeviceComponent;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.devices.components.Keys;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.jagatoo.opengl.enums.FaceCullMode;
import org.openmali.types.twodee.Sized2iRO;
import org.openmali.vecmath2.Point3f;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.loop.opscheduler.Animator;
import org.xith3d.render.Canvas3D;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.SceneGraph;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.primitives.Quad;
import org.xith3d.schedops.movement.RotatableGroup;
import org.xith3d.schedops.movement.TransformationDirectives;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;
import org.xith3d.utility.geometry.NormalsVisualizer;

@Xith3DTest.Description(fulltext={"Simple test of the Quad primitive."}, authors={"Marvin Froehlich (aka Qudus)"})
public class QuadTest
extends Xith3DTest {
    private Appearance app;
    private NormalsVisualizer normals;

    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case N: {
                this.normals.setVisible(!this.normals.isVisible());
                break;
            }
            case SPACE: {
                if (this.app.getPolygonAttributes().getFaceCullMode() == FaceCullMode.BACK) {
                    this.app.getPolygonAttributes().setFaceCullMode(FaceCullMode.NONE);
                    break;
                }
                this.app.getPolygonAttributes().setFaceCullMode(FaceCullMode.BACK);
                break;
            }
            case ESCAPE: {
                this.end();
            }
        }
    }

    private BranchGroup createSceneGraph(Animator animator) {
        BranchGroup scene = new BranchGroup();
        Point3f[] coords = new Point3f[]{new Point3f(-1.0f, -1.0f, 0.0f), new Point3f(1.0f, -1.0f, 0.0f), new Point3f(1.0f, 1.0f, 0.0f), new Point3f(-1.0f, 1.0f, 0.0f)};
        Texture2D tex = TextureLoader.getInstance().getTexture("stone.jpg", Texture.MipmapMode.MULTI_LEVEL_MIPMAP);
        Quad quad = new Quad(coords, tex);
        this.normals = new NormalsVisualizer(quad);
        this.app = quad.getAppearance();
        this.app.getPolygonAttributes(true).setFaceCullMode(FaceCullMode.NONE);
        TransformationDirectives td = new TransformationDirectives(0.0f, 0.1f, 0.0f);
        RotatableGroup rg = new RotatableGroup(td);
        rg.addChild(quad);
        rg.addChild(this.normals);
        scene.addChild(rg);
        animator.addAnimatableObject(rg);
        return scene;
    }

    public QuadTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(0.0f, 0.0f, 5.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, this);
        env.getView().setFrontClipDistance(0.1f);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        BranchGroup rootBranch = this.createSceneGraph(this.getAnimator());
        env.addPerspectiveBranch(rootBranch);
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        DeviceComponent[] comps = new DeviceComponent[]{Keys.SPACE, Keys.N};
        String[] boundActions = new String[]{"Toggle face cullmode", "Toggle normals visualization"};
        TestUtils.displayInputBindings((Sized2iRO)canvas, comps, boundActions, (SceneGraph)env);
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
    }

    public static final void main(String[] args) throws Throwable {
        QuadTest test = new QuadTest(QuadTest.parseCommandLine(args));
        test.begin();
    }
}

