/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.input;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.InputSystemException;
import org.jagatoo.input.actions.AbstractInvokableInputAction;
import org.jagatoo.input.devices.Controller;
import org.jagatoo.input.devices.ControllerFactory;
import org.jagatoo.input.devices.InputDevice;
import org.jagatoo.input.devices.components.ControllerAxis;
import org.jagatoo.input.devices.components.ControllerButton;
import org.jagatoo.input.devices.components.DeviceComponent;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.ControllerButtonEvent;
import org.jagatoo.input.events.KeyPressedEvent;
import org.openmali.types.twodee.Sized2iRO;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Point3f;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.RenderPass;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.SceneGraph;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.scenegraph.primitives.Disk;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"This is a simple testcase for Controller InputDevices in Xith3D."}, authors={"Marvin Froehlich (aka Qudus)"})
public class ControllerTest
extends Xith3DTest {
    private Shape3D shape;
    private TransformGroup tg;

    public void onKeyPressed(KeyPressedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
            }
        }
    }

    private void createSceneGraph(SceneGraph sceneGraph) {
        BranchGroup scene = new BranchGroup();
        Disk disk = new Disk(10.0f, 24, Colorf.GREEN);
        TransformGroup tg = new TransformGroup(400.0f, -300.0f, 0.0f);
        tg.addChild(disk);
        scene.addChild(tg);
        RenderPass renderPass = RenderPass.create2D(scene, 800, 600);
        sceneGraph.addRenderPass(renderPass);
        this.shape = disk;
        this.tg = tg;
    }

    public void onControllerButtonStateChanged(ControllerButtonEvent e, ControllerButton button, boolean state) {
        if (state) {
            this.shape.getAppearance().getColoringAttributes().setColor(Colorf.RED);
        } else {
            this.shape.getAppearance().getColoringAttributes().setColor(Colorf.GREEN);
        }
    }

    private boolean initController(ControllerFactory controllerFactory, final TransformGroup tg) throws Exception {
        Controller[] controllers = controllerFactory.getControllers();
        System.out.println("Found " + controllers.length + " Controllers:");
        for (Controller controller : controllers) {
            System.out.println("  " + controller.getName());
        }
        if (controllers.length == 0) {
            return false;
        }
        Controller controller = controllers[0];
        InputSystem.getInstance().registerController(controller);
        final Point3f tmp = new Point3f();
        controller.getAxis(0).bindAction(new AbstractInvokableInputAction(-1){

            public String invokeAction(InputDevice device, DeviceComponent comp, int delta, int state, long nanoTime) throws InputSystemException {
                ControllerAxis axis = (ControllerAxis)comp;
                tg.getTransform().getTranslation(tmp);
                tg.getTransform().setTranslation(400.0f + axis.getNormalizedValue() * 385.0f, tmp.getY(), 0.0f);
                tg.updateTransform();
                return null;
            }
        });
        controller.getAxis(1).bindAction(new AbstractInvokableInputAction(-1){

            public String invokeAction(InputDevice device, DeviceComponent comp, int delta, int state, long nanoTime) throws InputSystemException {
                ControllerAxis axis = (ControllerAxis)comp;
                tg.getTransform().getTranslation(tmp);
                tg.getTransform().setTranslation(tmp.getX(), -300.0f - axis.getNormalizedValue() * 285.0f, 0.0f);
                tg.updateTransform();
                return null;
            }
        });
        return true;
    }

    public ControllerTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(this);
        this.createSceneGraph(env);
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
        boolean controllerFound = this.initController(canvas.getInputDeviceFactory(), this.tg);
        if (!controllerFound) {
            DeviceComponent[] comps = new DeviceComponent[]{null};
            String[] boundActions = new String[]{"No controller found (plug one in and restart the test launcher)"};
            TestUtils.displayInputBindings((Sized2iRO)canvas, comps, boundActions, (SceneGraph)env);
        } else {
            DeviceComponent[] comps = new DeviceComponent[]{new ControllerButton(null, 0, "Controller axis"), new ControllerButton(null, 0, "Controller buttons")};
            String[] boundActions = new String[]{"Move the point", "Color the point"};
            TestUtils.displayInputBindings((Sized2iRO)canvas, comps, boundActions, (SceneGraph)env);
        }
    }

    public static void main(String[] args) throws Throwable {
        ControllerTest test = new ControllerTest(ControllerTest.parseCommandLine(args));
        test.begin();
    }
}

