/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.input;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.InputSystemException;
import org.jagatoo.input.actions.InputAction;
import org.jagatoo.input.actions.LabeledInputAction;
import org.jagatoo.input.actions.LabeledInvokableInputAction;
import org.jagatoo.input.devices.InputDevice;
import org.jagatoo.input.devices.components.DeviceComponent;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.devices.components.Keys;
import org.jagatoo.input.events.KeyPressedEvent;
import org.jagatoo.input.handlers.InputHandler;
import org.jagatoo.input.managers.InputBindingsManager;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.render.Canvas3D;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.SceneGraph;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.scenegraph.primitives.Sphere;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"This is a simple testcase, that demonstrates, how to", "create and use a custom InputHandler in Xith3D."}, authors={"Marvin Froehlich (aka Qudus)"})
public class CustomInputHandlerTest
extends Xith3DTest {
    public void onKeyPressed(KeyPressedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
            }
        }
    }

    private TransformGroup createSceneGraph(SceneGraph sceneGraph) {
        BranchGroup scene = new BranchGroup();
        TransformGroup tg = new TransformGroup();
        Sphere sphere = new Sphere(2.0f, 128, 64, "earth.jpg");
        tg.addChild(sphere);
        scene.addChild(tg);
        sceneGraph.addPerspectiveBranch(scene);
        return tg;
    }

    public CustomInputHandlerTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        TransformGroup rotGroup = this.createSceneGraph(env);
        CustomInputHandler cih = new CustomInputHandler(rotGroup);
        cih.getBindingsManager().bind(Keys.LEFT, CustomInputAction.ROTATE_LEFT);
        cih.getBindingsManager().bind(Keys.RIGHT, CustomInputAction.ROTATE_RIGHT);
        DeviceComponent[] comps = new DeviceComponent[CustomInputAction.values().length];
        int numBindings = cih.getBindingsManager().getBoundInputComponents(comps);
        InputAction[] boundActions = new CustomInputAction[numBindings];
        cih.getBindingsManager().getBoundActions(comps, boundActions);
        TestUtils.displayInputBindings(arguments.getResolution(), comps, (LabeledInputAction[])boundActions, (SceneGraph)env);
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
        InputSystem.getInstance().addInputHandler(cih);
    }

    public static void main(String[] args) throws Throwable {
        CustomInputHandlerTest test = new CustomInputHandlerTest(CustomInputHandlerTest.parseCommandLine(args));
        test.begin();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CustomInputHandler
    extends InputHandler<CustomInputAction> {
        private static final float ROTATION_SPEED = 0.1f;
        private final TransformGroup rotTG;
        private float startRotLeftTime;
        private float startRotRightTime;
        private float angle;
        private float deltaAngleLeft;
        private float deltaAngleRight;

        @Override
        public void update(long nanoSeconds, float seconds, long nanoFrame, float frameSeconds) throws InputSystemException {
            float rotTime;
            switch (this.getStatesManager().getInputState(CustomInputAction.ROTATE_LEFT)) {
                case MADE_POSITIVE: {
                    this.startRotLeftTime = seconds;
                    this.deltaAngleLeft = 0.0f;
                    break;
                }
                case MADE_NEGATIVE: {
                    this.startRotLeftTime = -1.0f;
                    this.angle = (this.angle + this.deltaAngleLeft) % ((float)Math.PI * 2);
                    this.deltaAngleLeft = 0.0f;
                    break;
                }
                case POSITIVE: {
                    rotTime = seconds - this.startRotLeftTime;
                    this.deltaAngleLeft = -rotTime * 0.1f * ((float)Math.PI * 2);
                    break;
                }
            }
            switch (this.getStatesManager().getInputState(CustomInputAction.ROTATE_RIGHT)) {
                case MADE_POSITIVE: {
                    this.startRotRightTime = seconds;
                    this.deltaAngleRight = 0.0f;
                    break;
                }
                case MADE_NEGATIVE: {
                    this.startRotRightTime = -1.0f;
                    this.angle = (this.angle + this.deltaAngleRight) % ((float)Math.PI * 2);
                    this.deltaAngleRight = 0.0f;
                    break;
                }
                case POSITIVE: {
                    rotTime = seconds - this.startRotRightTime;
                    this.deltaAngleRight = rotTime * 0.1f * ((float)Math.PI * 2);
                    break;
                }
            }
            float deltaAngle = this.deltaAngleLeft + this.deltaAngleRight;
            if (deltaAngle != 0.0f) {
                this.rotTG.getTransform().setIdentity();
                this.rotTG.getTransform().rotY((this.angle + deltaAngle) % ((float)Math.PI * 2));
                this.rotTG.updateTransform();
            }
        }

        public CustomInputHandler(TransformGroup rotTG) {
            super(new InputBindingsManager(CustomInputAction.values().length));
            this.startRotLeftTime = -1.0f;
            this.startRotRightTime = -1.0f;
            this.angle = 0.0f;
            this.deltaAngleLeft = 0.0f;
            this.deltaAngleRight = 0.0f;
            this.rotTG = rotTG;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CustomInputAction implements LabeledInvokableInputAction
    {
        ROTATE_LEFT,
        ROTATE_RIGHT;


        @Override
        public String getText() {
            switch (this) {
                case ROTATE_LEFT: {
                    return "Rotate the sphere to the left";
                }
                case ROTATE_RIGHT: {
                    return "Rotate the sphere to the right";
                }
            }
            return null;
        }

        @Override
        public String getLocalizedText() {
            return this.getText();
        }

        @Override
        public String invokeAction(InputDevice device, DeviceComponent comp, int delta, int state, long nanoTime) throws InputSystemException {
            System.out.println("State changed on action " + this + ". New state: " + state + ".");
            return "ok";
        }
    }
}

