/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.input;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.DeviceComponent;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.devices.components.Keys;
import org.jagatoo.input.events.KeyPressedEvent;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.jagatoo.input.listeners.InputAdapter;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.loop.RenderLoop;
import org.xith3d.loop.Updatable;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.Canvas3DFactory;
import org.xith3d.render.config.OpenGLLayer;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.SceneGraph;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.scenegraph.primitives.Sphere;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"Simple test demonstrating how to use a custom InputListener", "instead of extending InputAdapterRenderLoop.", "In your real-life game, you should never use InputAdapterRenderLoop,", "but always use a custom InputListener and/or InputHandler."}, authors={"Marvin Froehlich (aka Qudus)"})
public class CustomInputListenerTest
extends RenderLoop {
    private Xith3DTest.FinishListener finishListener = null;

    private TransformGroup createSceneGraph(SceneGraph sceneGraph) {
        BranchGroup scene = new BranchGroup();
        TransformGroup tg = new TransformGroup();
        Sphere sphere = new Sphere(2.0f, 128, 64, "earth.jpg");
        tg.addChild(sphere);
        scene.addChild(tg);
        sceneGraph.addPerspectiveBranch(scene);
        return tg;
    }

    protected void exit() {
        if (this.finishListener != null) {
            this.finishListener.onTestFinished();
        } else {
            super.exit();
        }
    }

    public CustomInputListenerTest(BasicApplicationArguments arguments) throws Throwable {
        this(arguments, null);
    }

    public CustomInputListenerTest(BasicApplicationArguments arguments, Xith3DTest.FinishListener finishListener) throws Throwable {
        super(120.0f);
        if (!arguments.getCanvasConstructionInfo().getOpenGLLayer().isStandaloneCapable()) {
            System.err.println("Warning: Standalone-incapable OpenGLLayer selected. Switching to LWJGL for this test.");
            arguments.getCanvasConstructionInfo().setOpenGLLayer(OpenGLLayer.LWJGL);
        }
        this.finishListener = finishListener;
        Xith3DEnvironment env = new Xith3DEnvironment(this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        TransformGroup rotGroup = this.createSceneGraph(env);
        SphereRotator sphereRot = new SphereRotator(rotGroup);
        this.getUpdater().addUpdatable(sphereRot);
        DeviceComponent[] comps = new DeviceComponent[]{Keys.LEFT, Keys.RIGHT};
        String[] boundActions = new String[]{"Rotate the sphere to the left", "Rotate the sphere to the right"};
        TestUtils.displayInputBindings(arguments.getResolution(), comps, boundActions, (SceneGraph)env);
        Canvas3D canvas = Canvas3DFactory.create(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
        CustomInputListener cil = new CustomInputListener(this, sphereRot);
        InputSystem.getInstance().addInputListener(cil);
    }

    public static void main(String[] args) throws Throwable {
        CustomInputListenerTest test = new CustomInputListenerTest(Xith3DTest.parseCommandLine(args));
        test.begin();
    }

    private class CustomInputListener
    extends InputAdapter {
        private final RenderLoop renderLoop;
        private final SphereRotator sphereRot;

        public void onKeyPressed(KeyPressedEvent e, Key key) {
            switch (key.getKeyID()) {
                case LEFT: {
                    this.sphereRot.startRotLeft(UpdatingThread.TimingMode.NANOSECONDS.getSecondsAsFloat(e.getWhen()));
                    break;
                }
                case RIGHT: {
                    this.sphereRot.startRotRight(UpdatingThread.TimingMode.NANOSECONDS.getSecondsAsFloat(e.getWhen()));
                    break;
                }
                case ESCAPE: {
                    this.renderLoop.end();
                }
            }
        }

        public void onKeyReleased(KeyReleasedEvent e, Key key) {
            switch (key.getKeyID()) {
                case LEFT: {
                    this.sphereRot.stopRotLeft();
                    break;
                }
                case RIGHT: {
                    this.sphereRot.stopRotRight();
                }
            }
        }

        public CustomInputListener(RenderLoop renderLoop, SphereRotator sphereRot) {
            this.renderLoop = renderLoop;
            this.sphereRot = sphereRot;
        }
    }

    private class SphereRotator
    implements Updatable {
        private static final float ROTATION_SPEED = 0.1f;
        private final TransformGroup rotTG;
        private float startRotLeftTime = -1.0f;
        private float startRotRightTime = -1.0f;
        private float angle = 0.0f;
        private float deltaAngleLeft = 0.0f;
        private float deltaAngleRight = 0.0f;

        public void startRotLeft(float seconds) {
            this.startRotLeftTime = seconds;
            this.deltaAngleLeft = 0.0f;
        }

        public void stopRotLeft() {
            this.startRotLeftTime = -1.0f;
            this.angle = (this.angle + this.deltaAngleLeft) % ((float)Math.PI * 2);
            this.deltaAngleLeft = 0.0f;
        }

        public void startRotRight(float seconds) {
            this.startRotRightTime = seconds;
            this.deltaAngleRight = 0.0f;
        }

        public void stopRotRight() {
            this.startRotRightTime = -1.0f;
            this.angle = (this.angle + this.deltaAngleRight) % ((float)Math.PI * 2);
            this.deltaAngleRight = 0.0f;
        }

        public void update(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
            float deltaAngle;
            float rotTime;
            float seconds;
            if (this.startRotLeftTime != -1.0f) {
                seconds = timingMode.getSecondsAsFloat(gameTime);
                rotTime = seconds - this.startRotLeftTime;
                this.deltaAngleLeft = -rotTime * 0.1f * ((float)Math.PI * 2);
            }
            if (this.startRotRightTime != -1.0f) {
                seconds = timingMode.getSecondsAsFloat(gameTime);
                rotTime = seconds - this.startRotRightTime;
                this.deltaAngleRight = rotTime * 0.1f * ((float)Math.PI * 2);
            }
            if ((deltaAngle = this.deltaAngleLeft + this.deltaAngleRight) != 0.0f) {
                this.rotTG.getTransform().setIdentity();
                this.rotTG.getTransform().rotY((this.angle + deltaAngle) % ((float)Math.PI * 2));
                this.rotTG.updateTransform();
            }
        }

        public SphereRotator(TransformGroup rotTG) {
            this.rotTG = rotTG;
        }
    }
}

