/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.input;

import java.net.URL;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.DeviceComponent;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.devices.components.Keys;
import org.jagatoo.input.devices.components.MouseAxis;
import org.jagatoo.input.events.KeyPressedEvent;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.jagatoo.input.events.KeyStateEvent;
import org.jagatoo.opengl.enums.TextureFilter;
import org.openmali.types.twodee.Sized2iRO;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Point2f;
import org.openmali.vecmath2.Tuple2f;
import org.openmali.vecmath2.Vector2f;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.input.FirstPersonInputHandler;
import org.xith3d.input.modules.fpih.FPIHInputAction;
import org.xith3d.input.modules.fpih.FPIHPhysics;
import org.xith3d.input.modules.fpih.MovementListener;
import org.xith3d.loaders.models.Model;
import org.xith3d.loaders.models.ModelLoader;
import org.xith3d.loaders.models.animations.AnimationListener;
import org.xith3d.loaders.models.animations.ModelAnimation;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.physics.PhysicsEngine;
import org.xith3d.physics.collision.CollideableGroup;
import org.xith3d.physics.collision.CollisionEngine;
import org.xith3d.physics.collision.collideable.BoxCollideable;
import org.xith3d.physics.joode.JoodePhysicsEngine;
import org.xith3d.physics.simulation.SimulationWorld;
import org.xith3d.render.Canvas3D;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.AmbientLight;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.DirectionalLight;
import org.xith3d.scenegraph.Node;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.StaticTransform;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.Transform;
import org.xith3d.scenegraph.Transformable;
import org.xith3d.scenegraph.avatar.DefaultAvatarTransform;
import org.xith3d.scenegraph.primitives.Rectangle;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.scenegraph.SkyBoxTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.ui.hud.HUD;
import org.xith3d.ui.hud.base.AbstractButton;
import org.xith3d.ui.hud.listeners.ButtonListener;
import org.xith3d.ui.hud.widgets.Button;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"An advanced demonstration of the FirstPersonInputHandler's features.", "This also includes avatar-collision-detection."}, authors={"Marvin Froehlich (aka Qudus)"})
public class FirstPersonInputHandlerTest
extends Xith3DTest
implements MovementListener,
AnimationListener {
    private static final Vector2f X_AXIS = new Vector2f(1.0f, 0.0f);
    private FirstPersonInputHandler fpih;
    private Node fpihDebugNode;
    private Model avatar;
    private Transform avatarTG;
    private PhysicsEngine physEngine;
    private CollideableGroup collGroup;

    public void onKeyPressed(KeyPressedEvent e, Key key) {
        switch (key.getKeyID()) {
            case Y: {
                this.fpih.flipMouseYAxis();
                break;
            }
            case ESCAPE: {
                this.end();
            }
        }
    }

    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case V: {
                this.fpihDebugNode.setRenderable(!this.fpihDebugNode.isRenderable());
                break;
            }
            case ESCAPE: {
                this.end();
            }
        }
    }

    public void onKeyStateChanged(KeyStateEvent e, Key key, boolean state) {
        switch (key.getKeyID()) {
            case LEFT_CONTROL: {
                this.fpih.setSuspended(state);
            }
        }
    }

    public void onPlayerCrouched() {
    }

    public void onPlayerJumped() {
        this.avatar.setCurrentAnimation("jump");
    }

    public void onPlayerMovementStarted(FPIHInputAction action) {
        if (action.isMovement()) {
            this.avatar.setCurrentAnimation("run");
        }
    }

    public void onPlayerMovementStopped(FPIHInputAction action) {
        if (!this.fpih.getStatesManager().isMoving()) {
            this.avatar.setCurrentAnimation("stand");
        }
    }

    public void onPlayerStoodUp() {
        this.avatar.setCurrentAnimation("stand");
    }

    public void onAnimationStarted(ModelAnimation animation) {
    }

    public void onAnimationFinished(ModelAnimation animation) {
        if (animation.getName().equals("jump")) {
            if (this.fpih.getStatesManager().isMoving()) {
                this.avatar.setCurrentAnimation("run");
            } else {
                this.avatar.setCurrentAnimation("stand");
            }
        }
    }

    private void createAvatarCollider(PhysicsEngine physEngine, FirstPersonInputHandler fpHandler, BranchGroup sceneBranch) {
        SimulationWorld world = physEngine.getSimulationEngine().newWorld();
        world.setGravity(0.0f, -9.81f, 0.0f);
        fpHandler.setPhysicsObject(new FPIHPhysics(1.5f, 2.0f, new Vector3f(0.0f, -1.0f, 0.0f), physEngine, world, true, true));
        this.fpihDebugNode = fpHandler.getPhysicsObject().getDebugNode();
        sceneBranch.addChild(this.fpihDebugNode);
        fpHandler.getPhysicsObject().setSlidingColliderCheckCallback(physEngine.getCollisionEngine(), this.collGroup);
    }

    private void loadAvatar(URL modelResource, String skin, FirstPersonInputHandler fpHandler, BranchGroup sceneBranch, PhysicsEngine physEngine) throws Exception {
        this.avatar = ModelLoader.getInstance().loadModel(modelResource, skin, 0.04f);
        this.avatarTG = new Transform();
        this.avatarTG.getTransform().setIdentity();
        this.avatarTG.addRotationY(1.5707964f);
        this.avatarTG.addChild(this.avatar);
        this.avatar.addAnimationListener(this);
        this.avatar.setCurrentAnimation("stand");
        this.avatarTG.addChild(new AmbientLight(Colorf.GRAY50));
        DefaultAvatarTransform at = new DefaultAvatarTransform((Node)this.avatarTG, -1.0f, sceneBranch);
        fpHandler.addAvatar(at);
        fpHandler.setThirdPersonOffset(0.0f, 0.0f, 3.0f);
        fpHandler.setMaxThirdPersonDistance(7.0f);
        fpHandler.setDiscreteThirdPersonStepSize(0.5f);
        this.createAvatarCollider(physEngine, fpHandler, sceneBranch);
    }

    private void createWorldColliders(CollisionEngine collEngine, Shape3D[] shapes) {
        this.collGroup = collEngine.newGroup("Simple");
        for (int i = 0; i < shapes.length; ++i) {
            BoxCollideable collider = collEngine.newBox(shapes[i]);
            this.collGroup.addCollideable(collider);
        }
    }

    private float getAngle2X(Vector2f vec) {
        if (vec.getY() <= 0.0f) {
            return vec.angle(X_AXIS);
        }
        return (float)Math.PI * 2 - X_AXIS.angle(vec);
    }

    private Shape3D createFloor(float width, float height) {
        Rectangle floor = new Rectangle(width, height, Rectangle.ZeroPointLocation.CENTER_CENTER, "grass.jpg");
        floor.setTexturePosition(new Vector2f(width, height));
        StaticTransform.rotateX(floor, 1.5707964f);
        return floor;
    }

    private Rectangle createWall(Tuple2f begin, Tuple2f end) {
        Vector2f wallVec = new Vector2f(end.getX() - begin.getX(), end.getY() - begin.getY());
        float angle = this.getAngle2X(wallVec);
        Rectangle wall = new Rectangle(wallVec.length(), 10.0f, Rectangle.ZeroPointLocation.BOTTOM_LEFT, "stone.jpg");
        wall.setTexturePosition(new Vector2f(wallVec.length() / 5.0f, 2.0f));
        StaticTransform.rotateY(wall, angle);
        StaticTransform.translate(wall, begin.getX(), 0.0f, begin.getY());
        return wall;
    }

    private BranchGroup createSceneGraph(ResourceLocator resLoc, FirstPersonInputHandler fpHandler) throws Exception {
        BranchGroup scene = new BranchGroup();
        scene.addChild(new DirectionalLight(true, Colorf.GRAY50, new Vector3f(0.0f, -0.77f, -0.77f)));
        Texture.setDefaultFilter(TextureFilter.TRILINEAR);
        float ROOM_WIDTH = 20.0f;
        float ROOM_DEPTH = 20.0f;
        Shape3D[] shapes = new Shape3D[]{this.createWall(new Point2f(-10.0f, -10.0f), new Point2f(10.0f, -10.0f)), this.createWall(new Point2f(10.0f, -10.0f), new Point2f(10.0f, 10.0f)), this.createWall(new Point2f(10.0f, 10.0f), new Point2f(-10.0f, 10.0f)), this.createWall(new Point2f(-10.0f, 10.0f), new Point2f(-10.0f, -10.0f)), this.createFloor(24.0f, 24.0f)};
        for (int i = 0; i < shapes.length; ++i) {
            scene.addChild(shapes[i]);
        }
        this.createWorldColliders(this.physEngine.getCollisionEngine(), shapes);
        Texture.setDefaultFilter(TextureFilter.NICER);
        this.loadAvatar(resLoc.getResource("models/tris.md2"), "marvin.pcx", fpHandler, scene, this.physEngine);
        return scene;
    }

    private HUD createHUD(Sized2iRO canvasRes) {
        HUD hud = new HUD(canvasRes, 800.0f);
        Button exitButton = new Button(100.0f, 40.0f, "Exit");
        hud.getContentPane().addWidget(exitButton, 10.0f, 10.0f);
        exitButton.addButtonListener(new ButtonListener(){

            public void onButtonClicked(AbstractButton button, Object userObject) {
                FirstPersonInputHandlerTest.this.end();
            }
        });
        DeviceComponent[] comps = new DeviceComponent[]{new MouseAxis(null, 'm', "FPS input"), Keys.LEFT_CONTROL, Keys.V, Keys.Y};
        String[] boundActions = new String[]{"Control Marvin", "Get HUD mouse control", "Toggle FirstPersonInputHandler collider visualization", "Invert the mouse y-axis"};
        TestUtils.displayInputBindings(comps, boundActions, hud);
        return hud;
    }

    public FirstPersonInputHandlerTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(0.0f, 4.5f, 3.0f, 0.0f, 1.75f, 0.0f, 0.0f, 1.0f, 0.0f, this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.useAsSingletonInstance();
        resLoc.createAndAddTSL("textures");
        this.physEngine = new JoodePhysicsEngine();
        env.setPhysicsEngine(this.physEngine);
        env.addRenderPass(SkyBoxTest.createSkyBox(resLoc.getResource("skyboxes/"), "normal"));
        this.fpih = new FirstPersonInputHandler((Transformable)env.getView(), arguments.getResolution(), 1.0f, 1.0f, arguments.getMouseYInverted(), 0.7f);
        this.fpih.getMovementConstraints().setFixedPlaneEnabled(true);
        this.fpih.getBindingsManager().createDefaultBindings();
        this.fpih.getBindingsManager().unbind(FPIHInputAction.CROUCH);
        this.fpih.addMovementListener(this);
        env.addPerspectiveBranch(this.createSceneGraph(resLoc, this.fpih));
        env.addHUD(this.createHUD(arguments.getResolution()));
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
        InputSystem.getInstance().addInputHandler(this.fpih);
    }

    public static void main(String[] args) throws Throwable {
        FirstPersonInputHandlerTest test = new FirstPersonInputHandlerTest(FirstPersonInputHandlerTest.parseCommandLine(args));
        test.begin();
    }
}

