/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.lighting;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.openmali.vecmath2.Colorf;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.render.Canvas3D;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.AmbientLight;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.ColoringAttributes;
import org.xith3d.scenegraph.Material;
import org.xith3d.scenegraph.PolygonAttributes;
import org.xith3d.scenegraph.StaticTransform;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.scenegraph.primitives.Cube;
import org.xith3d.scenegraph.primitives.Rectangle;
import org.xith3d.schedops.movement.RotatableGroup;
import org.xith3d.schedops.movement.TransformationDirectives;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"Simple Xith3D Coloring Attributes test"}, authors={"YVG"})
public class AmbientLightingTest
extends Xith3DTest {
    private Material mat;

    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case SPACE: {
                this.mat.setLightingEnabled(!this.mat.isLightingEnabled());
                break;
            }
            case ESCAPE: {
                this.end();
            }
        }
    }

    private void createSceneGraph(Xith3DEnvironment env) throws Exception {
        BranchGroup objRoot = new BranchGroup();
        RotatableGroup testRotateYGroup = new RotatableGroup(new TransformationDirectives(0.0f, 0.1f, 0.0f));
        objRoot.addChild(testRotateYGroup);
        AmbientLight light = new AmbientLight(true, Colorf.BLUE);
        objRoot.addChild(light);
        TransformGroup sceneRootTransform = new TransformGroup();
        Transform3D t = new Transform3D();
        t.setIdentity();
        sceneRootTransform.setTransform(t);
        testRotateYGroup.addChild(sceneRootTransform);
        Texture2D texture = TextureLoader.getInstance().getTexture("stone.jpg");
        this.mat = new Material();
        this.mat.setAmbientColor(Colorf.GRAY25);
        this.mat.setLightingEnabled(true);
        Rectangle rect = new Rectangle(0.0f, 0.6f, 0.6f, Colorf.WHITE);
        StaticTransform.translate(rect, -0.4f, -0.4f, 0.0f);
        Appearance app = rect.getAppearance(true);
        app.getColoringAttributes(true).setShadeModel(ColoringAttributes.SHADE_FLAT);
        app.setPolygonAttributes(new PolygonAttributes(PolygonAttributes.POLYGON_FILL, PolygonAttributes.CULL_NONE));
        sceneRootTransform.addChild(rect);
        rect = new Rectangle(0.0f, 0.6f, 0.6f, Colorf.RED);
        StaticTransform.translate(rect, 0.4f, -0.4f, 0.0f);
        app = rect.getAppearance(true);
        app.setPolygonAttributes(new PolygonAttributes(PolygonAttributes.POLYGON_FILL, PolygonAttributes.CULL_NONE));
        app.getColoringAttributes(true).setShadeModel(ColoringAttributes.SHADE_FLAT);
        sceneRootTransform.addChild(rect);
        rect = new Rectangle(0.0f, 0.6f, 0.6f, Colorf.GREEN);
        StaticTransform.translate(rect, -0.4f, 0.4f, 0.0f);
        app = rect.getAppearance(true);
        app.getColoringAttributes(true).setShadeModel(ColoringAttributes.SHADE_FLAT);
        app.setPolygonAttributes(new PolygonAttributes(PolygonAttributes.POLYGON_FILL, PolygonAttributes.CULL_NONE));
        sceneRootTransform.addChild(rect);
        rect = new Rectangle(0.0f, 0.6f, 0.6f, Colorf.BLUE);
        StaticTransform.translate(rect, 0.4f, 0.4f, 0.0f);
        app = rect.getAppearance(true);
        app.getColoringAttributes(true).setShadeModel(ColoringAttributes.SHADE_FLAT);
        app.setPolygonAttributes(new PolygonAttributes(PolygonAttributes.POLYGON_FILL, PolygonAttributes.CULL_NONE));
        sceneRootTransform.addChild(rect);
        Appearance a = new Appearance();
        a.setPolygonAttributes(new PolygonAttributes(PolygonAttributes.POLYGON_FILL, PolygonAttributes.CULL_BACK));
        a.setTexture(texture);
        a.setMaterial(this.mat);
        Cube cube = new Cube(0.8f, a);
        StaticTransform.translate(cube, 0.0f, 0.0f, -0.6f);
        sceneRootTransform.addChild(cube);
        env.addPerspectiveBranch(objRoot);
        this.getAnimator().addAnimatableObject(testRotateYGroup);
    }

    public AmbientLightingTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(0.0f, 0.0f, 3.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        this.createSceneGraph(env);
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
        System.out.println("Hit SPACE to toggle lights enabled/disabled policy, or ESC to exit");
    }

    public static void main(String[] args) throws Throwable {
        AmbientLightingTest test = new AmbientLightingTest(AmbientLightingTest.parseCommandLine(args));
        test.begin();
    }
}

