/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.lighting;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.render.Canvas3D;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.DirectionalLight;
import org.xith3d.scenegraph.Material;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.scenegraph.primitives.Sphere;
import org.xith3d.schedops.movement.RotatableGroup;
import org.xith3d.schedops.movement.TransformationDirectives;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"Simple Xith3D Coloring Attributes test"}, authors={"YVG"})
public class DirectLightingTest
extends Xith3DTest {
    private Material mat;

    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case SPACE: {
                this.mat.setLightingEnabled(!this.mat.isLightingEnabled());
                break;
            }
            case ESCAPE: {
                this.end();
            }
        }
    }

    private void createSceneGraph(Xith3DEnvironment env) throws Exception {
        BranchGroup objRoot = new BranchGroup();
        RotatableGroup testRotateYGroup = new RotatableGroup(new TransformationDirectives(0.0f, 0.1f, 0.0f));
        objRoot.addChild(testRotateYGroup);
        DirectionalLight dlight = new DirectionalLight(true, Colorf.GRAY30, new Vector3f(1.0f, -1.0f, 0.0f));
        objRoot.addChild(dlight);
        TransformGroup sceneRootTransform = new TransformGroup();
        Transform3D t = new Transform3D();
        t.setIdentity();
        sceneRootTransform.setTransform(t);
        testRotateYGroup.addChild(sceneRootTransform);
        Texture2D texture = TextureLoader.getInstance().getTexture("deathstar.jpg");
        this.mat = new Material();
        this.mat.setEmissiveColor(Colorf.BLACK);
        this.mat.setSpecularColor(Colorf.GRAY50);
        this.mat.setAmbientColor(Colorf.GRAY25);
        this.mat.setDiffuseColor(Colorf.GRAY25);
        this.mat.setLightingEnabled(true);
        Sphere sphere = new Sphere(1.0f, 64, 64, 11, false, 2);
        Appearance a = new Appearance();
        a.setTexture(texture);
        a.setMaterial(this.mat);
        sphere.setAppearance(a);
        sceneRootTransform.addChild(sphere);
        env.addPerspectiveBranch(objRoot);
        this.getAnimator().addAnimatableObject(testRotateYGroup);
    }

    public DirectLightingTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(0.0f, 2.0f, 3.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        this.createSceneGraph(env);
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
        System.out.println("Hit SPACE to toggle projection policy, or ESC to exit");
    }

    public static void main(String[] args) throws Throwable {
        DirectLightingTest test = new DirectLightingTest(DirectLightingTest.parseCommandLine(args));
        test.begin();
    }
}

