/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.lighting;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.render.Canvas3D;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.AmbientLight;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.DirectionalLight;
import org.xith3d.scenegraph.Material;
import org.xith3d.scenegraph.Node;
import org.xith3d.scenegraph.PointLight;
import org.xith3d.scenegraph.SpotLight;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.scenegraph.primitives.Sphere;
import org.xith3d.schedops.movement.GroupTranslator;
import org.xith3d.schedops.movement.RotatableGroup;
import org.xith3d.schedops.movement.TransformationDirectives;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"Simple Xith3D Sphere Motion and Lighting test"}, authors={"Yuri Vl. Gushchin (aka YVG)", "Marvin Froehlich (aka Qudus)"})
public class SphereMotionLightingTest
extends Xith3DTest {
    private static final int DIRECTIONAL_LIGHT = 0;
    private static final int POINT_LIGHT = 1;
    private static final int SPOT_LIGHT = 2;
    private static int lightType = 0;
    private DirectionalLight lgt1d;
    private DirectionalLight lgt2d;
    private PointLight lgt1p;
    private PointLight lgt2p;
    private SpotLight lgt1s;
    private SpotLight lgt2s;

    private final void applyLightType(int lightType) {
        switch (lightType) {
            case 0: {
                this.lgt1d.setEnabled(true);
                this.lgt2d.setEnabled(true);
                this.lgt1p.setEnabled(false);
                this.lgt2p.setEnabled(false);
                this.lgt1s.setEnabled(false);
                this.lgt2s.setEnabled(false);
                break;
            }
            case 1: {
                this.lgt1d.setEnabled(false);
                this.lgt2d.setEnabled(false);
                this.lgt1p.setEnabled(true);
                this.lgt2p.setEnabled(true);
                this.lgt1s.setEnabled(false);
                this.lgt2s.setEnabled(false);
                break;
            }
            case 2: {
                this.lgt1d.setEnabled(false);
                this.lgt2d.setEnabled(false);
                this.lgt1p.setEnabled(false);
                this.lgt2p.setEnabled(false);
                this.lgt1s.setEnabled(true);
                this.lgt2s.setEnabled(true);
            }
        }
    }

    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case SPACE: {
                lightType = (lightType + 1) % 3;
                this.applyLightType(lightType);
                break;
            }
            case ESCAPE: {
                this.end();
            }
        }
    }

    private BranchGroup createSceneGraph() throws Exception {
        Colorf eColor = Colorf.BLACK;
        Colorf sColor = Colorf.WHITE;
        Colorf objColor = Colorf.GRAY40;
        Colorf lColor1 = Colorf.RED;
        Colorf lColor2 = Colorf.GREEN;
        Colorf alColor = Colorf.GRAY80;
        BranchGroup objRoot = new BranchGroup();
        TransformGroup objScale = new TransformGroup();
        Transform3D t3d = new Transform3D();
        objScale.setTransform(t3d);
        objRoot.addChild(objScale);
        Material m = new Material(objColor, eColor, objColor, sColor, 100.0f);
        Appearance a = new Appearance();
        m.setLightingEnabled(true);
        m.setColorTarget(Material.NONE);
        a.setMaterial(m);
        Sphere sphere0 = new Sphere(1.0f, 64, 64, 3, false, 2);
        sphere0.setName("sphere0");
        sphere0.setAppearance(a);
        TransformGroup sphereTrans = new TransformGroup();
        sphereTrans.addChild(sphere0);
        objScale.addChild(sphereTrans);
        this.getAnimator().addAnimatableObject(new SphereTranslator(sphereTrans, 2.0f, -1.5f, 1.5f));
        RotatableGroup l1RotTrans = new RotatableGroup(new TransformationDirectives(0.0f, 0.25f, 0.0f));
        sphereTrans.addChild(l1RotTrans);
        this.getAnimator().addAnimatableObject(l1RotTrans);
        TransformGroup l2RotTrans = new TransformGroup();
        sphereTrans.addChild(l2RotTrans);
        Transform3D t = new Transform3D();
        Vector3f lPos1 = new Vector3f(0.0f, 0.0f, 2.0f);
        t.set(lPos1);
        TransformGroup l1Trans = new TransformGroup(t);
        l1RotTrans.addChild(l1Trans);
        t = new Transform3D();
        Vector3f lPos2 = new Vector3f(0.5f, 0.8f, 2.0f);
        t.set(lPos2);
        TransformGroup l2Trans = new TransformGroup(t);
        l2RotTrans.addChild(l2Trans);
        Sphere sphere1 = new Sphere(0.05f, 8, 8, lColor1);
        sphere1.setName("sphere1");
        l1Trans.addChild(sphere1);
        Sphere sphere2 = new Sphere(0.05f, 8, 8, lColor2);
        sphere2.setName("sphere2");
        l2Trans.addChild(sphere2);
        AmbientLight aLgt = new AmbientLight(alColor);
        objRoot.addChild(aLgt);
        Point3f atten = new Point3f(1.0f, 0.0f, 0.0f);
        Vector3f lDirect1 = new Vector3f(lPos1);
        lDirect1.negate();
        lDirect1.normalize();
        Vector3f lDirect2 = new Vector3f(lPos2);
        lDirect2.negate();
        lDirect2.normalize();
        this.lgt1d = new DirectionalLight(lColor1, lDirect1);
        this.lgt1d.setTrackedNode(sphere1);
        objRoot.addChild(this.lgt1d);
        this.lgt2d = new DirectionalLight(lColor2, lDirect2);
        objRoot.addChild(this.lgt2d);
        this.lgt1p = new PointLight(lColor1, (Node)sphere1, (Tuple3f)atten);
        objRoot.addChild(this.lgt1p);
        this.lgt2p = new PointLight(lColor2, (Node)sphere2, (Tuple3f)atten);
        objRoot.addChild(this.lgt2p);
        this.lgt1s = new SpotLight(lColor1, (Tuple3f)lDirect1, sphere1, (Tuple3f)atten, 1.5707964f, 10.0f);
        objRoot.addChild(this.lgt1s);
        this.lgt2s = new SpotLight(lColor2, (Tuple3f)lDirect2, sphere2, (Tuple3f)atten, 1.5707964f, 10.0f);
        objRoot.addChild(this.lgt2s);
        this.applyLightType(lightType);
        return objRoot;
    }

    public SphereMotionLightingTest(BasicApplicationArguments arguments) throws Throwable {
        super((Float)null);
        Xith3DEnvironment env = new Xith3DEnvironment(0.0f, 0.0f, 5.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        env.addPerspectiveBranch(this.createSceneGraph()).getConfig().setFrontClipDistance(0.001f);
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
        System.out.println("Hit SPACE to toggle lighting mode (directional, point, spot), or ESC to exit");
    }

    public static void main(String[] args) throws Throwable {
        SphereMotionLightingTest test = new SphereMotionLightingTest(SphereMotionLightingTest.parseCommandLine(args));
        test.begin();
    }

    private class SphereTranslator
    extends GroupTranslator {
        public SphereTranslator(TransformGroup tg, float speed, float min, float max) {
            super(tg, new TransformationDirectives(0.0f, 0.0f, speed));
            this.getDistanceInterpolater(TransformationDirectives.Axes.Z_AXIS).setMinValue(min);
            this.getDistanceInterpolater(TransformationDirectives.Axes.Z_AXIS).setMaxValue(max);
            this.getDistanceInterpolater(TransformationDirectives.Axes.Z_AXIS).setTurnsBack(true);
        }
    }
}

