/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.loaders;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loaders.models.ModelLoader;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.render.Canvas3D;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.AmbientLight;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.DirectionalLight;
import org.xith3d.scenegraph.Material;
import org.xith3d.scenegraph.traversal.impl.MaterialTraversal;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"Test of the Xith3D ASE Loader's GROUP capabilitiest"}, authors={"William Denniss", "Marvin Froehlich (aka Qudus) [code streamlining]"})
public class AseGroupTest
extends Xith3DTest {
    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
            }
        }
    }

    private void createSceneGraph(Xith3DEnvironment env, ResourceLocator resLoc) throws Exception {
        BranchGroup objRoot = new BranchGroup();
        AmbientLight light = new AmbientLight(true, Colorf.GRAY60);
        DirectionalLight dlight = new DirectionalLight(true, Colorf.GRAY30, new Vector3f(-1.0f, -1.0f, -1.0f));
        objRoot.addChild(light);
        objRoot.addChild(dlight);
        int flags = ModelLoader.getInstance().getFlags() & 0xFFFFFFDF;
        objRoot.addChild(ModelLoader.getInstance().loadModel(resLoc.getResource("models/rotatingcubetest.ASE"), 1.0f, flags));
        Material mat2 = new Material();
        mat2.setEmissiveColor(0.0f, 0.0f, 0.0f);
        mat2.setSpecularColor(0.5f, 0.5f, 0.5f);
        mat2.setAmbientColor(0.75f, 0.0f, 0.0f);
        mat2.setDiffuseColor(0.75f, 0.0f, 0.0f);
        mat2.setLightingEnabled(true);
        objRoot.traverse(new MaterialTraversal(mat2));
        env.addPerspectiveBranch(objRoot);
    }

    public AseGroupTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(-250.0f, 150.0f, -150.0f, -0.0f, 0.0f, 150.0f, 0.0f, 1.0f, 0.0f, this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        this.createSceneGraph(env, resLoc);
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
        System.out.println("Hit ESC to exit\nPress 3 to stop/start rotation");
    }

    public static void main(String[] args) throws Throwable {
        AseGroupTest test = new AseGroupTest(AseGroupTest.parseCommandLine(args));
        test.begin();
    }
}

