/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.loaders;

import java.util.Map;
import org.jagatoo.datatypes.NamedObject;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loaders.models.Model;
import org.xith3d.loaders.models.ModelLoader;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.render.Canvas3D;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;
import org.xith3d.utility.interpolate.AngleInterpolater;

@Xith3DTest.Description(fulltext={"Test of the Xith3D ASE Loader's getTransformGroupTree capabilities."}, authors={"William Denniss", "Marvin Froehlich (aka Qudus) [code streamlining]"})
public class AseTransformGroupTreeTest
extends Xith3DTest {
    private TransformGroup box1;
    private TransformGroup box2;
    private TransformGroup group;
    private Model world;
    private TransformGroup worldTransform;
    private boolean individualOn = true;
    private boolean groupOn = true;
    private boolean worldOn = true;
    private AngleInterpolater iAngle = new AngleInterpolater(0.0f, 5.0f, 0.0f, (float)Math.PI * 2, true);
    private AngleInterpolater gAngle = new AngleInterpolater(0.0f, 7.0f, 0.0f, (float)Math.PI * 2, true);
    private AngleInterpolater wAngle = new AngleInterpolater(0.0f, 1.5f, 0.0f, (float)Math.PI * 2, true);

    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
                break;
            }
            case _1: {
                this.individualOn = !this.individualOn;
                break;
            }
            case _2: {
                this.groupOn = !this.groupOn;
                break;
            }
            case _3: {
                this.worldOn = !this.worldOn;
            }
        }
    }

    private void createSceneGraph(Xith3DEnvironment env, ResourceLocator resLoc) throws Exception {
        BranchGroup objRoot = new BranchGroup();
        int flags = ModelLoader.getInstance().getFlags() & 0xFFFFFFDF;
        this.world = ModelLoader.getInstance().loadModel(resLoc.getResource("models/rotatingcubetest.ASE"), 1.0f, flags);
        Map<String, NamedObject> namedObjects = this.world.getNamedObjects();
        this.worldTransform = new TransformGroup();
        this.worldTransform.addChild(this.world);
        objRoot.addChild(this.worldTransform);
        System.out.println("**** Named Nodes *****");
        this.world.dumpNamedObjects(true);
        System.out.println("*********");
        this.box1 = (TransformGroup)namedObjects.get("Box01");
        this.box2 = (TransformGroup)namedObjects.get("Box02");
        this.group = (TransformGroup)namedObjects.get("Group01");
        objRoot.addChild(ModelLoader.getInstance().loadModel(resLoc.getResource("models/origincube.ASE")));
        env.addPerspectiveBranch(objRoot);
    }

    protected void onRenderLoopStarted() {
        this.iAngle.startIncreasing(0L);
        this.gAngle.startIncreasing(0L);
        this.wAngle.startIncreasing(0L);
    }

    protected void prepareNextFrame(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        Transform3D trans;
        super.prepareNextFrame(gameTime, frameTime, timingMode);
        long micros = timingMode.getMicroSeconds(gameTime);
        if (this.individualOn) {
            trans = this.box1.getTransform();
            trans.rotY(this.iAngle.getValue(micros));
            this.box1.setTransform(trans);
            trans = this.box2.getTransform();
            trans.rotY(-this.iAngle.getValue(micros));
            this.box2.setTransform(trans);
        }
        if (this.groupOn) {
            trans = this.group.getTransform();
            trans.rotY(-this.gAngle.getValue(micros));
            this.group.setTransform(trans);
        }
        if (this.worldOn) {
            trans = this.worldTransform.getTransform();
            trans.rotY(this.wAngle.getValue(micros));
            this.worldTransform.updateTransform();
        }
    }

    public AseTransformGroupTreeTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(-250.0f, 150.0f, -150.0f, -0.0f, 0.0f, 150.0f, 0.0f, 1.0f, 0.0f, this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        this.createSceneGraph(env, resLoc);
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
        System.out.println("Hit ESC to exit\nPress 1 to toggle cube rotating, 2 to toggle group rotating and 3 to toggle scene rotating");
    }

    public static void main(String[] args) throws Throwable {
        AseTransformGroupTreeTest test = new AseTransformGroupTreeTest(AseTransformGroupTreeTest.parseCommandLine(args));
        test.begin();
    }
}

