/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.loaders;

import java.net.URL;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.openmali.FastMath;
import org.openmali.types.twodee.Sized2iRO;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loaders.models.Model;
import org.xith3d.loaders.models.ModelLoader;
import org.xith3d.loaders.models.animations.AnimationListener;
import org.xith3d.loaders.models.animations.ModelAnimation;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.RenderPass;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.AmbientLight;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.DirectionalLight;
import org.xith3d.scenegraph.Geometry;
import org.xith3d.scenegraph.Group;
import org.xith3d.scenegraph.Node;
import org.xith3d.scenegraph.SceneGraph;
import org.xith3d.scenegraph.StaticTransform;
import org.xith3d.scenegraph.primitives.Rectangle;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.scenegraph.SkyBoxTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;
import org.xith3d.utility.interpolate.AngleInterpolater;

@Xith3DTest.Description(fulltext={"A simple test example to load up an MD2 model."}, authors={"Kevin Glass", "Amos Wenger (aka BlueSky)", "Marvin Froehlich (aka Qudus)"})
public class MD2LoaderTest
extends Xith3DTest
implements AnimationListener {
    private Canvas3D canvas;
    private Model model;
    private ModelAnimation[] anims;
    private int currentAnim = 0;
    protected static boolean dumpAnimationSwitches = false;
    private DirectionalLight direcLight;
    private long animTime = 0L;
    private AngleInterpolater lightAngle = new AngleInterpolater(0.0f, 1.0f, 0.0f, (float)Math.PI * 2, true);

    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case SPACE: {
                this.canvas.takeScreenshot(false);
                break;
            }
            case ESCAPE: {
                this.end();
            }
        }
    }

    protected void onRenderLoopStarted() {
        this.lightAngle.startIncreasing(0L);
    }

    protected void prepareNextFrame(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        super.prepareNextFrame(gameTime, frameTime, timingMode);
        long micros = timingMode.getMicroSeconds(gameTime);
        float lightAngleValue = this.lightAngle.getValue(gameTime);
        Vector3f dir = new Vector3f(FastMath.cos(lightAngleValue), FastMath.sin(lightAngleValue), -1.0f);
        this.direcLight.setDirection(dir);
        if (this.model.hasAnimations() && this.model.getAnimations().length > 1 && this.model.getCurrentAnimation() != null && micros - this.animTime >= 3000000L) {
            this.currentAnim = (this.currentAnim + 1) % this.anims.length;
            this.model.setCurrentAnimation(this.anims[this.currentAnim]);
            this.animTime = micros;
        }
    }

    public void onAnimationStarted(ModelAnimation animation) {
        if (dumpAnimationSwitches) {
            System.out.println("started: " + animation);
        }
    }

    public void onAnimationFinished(ModelAnimation animation) {
        if (dumpAnimationSwitches) {
            System.out.println("finished: " + animation);
        }
    }

    private Group loadModel(ResourceLocator resLoc) throws Exception {
        URL modelResource = resLoc.getResource("models/tris.md2");
        String skin = "marvin.pcx";
        long t0 = TestUtils.dumpAction("Loading MD2Model \"" + modelResource + "\"...");
        this.model = ModelLoader.getInstance().loadModel(modelResource, skin, 0.04f);
        this.anims = this.model.getAnimations();
        this.model.addAnimationListener(this);
        if (this.model.hasAnimations()) {
            this.model.setCurrentAnimation(this.anims[this.currentAnim]);
        }
        TestUtils.dumpDoneIn(t0);
        return this.model;
    }

    private Node createFloor() {
        long t0 = TestUtils.dumpAction("Creating floor...");
        Rectangle floor = new Rectangle(2.8f, 3.4f, "grass.jpg");
        floor.getGeometry().setOptimization(Geometry.Optimization.USE_VBOS);
        StaticTransform.rotateX(floor, -1.5707964f);
        StaticTransform.translate(floor, -1.2f, -1.5f, 0.0f);
        TestUtils.dumpDoneIn(t0);
        return floor;
    }

    protected RenderPass init(SceneGraph sg, Sized2iRO resolution, ResourceLocator resLoc) throws Exception {
        resLoc.createAndAddTSL("textures");
        sg.addRenderPass(SkyBoxTest.createSkyBox(resLoc.getResource("skyboxes/"), "normal"));
        BranchGroup rootBranch = new BranchGroup();
        rootBranch.addChild(new AmbientLight(Colorf.GRAY50));
        this.direcLight = new DirectionalLight(true, Colorf.GRAY50, Vector3f.POSITIVE_X_AXIS);
        rootBranch.addChild(this.direcLight);
        rootBranch.addChild(this.createFloor());
        rootBranch.addChild(this.loadModel(resLoc));
        return RenderPass.createPerspective(rootBranch);
    }

    protected void initInputSystem(boolean mouseVisible) throws Exception {
        InputSystem.getInstance().registerNewKeyboardAndMouse(this.canvas.getPeer());
        if (!mouseVisible) {
            this.canvas.setCursor(null);
        }
    }

    public MD2LoaderTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(2.41f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, this);
        env.getView().setBackClipDistance(11.0f);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        env.addRenderPass(this.init(env, arguments.getResolution(), resLoc));
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        this.canvas = canvas;
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        this.initInputSystem(true);
    }

    public static void main(String[] args) throws Throwable {
        MD2LoaderTest test = new MD2LoaderTest(MD2LoaderTest.parseCommandLine(args));
        test.begin();
    }
}

