/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.loaders;

import java.net.URL;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.jagatoo.opengl.enums.ColorTarget;
import org.openmali.vecmath2.Colorf;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.input.FirstPersonInputHandler;
import org.xith3d.loaders.models.Model;
import org.xith3d.loaders.models.ModelLoader;
import org.xith3d.loaders.models.util.specific.MD3Tools;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.RenderPass;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.Material;
import org.xith3d.scenegraph.PointLight;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"A simple test example to load up an MD3 model."}, authors={"Marvin Froehlich (aka Qudus)"})
public class MD3LoaderTest
extends Xith3DTest {
    private Canvas3D canvas;
    private static final Material material = new Material();

    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case SPACE: {
                this.canvas.takeScreenshot(false);
                break;
            }
            case ESCAPE: {
                this.end();
            }
        }
    }

    Model loadSinglepartModel(ResourceLocator resLoc) throws Exception {
        URL modelResource = resLoc.getResource("nordhorse.md3");
        long t0 = TestUtils.dumpAction("Loading MD3Model \"" + modelResource + "\"...");
        float scale = 1.0f;
        Model model = ModelLoader.getInstance().loadModel(modelResource, "", scale);
        model.getShape(0).getAppearance().setMaterial(material);
        if (model.hasAnimations()) {
            model.setCurrentAnimation(model.getAnimations()[0]);
        }
        TestUtils.dumpDoneIn(t0);
        return model;
    }

    Model loadMultipartModel(ResourceLocator resLoc) throws Exception {
        String base = "reaper/models/players/reaper/";
        URL legsURL = resLoc.getResource(base + "lower.md3");
        URL torsoURL = resLoc.getResource(base + "upper.md3");
        URL headURL = resLoc.getResource(base + "head.md3");
        String skin = base + "reaper.jpg";
        float scale = 0.2f;
        long t0 = TestUtils.dumpAction("Loading multipart MD3Model...");
        Model model = MD3Tools.loadMultipartModel(legsURL, "tag_torso", torsoURL, "tag_head", headURL, null, skin, material, scale);
        if (model.hasAnimations()) {
            model.setCurrentAnimation(model.getAnimations()[0]);
        }
        TestUtils.dumpDoneIn(t0);
        return model;
    }

    private Model loadModel(ResourceLocator resLoc) throws Exception {
        return this.loadMultipartModel(resLoc);
    }

    protected RenderPass init(ResourceLocator resLoc) throws Exception {
        resLoc.createAndAddTSL("textures");
        resLoc.createAndAddTSL("models");
        BranchGroup rootBranch = new BranchGroup();
        PointLight light = new PointLight();
        light.setColor(Colorf.GRAY50);
        light.setLocation(100.0f, 100.0f, 100.0f);
        rootBranch.addChild(light);
        Model model = this.loadModel(resLoc.getSubLocator("models/"));
        rootBranch.addChild(model);
        return RenderPass.createPerspective(rootBranch);
    }

    protected void initInputSystem(boolean mouseVisible) throws Exception {
        InputSystem.getInstance().registerNewKeyboardAndMouse(this.canvas.getPeer());
        if (!mouseVisible) {
            this.canvas.setCursor(null);
        }
    }

    public MD3LoaderTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(10.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, this);
        env.getView().setBackClipDistance(100.0f);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        env.addRenderPass(this.init(resLoc));
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        this.canvas = canvas;
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        this.initInputSystem(true);
        FirstPersonInputHandler fpHandler = new FirstPersonInputHandler(env.getView(), canvas, 1.0f, -1.0f, 1.0f);
        fpHandler.getBindingsManager().createDefaultBindings();
        InputSystem.getInstance().addInputHandler(fpHandler);
    }

    public static void main(String[] args) throws Throwable {
        MD3LoaderTest test = new MD3LoaderTest(MD3LoaderTest.parseCommandLine(args));
        test.begin();
    }

    static {
        material.setAmbientColor(Colorf.GRAY25);
        material.setDiffuseColor(Colorf.GRAY50);
        material.setColorTarget(ColorTarget.AMBIENT_AND_DIFFUSE);
    }
}

