/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.loaders;

import java.net.URL;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.input.FirstPersonInputHandler;
import org.xith3d.loaders.models.Model;
import org.xith3d.loaders.models.ModelLoader;
import org.xith3d.loaders.models.animations.AnimationListener;
import org.xith3d.loaders.models.animations.ModelAnimation;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.render.Canvas3D;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.AmbientLight;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.DirectionalLight;
import org.xith3d.scenegraph.Geometry;
import org.xith3d.scenegraph.Group;
import org.xith3d.scenegraph.Node;
import org.xith3d.scenegraph.SceneGraph;
import org.xith3d.scenegraph.StaticTransform;
import org.xith3d.scenegraph.Transformable;
import org.xith3d.scenegraph.primitives.Rectangle;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.scenegraph.SkyBoxTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"A basic test of the MD5Loader."}, authors={"Marvin Froehlich (aka Qudus)"})
public class MD5LoaderTest
extends Xith3DTest
implements AnimationListener {
    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
                break;
            }
        }
    }

    public void onAnimationStarted(ModelAnimation animation) {
    }

    public void onAnimationFinished(ModelAnimation animation) {
    }

    private Group loadModel(URL modelResource, String skin) throws Exception {
        Group group = new Group();
        group.addChild(new AmbientLight(Colorf.GRAY50));
        DirectionalLight direcLight = new DirectionalLight(true, Colorf.WHITE, new Vector3f(1.0f, -1.0f, -1.0f));
        group.addChild(direcLight);
        long t0 = TestUtils.dumpAction("Loading MD5Model \"" + modelResource + "\"...");
        Model model = ModelLoader.getInstance().loadModel(modelResource, skin, 0.1f);
        TestUtils.dumpDoneIn(t0);
        group.addChild(model);
        if (model.hasAnimations()) {
            model.setCurrentAnimation(model.getAnimation(0));
        }
        model.addAnimationListener(this);
        return group;
    }

    private Node createFloor() {
        long t0 = TestUtils.dumpAction("Creating floor...");
        Rectangle floor = new Rectangle(2.8f, 3.4f, "grass.jpg");
        floor.getGeometry().setOptimization(Geometry.Optimization.USE_VBOS);
        StaticTransform.rotateX(floor, -1.5707964f);
        StaticTransform.translate(floor, -1.2f, -1.5f, 0.0f);
        TestUtils.dumpDoneIn(t0);
        return floor;
    }

    protected void init(SceneGraph sg, ResourceLocator resLoc) throws Exception {
        resLoc.createAndAddTSL("textures");
        sg.addRenderPass(SkyBoxTest.createSkyBox(resLoc.getResource("skyboxes/"), "normal"));
        BranchGroup rootBranch = new BranchGroup();
        rootBranch.addChild(this.createFloor());
        rootBranch.addChild(this.loadModel(resLoc.getResource("models/md5/bob/Bob_with_lamp_clean.md5mesh"), "rustycan.jpg"));
        sg.addPerspectiveBranch(rootBranch);
    }

    public MD5LoaderTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(0.0f, 0.0f, 10.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        this.init(env, resLoc);
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
        InputSystem.getInstance().addInputHandler(FirstPersonInputHandler.createDefault((Transformable)env.getView(), canvas, 1.0f, 1.0f, arguments.getMouseYInverted(), 0.3f));
    }

    public static void main(String[] args) throws Throwable {
        MD5LoaderTest test = new MD5LoaderTest(MD5LoaderTest.parseCommandLine(args));
        test.begin();
    }
}

