/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.loaders;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loaders.models.Model;
import org.xith3d.loaders.models.util.meta.MetaLoader;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.render.Canvas3D;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.PointLight;
import org.xith3d.scenegraph.SceneGraph;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;
import org.xith3d.utility.screenshots.ScreenshotEngine;

@Xith3DTest.Description(fulltext={"A simple test example to load a model from a meta file."}, authors={"Kevin Glass", "Amos Wenger (aka BlueSky)", "Marvin Froehlich (aka Qudus)", "Andrew Hanson (aka Patheros) modified OBJLoaderTest"})
public class MetaLoaderTest
extends Xith3DTest {
    private static final boolean USE_DISPLAY_LISTS = false;
    private ScreenshotEngine shotEngine;

    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
                break;
            }
            case SPACE: {
                this.shotEngine.takeScreenshot(true);
            }
        }
    }

    private void loadModel(ResourceLocator resLoc, SceneGraph sg) throws Exception {
        MetaLoader loader = new MetaLoader();
        loader.setMetaBaseURL(resLoc.getResource("models/"));
        Model model = loader.loadModel(resLoc.getResource("models/meta/galleon.xml"));
        BranchGroup root = new BranchGroup();
        root.addChild(new PointLight(1.0f, 0.8f, 0.2f, 2.0f, 2.0f, 15.0f, 0.001f));
        root.addChild(model);
        sg.addPerspectiveBranch(root);
    }

    public MetaLoaderTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(5.0f, 1.0f, 80.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, this);
        this.shotEngine = env.getScreenshotEngine();
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        this.loadModel(resLoc, env);
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
    }

    public static void main(String[] args) throws Throwable {
        MetaLoaderTest test = new MetaLoaderTest(MetaLoaderTest.parseCommandLine(args));
        test.begin();
    }
}

