/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.particles;

import java.util.ArrayList;
import java.util.Iterator;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.devices.components.Keys;
import org.jagatoo.input.devices.components.MouseButton;
import org.jagatoo.input.devices.components.MouseButtons;
import org.jagatoo.input.events.KeyPressedEvent;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.jagatoo.input.events.MouseButtonPressedEvent;
import org.openmali.types.twodee.Sized2iRO;
import org.openmali.vecmath2.Colorf;
import org.softmed.jops.ParticleManager;
import org.softmed.jops.ParticleSystem;
import org.softmed.jops.modifiers.PointMass;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.input.FirstPersonInputHandler;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.loop.opscheduler.Animator;
import org.xith3d.render.Canvas3D;
import org.xith3d.resources.ResLoc;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.Node;
import org.xith3d.scenegraph.SceneGraph;
import org.xith3d.scenegraph.StaticTransform;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.scenegraph.Transformable;
import org.xith3d.scenegraph.particles.jops.AbsoluteParticleSystemNode;
import org.xith3d.scenegraph.particles.jops.ParticleManagerUpdater;
import org.xith3d.scenegraph.particles.jops.ParticleSystemNode;
import org.xith3d.scenegraph.particles.jops.RelativeParticleSystemNode;
import org.xith3d.scenegraph.primitives.Sphere;
import org.xith3d.schedops.movement.RotatableGroup;
import org.xith3d.schedops.movement.TransformationDirectives;
import org.xith3d.schedops.movement.TranslatableGroup;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.ui.hud.HUD;
import org.xith3d.ui.hud.base.AbstractButton;
import org.xith3d.ui.hud.base.Border;
import org.xith3d.ui.hud.base.WidgetContainer;
import org.xith3d.ui.hud.layout.BorderLayout;
import org.xith3d.ui.hud.layout.ListLayout;
import org.xith3d.ui.hud.listeners.ButtonListener;
import org.xith3d.ui.hud.listeners.HUDPickMissedListener;
import org.xith3d.ui.hud.listmodels.TextListModel;
import org.xith3d.ui.hud.utils.HUDPickResult;
import org.xith3d.ui.hud.widgets.Button;
import org.xith3d.ui.hud.widgets.ComboBox;
import org.xith3d.ui.hud.widgets.List;
import org.xith3d.ui.hud.widgets.Panel;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"A testcase for Xith3D's abstraction of the \"Java Open Particle System (jops)\""}, authors={"Guilherme Gomes (aka guilhermegrg)"})
public class ParticleSystemTest
extends Xith3DTest
implements HUDPickMissedListener {
    private static final boolean absoluteParticleSystem = false;
    private static final boolean useExternalPointMass = false;
    private static final boolean setPointMassToAllParticleSystems = false;
    private boolean showGeneratorsAndPointMasses = true;
    private FirstPersonInputHandler fpih;
    private BranchGroup scene;
    private ParticleManager pmanager = new ParticleManager();
    private String currentHandleName = null;
    private String handle;
    private ParticleSystem pmps;
    private HUD hud;
    private final ArrayList<ParticleSystemNode> particleSystemNodes = new ArrayList();
    private List list;
    private long lastSuspendTime = -1L;

    public void onKeyPressed(KeyPressedEvent e, Key key) {
        switch (key.getKeyID()) {
            case Y: {
                this.fpih.flipMouseYAxis();
            }
        }
    }

    private String getPSHandle(String name) {
        try {
            if (!name.equals(this.currentHandleName)) {
                this.handle = this.pmanager.load(ResLoc.getResource("ps/" + name + ".ops"));
                this.currentHandleName = name;
            }
            return this.handle;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    private void addNewParticleSystem(String name) {
        try {
            String handle = this.getPSHandle(name);
            if (handle == null) {
                return;
            }
            ParticleSystem ps = this.pmanager.getCopyAttached(handle);
            RelativeParticleSystemNode psn = null;
            psn = new RelativeParticleSystemNode();
            this.particleSystemNodes.add(psn);
            TextListModel model = (TextListModel)this.list.getModel();
            int index = model.addItem(this.currentHandleName);
            model.setItemUserObject(index, psn);
            model.markListDirty();
            this.scene.addChild(psn);
            psn.setShowGeneratorsAndPointMasses(this.showGeneratorsAndPointMasses);
            psn.setParticleSystem(ps);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case Q: {
                this.showGeneratorsAndPointMasses = !this.showGeneratorsAndPointMasses;
                Node psnode = null;
                Iterator<ParticleSystemNode> it = this.particleSystemNodes.iterator();
                while (it.hasNext()) {
                    if (psnode.getRoot() == null) {
                        it.remove();
                    } else if (((ParticleSystemNode)psnode).getParticleSystem().isAlive()) {
                        ((ParticleSystemNode)psnode).setShowGeneratorsAndPointMasses(this.showGeneratorsAndPointMasses);
                    }
                    psnode = it.next();
                }
                break;
            }
            case ESCAPE: {
                this.end();
            }
        }
    }

    public void onMouseButtonPressed(MouseButtonPressedEvent e, MouseButton button) {
        if (!this.fpih.isSuspended() && button == MouseButtons.RIGHT_BUTTON) {
            this.fpih.setSuspended(true);
            this.lastSuspendTime = e.getWhen();
        }
    }

    public void onHUDPickMissed(MouseButton button, int x, int y, HUDPickResult.HUDPickReason pickReason, long when, long meta) {
        if (button == MouseButtons.RIGHT_BUTTON && when != this.lastSuspendTime) {
            this.fpih.setSuspended(false);
        }
    }

    private BranchGroup createScene(ParticleSystem ps, Animator animator) {
        this.scene = new BranchGroup();
        RelativeParticleSystemNode psn = new RelativeParticleSystemNode();
        TransformationDirectives rotDirecs = new TransformationDirectives(0.0f, 0.0f, 0.0f);
        TransformationDirectives transDirecs = new TransformationDirectives(-0.0f, 0.0f, 0.0f);
        TranslatableGroup trans = new TranslatableGroup(transDirecs);
        animator.addAnimatableObject(trans);
        RotatableGroup rg = new RotatableGroup(rotDirecs);
        trans.addChild(rg);
        rg.addChild(psn);
        TransformGroup trans2 = new TransformGroup();
        trans2.addChild(trans);
        RotatableGroup rg2 = new RotatableGroup(rotDirecs);
        rg2.addChild(trans2);
        animator.addAnimatableObject(rg2);
        this.scene.addChild(rg2);
        psn.setParticleSystem(ps);
        psn.setShowGeneratorsAndPointMasses(this.showGeneratorsAndPointMasses);
        TextListModel model = (TextListModel)this.list.getModel();
        int index = model.addItem(this.currentHandleName);
        model.setItemUserObject(index, rg2);
        model.markListDirty();
        Sphere sphere4 = new Sphere(0.1f, 5, 5, Colorf.BLUE);
        StaticTransform.translate(sphere4, -0.9f, 0.0f, 0.0f);
        this.scene.addChild(sphere4);
        AbsoluteParticleSystemNode pmpsn = new AbsoluteParticleSystemNode();
        TransformGroup trans6 = new TransformGroup(new Transform3D(10.0f, 0.0f, 0.0f));
        RotatableGroup rg10 = new RotatableGroup(new TransformationDirectives(0.0f, 0.1f, 0.0f));
        rg10.addChild(trans6);
        animator.addAnimatableObject(rg10);
        TransformGroup trans5 = new TransformGroup(10.0f, 1.8f, 0.0f);
        trans5.addChild(rg10);
        this.scene.addChild(trans5);
        pmpsn.setParticleSystem(this.pmps);
        pmpsn.setShowGeneratorsAndPointMasses(true);
        return this.scene;
    }

    private final void initParticleSystem(String initialPSName, SceneGraph sg) throws Exception {
        String handle = this.getPSHandle(initialPSName);
        ParticleSystem ps = this.pmanager.getCopyAttached(handle);
        this.pmps = new ParticleSystem();
        this.pmps.setLimited(false);
        PointMass pm = new PointMass();
        pm.getStrength().addValue(Float.valueOf(-9.0f), 0.0f);
        pm.setThreshold(false);
        pm.getThresholdValue().addValue(Float.valueOf(1.0f), 0.0f);
        pm.setDistanceVariation("linear");
        pm.setDistanceProportion("inverse");
        sg.addPerspectiveBranch(this.createScene(ps, this.getAnimator()));
        this.getOperationScheduler().scheduleOperation(new ParticleManagerUpdater(this.pmanager));
    }

    private void createHUD(Sized2iRO canvasRes, SceneGraph sceneGraph) {
        Panel main = new Panel(true, 170.0f, 600.0f, new Colorf(1.0f, 1.0f, 1.0f, 0.5f));
        main.setLayout(new BorderLayout(3.0f, 3.0f, 3.0f, 3.0f, 3.0f, 3.0f));
        this.hud = new HUD(canvasRes, 800.0f, (WidgetContainer)main);
        Panel pnlAdd = new Panel(164.0f, 64.0f);
        pnlAdd.setBorder(new Border.Description(6, 6, 6, 6, "border-black.png"));
        pnlAdd.setLayout(new ListLayout(ListLayout.Orientation.VERTICAL, 3.0f, 3.0f, 3.0f, 3.0f, 3.0f));
        main.addWidget(pnlAdd, (Object)BorderLayout.Area.NORTH);
        final ComboBox combo = ComboBox.newTextCombo(170.0f, 22.0f);
        combo.addItem("9candles");
        combo.addItem("blowout");
        combo.addItem("candle");
        combo.addItem("catia");
        combo.addItem("coloredSquares");
        combo.addItem("flowerPower");
        combo.addItem("greenStuff");
        combo.addItem("lightningBall");
        combo.addItem("pentagram");
        combo.addItem("shockRifleBall");
        combo.addItem("snow");
        combo.addItem("spiral3");
        combo.addItem("strange");
        combo.addItem("tornado");
        combo.addItem("tutorialPointMass2");
        combo.addItem("tutorialPointMasses2");
        combo.setSelectedIndex(combo.findItem("tornado"));
        pnlAdd.addWidget(combo);
        Button btnAdd = new Button(170.0f, 22.0f, "Add");
        btnAdd.addButtonListener(new ButtonListener(){

            public void onButtonClicked(AbstractButton button, Object userObject) {
                ParticleSystemTest.this.addNewParticleSystem(combo.getSelectedItem().toString());
            }
        });
        pnlAdd.addWidget(btnAdd);
        Panel pnlRemove = new Panel(10.0f, 10.0f);
        pnlRemove.setBorder(new Border.Description(6, 6, 6, 6, "border-black.png"));
        pnlRemove.setLayout(new BorderLayout(3.0f, 3.0f, 3.0f, 3.0f, 3.0f, 3.0f));
        main.addWidget(pnlRemove, (Object)BorderLayout.Area.CENTER);
        this.list = List.newTextList(170.0f, 200.0f);
        this.list.setAddItemSetsSelectedItem(true);
        pnlRemove.addWidget(this.list, (Object)BorderLayout.Area.CENTER);
        Button btnRemove = new Button(170.0f, 22.0f, "Remove");
        btnRemove.addButtonListener(new ButtonListener(){

            public void onButtonClicked(AbstractButton button, Object userObject) {
                TextListModel model = (TextListModel)ParticleSystemTest.this.list.getModel();
                int selIdx = model.getSelectedIndex();
                if (selIdx < 0) {
                    return;
                }
                Node node2 = (Node)model.getItemUserObject(selIdx);
                if (node2 != null) {
                    ParticleSystemTest.this.scene.removeChild(node2);
                    model.removeItem(selIdx);
                    model.markListDirty();
                }
            }
        });
        pnlRemove.addWidget(btnRemove, (Object)BorderLayout.Area.SOUTH);
        sceneGraph.addHUD(this.hud);
        this.hud.addPickMissedListener(HUDPickResult.HUDPickReason.BUTTON_PRESSED_MASK, this);
    }

    public ParticleSystemTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(0.0f, 0.0f, 5.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("HUD");
        resLoc = resLoc.getSubLocator("jops/");
        resLoc.useAsSingletonInstance();
        resLoc.createAndAddTSL("textures");
        String initialPSName = "tornado";
        this.createHUD(arguments.getResolution(), env);
        this.initParticleSystem("tornado", env);
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
        this.fpih = FirstPersonInputHandler.createDefault((Transformable)env.getView(), (Sized2iRO)canvas, arguments.getMouseYInverted());
        this.fpih.getBindingsManager().createDefaultBindings();
        this.fpih.getBindingsManager().unbind(Keys.SPACE);
        this.fpih.setSuspended(true);
        InputSystem.getInstance().addInputHandler(this.fpih);
    }

    public static void main(String[] args) throws Throwable {
        ParticleSystemTest test = new ParticleSystemTest(ParticleSystemTest.parseCommandLine(args));
        test.begin();
    }
}

