/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.physics;

import java.util.ArrayList;
import java.util.Random;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.jagatoo.opengl.enums.ColorTarget;
import org.openmali.FastMath;
import org.openmali.types.twodee.Sized2iRO;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.physics.PhysicsEngine;
import org.xith3d.physics.collision.Collideable;
import org.xith3d.physics.collision.CollideableBase;
import org.xith3d.physics.collision.CollideableGroup;
import org.xith3d.physics.collision.CollisionEngine;
import org.xith3d.physics.collision.CollisionResolver;
import org.xith3d.physics.collision.collideable.SphereCollideable;
import org.xith3d.physics.joode.JoodePhysicsEngine;
import org.xith3d.physics.simulation.Body;
import org.xith3d.physics.simulation.SimulationWorld;
import org.xith3d.render.Canvas3D;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.AmbientLight;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.ColoringAttributes;
import org.xith3d.scenegraph.DirectionalLight;
import org.xith3d.scenegraph.Material;
import org.xith3d.scenegraph.Node;
import org.xith3d.scenegraph.PointLight;
import org.xith3d.scenegraph.PolygonAttributes;
import org.xith3d.scenegraph.RenderingAttributes;
import org.xith3d.scenegraph.SpotLight;
import org.xith3d.scenegraph.StaticTransform;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.scenegraph.primitives.Cube;
import org.xith3d.scenegraph.primitives.Sphere;
import org.xith3d.schedops.movement.RotatableGroup;
import org.xith3d.schedops.movement.TransformationDirectives;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.ui.hud.HUD;
import org.xith3d.ui.hud.utils.HUDFont;
import org.xith3d.ui.hud.widgets.Label;
import org.xith3d.ui.text2d.TextAlignment;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"Xith3D Collision and Simulation (physics) test"}, authors={"David Yazel", "Marvin Froehlich (aka Qudus)", "Amos Wenger (aka BlueSky)"})
public class CollisionDropTest
extends Xith3DTest {
    private static final int DIRECTIONAL_LIGHT = 0;
    private static final int POINT_LIGHT = 1;
    private static final int SPOT_LIGHT = 2;
    private static int lightType = 0;
    private DirectionalLight lgt1d;
    private DirectionalLight lgt2d;
    private PointLight lgt1p;
    private PointLight lgt2p;
    private SpotLight lgt1s;
    private SpotLight lgt2s;
    private final Random RANDOM = new Random(System.nanoTime());
    private PhysicsEngine physEngine;
    private ArrayList<Body> movingObjects = new ArrayList();
    private ArrayList<Point3f> originalPositions = new ArrayList();
    private ArrayList<Vector3f> originalVelocities = new ArrayList();
    private float angle = 0.0f;
    private float dir = 1.0f;
    private float ofs = 0.0f;

    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case SPACE: {
                if (this.physEngine.isEnabled()) {
                    for (int i = 0; i < this.movingObjects.size(); ++i) {
                        Body body = this.movingObjects.get(i);
                        body.setPosition(this.originalPositions.get(i));
                        body.setLinearVelocity(this.originalVelocities.get(i));
                        body.resetAngularVelocity();
                    }
                    break;
                }
                this.physEngine.setEnabled(true);
                break;
            }
            case L: {
                lightType = (lightType + 1) % 3;
                switch (lightType) {
                    case 0: {
                        this.lgt1d.setEnabled(true);
                        this.lgt2d.setEnabled(true);
                        this.lgt1p.setEnabled(false);
                        this.lgt2p.setEnabled(false);
                        this.lgt1s.setEnabled(false);
                        this.lgt2s.setEnabled(false);
                        break;
                    }
                    case 1: {
                        this.lgt1d.setEnabled(false);
                        this.lgt2d.setEnabled(false);
                        this.lgt1p.setEnabled(true);
                        this.lgt2p.setEnabled(true);
                        this.lgt1s.setEnabled(false);
                        this.lgt2s.setEnabled(false);
                        break;
                    }
                    case 2: {
                        this.lgt1d.setEnabled(false);
                        this.lgt2d.setEnabled(false);
                        this.lgt1p.setEnabled(false);
                        this.lgt2p.setEnabled(false);
                        this.lgt1s.setEnabled(true);
                        this.lgt2s.setEnabled(true);
                    }
                }
                break;
            }
            case ESCAPE: {
                this.end();
            }
        }
    }

    private void addMovingObject(Body body) {
        this.movingObjects.add(body);
        this.originalPositions.add(new Point3f(body.getPosition()));
        this.originalVelocities.add(new Vector3f(body.getLinearVelocity()));
    }

    private Node makeBouncingBall(float x, float y, float z, float radius, PhysicsEngine physEngine, SimulationWorld simWorld, CollideableGroup collGroup) {
        Sphere sphere = new Sphere(radius, 16, 24, "spherebase.jpg");
        sphere.setName("Basketball");
        Appearance a = sphere.getAppearance(true);
        Material m = new Material(Colorf.RED, Colorf.BLACK, Colorf.GRAY40, Colorf.WHITE, 100.0f, ColorTarget.NONE, true);
        a.setMaterial(m);
        a.setPolygonAttributes(new PolygonAttributes(PolygonAttributes.POLYGON_FILL, PolygonAttributes.CULL_BACK));
        sphere.setAppearance(a);
        TransformGroup tg = new TransformGroup();
        tg.addChild(sphere);
        Body body = simWorld.newBody();
        body.setPosition(x, y, z);
        body.setMass(20.0f);
        Vector3f linearVel = new Vector3f(this.RANDOM.nextFloat(), this.RANDOM.nextFloat(), this.RANDOM.nextFloat());
        linearVel.normalize();
        linearVel.scale((1.0f + this.RANDOM.nextFloat()) * 0.2f);
        body.setLinearVelocity(linearVel);
        simWorld.addBody(body);
        SphereCollideable collider = physEngine.getCollisionEngine().newSphere(sphere);
        body.addCollideable(collider);
        collGroup.addCollideable(collider);
        physEngine.getGFXManager().add(collider, tg);
        this.addMovingObject(body);
        return tg;
    }

    private void createSceneGraph(Xith3DEnvironment env, PhysicsEngine physEngine, SimulationWorld simWorld) throws Exception {
        CollisionEngine collEngine = physEngine.getCollisionEngine();
        Colorf eColor = Colorf.BLACK;
        Colorf sColor = Colorf.WHITE;
        Colorf objColor = Colorf.GRAY40;
        Colorf lColor1 = Colorf.WHITE;
        Colorf lColor2 = Colorf.GRAY20;
        Colorf alColor = Colorf.GRAY80;
        PolygonAttributes polyAttrs = null;
        BranchGroup scene = new BranchGroup();
        CollideableGroup dynamicColls = collEngine.newGroup();
        CollideableGroup staticColls = collEngine.newGroup();
        Cube cube = new Cube(12.0f, "white_rect.png");
        StaticTransform.translate(cube, 0.0f, 6.0f, 0.0f);
        cube.setName("Bounding Cube");
        Appearance app = cube.getAppearance(true);
        RenderingAttributes ra = new RenderingAttributes();
        ra.setDepthBufferEnabled(false);
        app.setRenderingAttributes(ra);
        app.setPolygonAttributes(polyAttrs);
        TransformGroup tg = new TransformGroup();
        tg.addChild(cube);
        scene.addChild(tg);
        Collideable collider = collEngine.newBoxOutline(cube);
        staticColls.addCollideable(collider);
        Sphere sphere = new Sphere(1.0f, 32, 32, "deathstar.jpg");
        sphere.setName("Deathstar 1");
        Appearance a = sphere.getAppearance(true);
        Material m = new Material(objColor, eColor, objColor, sColor, 100.0f, ColorTarget.NONE, true);
        a.setMaterial(m);
        a.setPolygonAttributes(polyAttrs);
        sphere.setAppearance(a);
        tg = new TransformGroup();
        tg.addChild(sphere);
        scene.addChild(tg);
        TransformGroup sphereTrans = tg;
        Body body = simWorld.newBody();
        body.setMass(1000.0f);
        body.setPosition(1.0f, 10.0f, 0.0f);
        simWorld.addBody(body);
        SphereCollideable collider2 = collEngine.newSphere(sphere);
        body.addCollideable(collider2);
        dynamicColls.addCollideable(collider2);
        physEngine.getGFXManager().add(collider2, tg);
        this.addMovingObject(body);
        sphere = new Sphere(0.4f, 16, 24, "deathstar.jpg");
        sphere.setName("Deathstar 1");
        a = sphere.getAppearance(true);
        m = new Material(Colorf.RED, eColor, objColor, sColor, 100.0f, ColorTarget.NONE, true);
        a.setMaterial(m);
        a.setPolygonAttributes(polyAttrs);
        sphere.setAppearance(a);
        tg = new TransformGroup();
        tg.addChild(sphere);
        scene.addChild(tg);
        body = simWorld.newBody();
        body.setMass(200.0f);
        body.setPosition(-0.8f, 10.0f, 0.8f);
        simWorld.addBody(body);
        collider2 = collEngine.newSphere(sphere);
        body.addCollideable(collider2);
        dynamicColls.addCollideable(collider2);
        physEngine.getGFXManager().add(collider2, tg);
        this.addMovingObject(body);
        scene.addChild(this.makeBouncingBall(-0.8f, 9.0f, -0.8f, 0.5f, physEngine, simWorld, dynamicColls));
        scene.addChild(this.makeBouncingBall(-4.0f, 9.0f, -0.8f, 0.8f, physEngine, simWorld, dynamicColls));
        scene.addChild(this.makeBouncingBall(-4.0f, 9.0f, -4.5f, 1.0f, physEngine, simWorld, dynamicColls));
        scene.addChild(this.makeBouncingBall(2.0f, 9.0f, -4.5f, 1.0f, physEngine, simWorld, dynamicColls));
        cube = new Cube(2.0f, "jplogo.jpg");
        cube.setName("Cube 1");
        a = cube.getAppearance(true);
        a.setPolygonAttributes(polyAttrs);
        cube.setAppearance(a);
        TransformGroup tg2 = new TransformGroup();
        tg2.getTransform().setTranslation(0.0f, 1.0f, 0.0f);
        tg2.addChild(cube);
        scene.addChild(tg2);
        CollideableBase collider3 = collEngine.newBox(cube);
        collider3.setPosition(0.0f, 1.0f, 0.0f);
        staticColls.addCollideable(collider3);
        physEngine.getGFXManager().add(collider3, tg2);
        cube = new Cube(2.0f, "stone.jpg");
        cube.setName("Cube 2");
        a = cube.getAppearance(true);
        a.setPolygonAttributes(polyAttrs);
        cube.setAppearance(a);
        tg2 = new TransformGroup();
        tg2.getTransform().setTranslation(6.0f, 1.0f, 5.0f);
        tg2.addChild(cube);
        scene.addChild(tg2);
        collider3 = collEngine.newBox(cube);
        collider3.setPosition(6.0f, 1.0f, 5.0f);
        staticColls.addCollideable(collider3);
        physEngine.getGFXManager().add(collider3, tg2);
        cube = new Cube(2.0f, "rustycan.jpg");
        cube.setName("Cube 3");
        a = cube.getAppearance(true);
        a.setPolygonAttributes(polyAttrs);
        cube.setAppearance(a);
        tg2 = new TransformGroup();
        Transform3D t3d = tg2.getTransform();
        t3d.setEuler((float)Math.PI * 3, (float)Math.PI * 6, (float)Math.PI * 10);
        t3d.setTranslation(3.0f, 7.0f, -3.0f);
        tg2.setTransform(t3d);
        tg2.addChild(cube);
        scene.addChild(tg2);
        collider = collEngine.newBox(cube);
        collider.setPosition(3.0f, 7.0f, -3.0f);
        staticColls.addCollideable(collider);
        physEngine.getGFXManager().add(collider, tg2);
        sphere = new Sphere(2.0f, 64, 64, "earth.jpg");
        sphere.setName("Sphere 3");
        a = sphere.getAppearance(true);
        a.setPolygonAttributes(polyAttrs);
        a.setMaterial(new Material());
        sphere.setAppearance(a);
        tg2 = new TransformGroup();
        tg2.getTransform().setTranslation(-2.0f, 5.0f, -1.0f);
        tg2.addChild(sphere);
        scene.addChild(tg2);
        collider3 = collEngine.newSphere(sphere);
        collider3.setPosition(-2.0f, 5.0f, -1.0f);
        staticColls.addCollideable(collider3);
        physEngine.getGFXManager().add(collider3, tg2);
        RotatableGroup l1RotTrans = new RotatableGroup(new TransformationDirectives(0.0f, 0.05f, 0.0f));
        sphereTrans.addChild(l1RotTrans);
        TransformGroup l2RotTrans = new TransformGroup();
        sphereTrans.addChild(l2RotTrans);
        Transform3D t = new Transform3D();
        Vector3f lPos1 = new Vector3f(0.0f, 0.0f, 2.0f);
        t.set(lPos1);
        TransformGroup l1Trans = new TransformGroup(t);
        l1RotTrans.addChild(l1Trans);
        t = new Transform3D();
        Vector3f lPos2 = new Vector3f(0.5f, 0.8f, 2.0f);
        t.set(lPos2);
        TransformGroup l2Trans = new TransformGroup(t);
        l2RotTrans.addChild(l2Trans);
        ColoringAttributes caL1 = new ColoringAttributes();
        ColoringAttributes caL2 = new ColoringAttributes();
        caL1.setColor(lColor1);
        caL2.setColor(lColor2);
        Appearance appL1 = new Appearance();
        Appearance appL2 = new Appearance();
        appL1.setColoringAttributes(caL1);
        appL2.setColoringAttributes(caL2);
        l1Trans.addChild(new Sphere(0.05f, 8, 16, appL1));
        l1Trans.addChild(new Sphere(0.05f, 8, 16, appL2));
        AmbientLight aLgt = new AmbientLight(alColor);
        scene.addChild(aLgt);
        Vector3f lPos1scaled = new Vector3f(lPos1);
        Vector3f lPos2scaled = new Vector3f(lPos2);
        Point3f atten = new Point3f(1.0f, 0.0f, 0.0f);
        Vector3f lDirect1 = new Vector3f(lPos1);
        Vector3f lDirect2 = new Vector3f(lPos2);
        lDirect1.negate();
        lDirect1.normalize();
        lDirect2.negate();
        lDirect2.normalize();
        this.lgt1d = new DirectionalLight(lColor1, lDirect1);
        scene.addChild(this.lgt1d);
        this.lgt2d = new DirectionalLight(lColor2, lDirect2);
        scene.addChild(this.lgt2d);
        this.lgt1p = new PointLight(lColor1, (Tuple3f)lPos1scaled, (Tuple3f)atten);
        scene.addChild(this.lgt1p);
        this.lgt2p = new PointLight(lColor2, (Tuple3f)lPos2scaled, (Tuple3f)atten);
        scene.addChild(this.lgt2p);
        this.lgt1s = new SpotLight(lColor1, (Tuple3f)lPos1scaled, lDirect1, (Tuple3f)atten, 1.5707964f, 10.0f);
        scene.addChild(this.lgt1s);
        this.lgt2s = new SpotLight(lColor2, (Tuple3f)lPos2scaled, lDirect2, (Tuple3f)atten, 1.5707964f, 10.0f);
        scene.addChild(this.lgt2s);
        this.lgt1d.setEnabled(true);
        this.lgt2d.setEnabled(true);
        this.lgt1p.setEnabled(false);
        this.lgt2p.setEnabled(false);
        this.lgt1s.setEnabled(false);
        this.lgt2s.setEnabled(false);
        env.addPerspectiveBranch(scene);
        this.getAnimator().addAnimatableObject(l1RotTrans);
        physEngine.addCollisionResolver(new CollisionResolver(dynamicColls, (Collideable)staticColls));
        physEngine.addCollisionResolver(new CollisionResolver(dynamicColls));
    }

    protected void prepareNextFrame(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        super.prepareNextFrame(gameTime, frameTime, timingMode);
        this.ofs += this.dir * 0.02f;
        if (this.ofs > 1.5f) {
            this.ofs = 1.5f;
            this.dir = -1.0f;
        } else if (this.ofs < -1.5f) {
            this.ofs = -1.5f;
            this.dir = 1.0f;
        }
        this.angle += 0.015f;
        Vector3f lPos1 = new Vector3f(2.0f * FastMath.sin(this.angle), 0.0f, 2.0f * FastMath.cos(this.angle) + this.ofs);
        Vector3f lPos1scaled = new Vector3f(lPos1);
        Vector3f lDirect1 = new Vector3f(FastMath.sin(this.angle), 0.0f, FastMath.cos(this.angle));
        lDirect1.negate();
        lDirect1.normalize();
        this.lgt1d.setDirection(lDirect1);
        this.lgt1p.setLocation(lPos1scaled);
        this.lgt1s.setLocation(lPos1scaled);
        this.lgt1s.setDirection(lDirect1);
        Vector3f lPos2 = new Vector3f(0.5f, 0.8f, 2.0f + this.ofs);
        Vector3f lPos2scaled = new Vector3f(lPos2);
        this.lgt2p.setLocation(lPos2scaled);
        this.lgt2s.setLocation(lPos2scaled);
    }

    private HUD createInfoHUD(Sized2iRO size) {
        HUD hud = new HUD(size, 800.0f);
        Label info = new Label(hud.getResX(), 40.0f, "Press SPACE to (re-)start the simulation.", HUDFont.getFont("Verdana", HUDFont.PLAIN, 18), Colorf.RED, TextAlignment.CENTER_LEFT);
        info.setPadding(10);
        hud.getContentPane().addWidget(info, 0.0f, hud.getResY() - info.getHeight());
        return hud;
    }

    public CollisionDropTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(0.0f, 6.0f, 15.0f, 0.0f, 6.0f, 0.0f, 0.0f, 1.0f, 0.0f, this);
        env.setPhysicsEngine(new JoodePhysicsEngine());
        this.physEngine = env.getPhysicsEngine();
        this.physEngine.setEnabled(false);
        SimulationWorld simWorld = this.physEngine.getSimulationEngine().newWorld();
        simWorld.setGravity(0.0f, -9.81f, 0.0f);
        this.physEngine.getDefaultSurfaceParameters().setParameter("bounce", Float.valueOf(0.0f));
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        resLoc.createAndAddTSL("phong");
        this.createSceneGraph(env, this.physEngine, simWorld);
        env.addHUD(this.createInfoHUD(arguments.getResolution()));
        final Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas){

            protected String getDynamicTitlePart(float fps, boolean limited) {
                return ", " + canvas.getPeer().getTriangles() + " triangles" + super.getDynamicTitlePart(fps, limited);
            }
        });
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
        System.out.println("Hit SPACE to start/reset the simulation and L to toggle lighting mode (directional, point, spot), or ESC to exit");
    }

    public static void main(String[] args) throws Throwable {
        CollisionDropTest test = new CollisionDropTest(CollisionDropTest.parseCommandLine(args));
        test.begin();
    }
}

