/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.physics;

import java.util.Random;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.openmali.types.twodee.Sized2iRO;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.loop.Updatable;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.loop.opscheduler.Interval;
import org.xith3d.loop.opscheduler.IntervalListener;
import org.xith3d.physics.PhysicsGFXManager;
import org.xith3d.physics.collision.Collideable;
import org.xith3d.physics.collision.CollideableGroup;
import org.xith3d.physics.collision.Collision;
import org.xith3d.physics.collision.CollisionCheck;
import org.xith3d.physics.collision.CollisionEngine;
import org.xith3d.physics.collision.CollisionListener;
import org.xith3d.physics.collision.collideable.SphereCollideable;
import org.xith3d.physics.joode.JoodePhysicsEngine;
import org.xith3d.render.Canvas3D;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.GroupNode;
import org.xith3d.scenegraph.Material;
import org.xith3d.scenegraph.PointLight;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.traversal.impl.ShapeFinder;
import org.xith3d.test.Xith3DTest;
import org.xith3d.ui.hud.HUD;
import org.xith3d.ui.hud.utils.HUDFont;
import org.xith3d.ui.hud.widgets.Label;
import org.xith3d.ui.text2d.TextAlignment;
import org.xith3d.utility.camera.SmoothPlaceableVerticalFocuser;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;
import org.xith3d.utility.input.EightDirectionsMovement;

@Xith3DTest.Description(fulltext={"A small (as usual) example of how to use XPAL (JOODE)", "for collision detections and a custom collision-reaction code."}, authors={"Amos Wenger (aka BlueSky)"})
public class CollisionsTest
extends Xith3DTest {
    private static final Random RANDOM = new Random(System.nanoTime());
    private Material mat;
    private boolean earthquakeEnabled = true;

    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case SPACE: {
                this.earthquakeEnabled = !this.earthquakeEnabled;
                break;
            }
            case ESCAPE: {
                this.end();
            }
        }
    }

    public void prepareNextFrame(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        super.prepareNextFrame(gameTime, frameTime, timingMode);
        this.mat.setDiffuseColor(Colorf.GREEN);
    }

    private CollideableGroup createObstacles(Xith3DEnvironment env, GroupNode parentGroup) {
        CollisionEngine collEng = env.getPhysicsEngine().getCollisionEngine();
        PhysicsGFXManager gfxManager = env.getPhysicsEngine().getGFXManager();
        CollideableGroup obstaclesGroup = collEng.newGroup("OcTree");
        int X_SIZE = 20;
        int Y_SIZE = 20;
        boolean[][] obsTable = new boolean[20][20];
        for (int y = 0; y < 20; ++y) {
            for (int x = 0; x < 20; ++x) {
                obsTable[x][y] = true;
            }
        }
        int x = 1;
        int y = 1;
        obsTable[x][y] = false;
        int NUM_STEPS = 40000;
        int MAX_MOVE = 5;
        int j = 0;
        for (int i = 0; i < 40000; ++i) {
            j = RANDOM.nextInt(5);
            while (j-- > 0) {
                if (RANDOM.nextBoolean()) {
                    if (RANDOM.nextBoolean()) {
                        if (x + 1 < 20 && (x + 2 >= 20 || obsTable[x + 2][y])) {
                            ++x;
                        }
                    } else if (x > 1 && (x - 2 <= 1 || obsTable[x - 2][y])) {
                        --x;
                    }
                } else if (RANDOM.nextBoolean()) {
                    if (y + 1 < 20 && (y + 2 >= 20 || obsTable[x][y + 2])) {
                        ++y;
                    }
                } else if (y > 1 && (y - 2 <= 1 || obsTable[x][y - 2])) {
                    --y;
                }
                obsTable[x][y] = false;
            }
        }
        for (y = 0; y < 20; ++y) {
            for (x = 0; x < 20; ++x) {
                if (!obsTable[x][y]) continue;
                SphereCollideable c = collEng.newSphere(RANDOM.nextFloat() * 0.3f + 0.6f);
                obstaclesGroup.addCollideable(c);
                c.setPosition(x, y, 0.0f);
                gfxManager.directAdd(c, parentGroup);
            }
        }
        for (Shape3D shape3D : ShapeFinder.findAllShapes(parentGroup)) {
            Appearance app = shape3D.getAppearance(true);
            Material material = new Material(Colorf.GRAY50, Colorf.BLACK, new Colorf(RANDOM.nextFloat(), 1.0f, RANDOM.nextFloat()), Colorf.WHITE, 64.0f);
            app.setMaterial(material);
        }
        return obstaclesGroup;
    }

    private Collideable createAvatar(Xith3DEnvironment env, GroupNode parentGroup, CollideableGroup obstaclesGroup) {
        CollisionEngine collEng = env.getPhysicsEngine().getCollisionEngine();
        PhysicsGFXManager gfxManager = env.getPhysicsEngine().getGFXManager();
        final SphereCollideable avatar = collEng.newSphere(0.3f);
        avatar.setPosition(1.0f, 1.0f, 0.0f);
        this.mat = ShapeFinder.findFirstShape(gfxManager.directAdd(avatar, parentGroup)).getAppearance(true).getMaterial(true);
        this.mat.setDiffuseColor(Colorf.GREEN);
        new EightDirectionsMovement(avatar, 7.0f, this.getUpdater());
        new SmoothPlaceableVerticalFocuser(env.getView(), avatar, 10.0f, 0.1f, this.getUpdater());
        collEng.setDefaultCollisionListener(new CollisionListener(){

            public void onCollision(Collision collision) {
                if (collision.getCollideable1() == avatar) {
                    CollisionsTest.this.mat.setDiffuseColor(Colorf.RED);
                    Point3f pos = Point3f.fromPool();
                    avatar.getPosition(pos);
                    Vector3f move = collision.getScaledNormal();
                    pos.add(move);
                    pos.setZ(0.0f);
                    avatar.setPosition(pos);
                    Point3f.toPool(pos);
                }
            }
        });
        collEng.addCollisionCheck(new CollisionCheck(avatar, obstaclesGroup));
        return avatar;
    }

    private void createEarthquake(final CollideableGroup obstaclesGroup) {
        final Interval earthQuakeInterval = new Interval(200000L, "Earthquake");
        this.getOperationScheduler().addInterval(earthQuakeInterval);
        final Point3f earthQuakePos = new Point3f();
        this.getOperationScheduler().addIntervalListener(new IntervalListener(){

            public void onIntervalHit(Interval interval, long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
                if (interval == earthQuakeInterval && CollisionsTest.this.earthquakeEnabled) {
                    earthQuakePos.set(RANDOM.nextFloat(), RANDOM.nextFloat(), 0.0f);
                }
            }
        });
        final Point3f earthQuakeInterpolatedPos = new Point3f();
        this.addUpdatable(new Updatable(){

            public void update(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
                if (CollisionsTest.this.earthquakeEnabled) {
                    earthQuakeInterpolatedPos.interpolate(earthQuakePos, 0.3f);
                    obstaclesGroup.setPosition(earthQuakeInterpolatedPos);
                }
            }
        });
    }

    private void init(Xith3DEnvironment env) throws Exception {
        env.setPhysicsEngine(new JoodePhysicsEngine());
        env.getPhysicsEngine().getSimulationEngine().setEnabled(false);
        BranchGroup scene = env.addPerspectiveBranch().getBranchGroup();
        scene.addChild(new PointLight(0.5f, 0.5f, 0.5f, 30.0f, 30.0f, 30.0f, 5.0E-4f));
        CollideableGroup obstaclesGroup = this.createObstacles(env, scene);
        this.createAvatar(env, scene, obstaclesGroup);
        this.createEarthquake(obstaclesGroup);
    }

    private HUD createInfoHUD(Sized2iRO size) {
        HUD hud = new HUD(size, 800.0f);
        Label info = new Label(hud.getResX(), 40.0f, "Press SPACE toggle earthquake.", HUDFont.getFont("Verdana", HUDFont.PLAIN, 18), Colorf.WHITE, TextAlignment.CENTER_LEFT);
        info.setPadding(10);
        hud.getContentPane().addWidget(info, 0.0f, hud.getResY() - info.getHeight());
        return hud;
    }

    public CollisionsTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(this);
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
        this.init(env);
        env.addHUD(this.createInfoHUD(arguments.getResolution()));
        System.out.println("Use arrow keys to move the sphere");
    }

    public static void main(String[] args) throws Throwable {
        CollisionsTest test = new CollisionsTest(CollisionsTest.parseCommandLine(args));
        test.begin();
    }
}

