/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.physics;

import java.util.ArrayList;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.openmali.types.twodee.Sized2iRO;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Matrix3f;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.physics.PhysicsEngine;
import org.xith3d.physics.PhysicsGFXManager;
import org.xith3d.physics.collision.CollideableGroup;
import org.xith3d.physics.collision.CollisionEngine;
import org.xith3d.physics.collision.CollisionResolver;
import org.xith3d.physics.collision.collideable.SphereCollideable;
import org.xith3d.physics.joode.JoodePhysicsEngine;
import org.xith3d.physics.simulation.Body;
import org.xith3d.physics.simulation.SimulationEngine;
import org.xith3d.physics.simulation.SimulationWorld;
import org.xith3d.physics.simulation.joints.HingeJoint;
import org.xith3d.render.Canvas3D;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.ui.hud.HUD;
import org.xith3d.ui.hud.utils.HUDFont;
import org.xith3d.ui.hud.widgets.Label;
import org.xith3d.ui.text2d.TextAlignment;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"A small example for the HingeJoint (Newton's Cradle)."}, authors={"Marvin Froehlich (aka Qudus)"})
public class HingeJointTest2
extends Xith3DTest {
    private PhysicsEngine physEng;
    private ArrayList<Body> movingObjects = new ArrayList();
    private ArrayList<Point3f> originalPositions = new ArrayList();
    private ArrayList<Vector3f> originalVelocities = new ArrayList();

    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case SPACE: {
                if (this.physEng.isEnabled()) {
                    for (int i = 0; i < this.movingObjects.size(); ++i) {
                        Body body = this.movingObjects.get(i);
                        body.setPosition(this.originalPositions.get(i));
                        body.setLinearVelocity(this.originalVelocities.get(i));
                        body.resetAngularVelocity();
                        body.setRotation(0.0f, 0.0f, 0.0f);
                    }
                    break;
                }
                this.physEng.setEnabled(true);
                break;
            }
            case ESCAPE: {
                this.end();
            }
        }
    }

    private void addMovingObject(Body body) {
        this.movingObjects.add(body);
        this.originalPositions.add(new Point3f(body.getPosition()));
        this.originalVelocities.add(new Vector3f(body.getLinearVelocity()));
    }

    private Body createSphere(CollisionEngine collEngine, SimulationWorld simWorld, PhysicsGFXManager gfxManager, Point3f basePos, int i, BranchGroup scene) {
        float offsetX = 0.2f;
        float offsetY = 1.5f;
        Body body = simWorld.newBody();
        body.setMass(20.0f);
        SphereCollideable sphere = collEngine.newSphere(0.1f);
        Point3f bodyPos = new Point3f(basePos.getX() + (float)i * 0.2f, -1.5f, 0.0f);
        body.setPosition(bodyPos);
        if (i == 0) {
            Matrix3f mat = new Matrix3f();
            mat.rotZ(-1.5707964f);
            Vector3f tmp = new Vector3f(0.0f, body.getPositionY(), 0.0f);
            mat.transform(tmp);
            body.setPosition(body.getPosition().getX() + tmp.getX(), tmp.getY(), tmp.getZ());
        }
        body.addCollideable(sphere);
        simWorld.addBody(body);
        HingeJoint joint = simWorld.newHingeJoint(body, null);
        joint.setAnchor(bodyPos.getX(), 0.0f, 0.0f);
        joint.setAxis(Vector3f.NEGATIVE_Z_AXIS);
        simWorld.addJoint(joint);
        gfxManager.directAdd(joint, scene, Colorf.GRAY25, 1.0f);
        return body;
    }

    private void setupPhysicsAndScene(Xith3DEnvironment sceneGraph) {
        JoodePhysicsEngine physEng = new JoodePhysicsEngine();
        CollisionEngine collEng = physEng.getCollisionEngine();
        SimulationEngine simEng = physEng.getSimulationEngine();
        SimulationWorld simWorld = simEng.newWorld();
        simWorld.setGravity(0.0f, -9.81f, 0.0f);
        physEng.getDefaultSurfaceParameters().setParameter("bounce", Float.valueOf(1.0f));
        PhysicsGFXManager gfxManager = physEng.getGFXManager();
        BranchGroup scene = sceneGraph.addPerspectiveBranch().getBranchGroup();
        CollideableGroup group = collEng.newGroup();
        SphereCollideable.setDefaultAppearance("spherebase.jpg");
        Point3f basePos = new Point3f(-1.0f, 0.0f, 0.0f);
        for (int i = 0; i < 10; ++i) {
            Body body = this.createSphere(collEng, simWorld, gfxManager, basePos, i, scene);
            group.addCollideable(body.getCollideable(0));
            this.addMovingObject(body);
        }
        physEng.addCollisionResolver(new CollisionResolver(group));
        sceneGraph.setPhysicsEngine(physEng);
        this.physEng = physEng;
    }

    private HUD createInfoHUD(Sized2iRO size) {
        HUD hud = new HUD(size, 800.0f);
        Label info = new Label(hud.getResX(), 40.0f, "Press SPACE to (re-)start the simulation.", HUDFont.getFont("Verdana", HUDFont.PLAIN, 18), Colorf.WHITE, TextAlignment.CENTER_LEFT);
        info.setPadding(10);
        hud.getContentPane().addWidget(info, 0.0f, hud.getResY() - info.getHeight());
        return hud;
    }

    public HingeJointTest2(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(0.0f, 0.0f, 5.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        resLoc.createAndAddTSL("phong");
        this.setupPhysicsAndScene(env);
        env.addHUD(this.createInfoHUD(arguments.getResolution()));
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
    }

    public static void main(String[] args) throws Throwable {
        HingeJointTest2 test = new HingeJointTest2(HingeJointTest2.parseCommandLine(args));
        test.begin();
    }
}

