/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.physics;

import java.util.HashMap;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Matrix3f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.physics.PhysicsGFXManager;
import org.xith3d.physics.collision.Collideable;
import org.xith3d.physics.collision.CollideableGroup;
import org.xith3d.physics.collision.Collision;
import org.xith3d.physics.collision.CollisionEngine;
import org.xith3d.physics.collision.CollisionListener;
import org.xith3d.physics.collision.collideable.RayCollideable;
import org.xith3d.physics.collision.collideable.SphereCollideable;
import org.xith3d.physics.joode.JoodePhysicsEngine;
import org.xith3d.physics.simulation.SimulationEngine;
import org.xith3d.physics.simulation.SimulationWorld;
import org.xith3d.render.Canvas3D;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.GroupNode;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.StaticTransform;
import org.xith3d.scenegraph.primitives.Sphere;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;
import org.xith3d.utility.interpolate.AngleInterpolater;

@Xith3DTest.Description(fulltext={"A small example for the Ray collision."}, authors={"Marvin Froehlich (aka Qudus)"})
public class RayCollisionTest
extends Xith3DTest
implements CollisionListener {
    private final AngleInterpolater inter = new AngleInterpolater(0.31415927f);
    private final Matrix3f rotMat = new Matrix3f();
    private final Vector3f dir = new Vector3f();
    private RayCollideable ray;
    private CollideableGroup obstacles;
    private CollisionEngine collEng;
    private final HashMap<Collideable, Shape3D> obstaclesMap = new HashMap();
    private Shape3D lastColliding = null;

    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
            }
        }
    }

    private void setupPhysicsAndScene(Xith3DEnvironment sceneGraph) {
        JoodePhysicsEngine physEng = new JoodePhysicsEngine();
        this.collEng = physEng.getCollisionEngine();
        SimulationEngine simEng = physEng.getSimulationEngine();
        SimulationWorld simWorld = simEng.newWorld();
        simWorld.setGravity(0.0f, -9.81f, 0.0f);
        PhysicsGFXManager gfxManager = physEng.getGFXManager();
        BranchGroup scene = sceneGraph.addPerspectiveBranch().getBranchGroup();
        SphereCollideable.setDefaultAppearance("spherebase.jpg");
        this.obstacles = this.collEng.newGroup("Simple");
        for (int i = 0; i < 12; ++i) {
            SphereCollideable sphere = this.collEng.newSphere(0.3f);
            float angle = (float)i / 12.0f * ((float)Math.PI * 2);
            this.rotMat.rotZ(angle);
            this.dir.set(3.0f, 0.0f, 0.0f);
            this.rotMat.mul(this.dir, this.dir);
            sphere.setPosition(this.dir);
            this.obstacles.addCollideable(sphere);
            Sphere shape = sphere.getBaseGFX();
            StaticTransform.translate(shape, (Tuple3f)this.dir);
            scene.addChild(shape);
            this.obstaclesMap.put(sphere, shape);
        }
        this.ray = this.collEng.newRay(0.0f, 0.0f, 0.0f, 20.0f, 0.0f, 0.0f);
        gfxManager.directAdd(this.ray, (GroupNode)scene);
        sceneGraph.setPhysicsEngine(physEng);
    }

    protected void onRenderLoopStarted() {
        super.onRenderLoopStarted();
        this.inter.startIncreasing(this.getGameTime());
    }

    public void onCollision(Collision collision) {
        Collideable coll = collision.getCollideable2();
        Shape3D shape = this.obstaclesMap.get(coll);
        if (this.lastColliding != null && this.lastColliding != shape) {
            this.lastColliding.getAppearance().setMaterial(null);
        }
        if (this.lastColliding != shape) {
            shape.getAppearance().getMaterial(true).setEmissiveColor(Colorf.GREEN);
        }
        this.lastColliding = shape;
    }

    protected void prepareNextFrame(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        float angle = this.inter.getValue(gameTime, timingMode);
        this.rotMat.rotZ(angle);
        this.ray.setRotationMatrix(this.rotMat);
        super.prepareNextFrame(gameTime, frameTime, timingMode);
        int numCollisions = this.collEng.checkCollisions((Collideable)this.ray, (Collideable)this.obstacles, false, this);
        if (numCollisions == 0 && this.lastColliding != null) {
            this.lastColliding.getAppearance().setMaterial(null);
            this.lastColliding = null;
        }
    }

    public RayCollisionTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(0.0f, 0.0f, 5.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        resLoc.createAndAddTSL("phong");
        this.setupPhysicsAndScene(env);
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
    }

    public static void main(String[] args) throws Throwable {
        RayCollisionTest test = new RayCollisionTest(RayCollisionTest.parseCommandLine(args));
        test.begin();
    }
}

