/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.physics.visual_joints.utils;

import java.util.LinkedList;
import java.util.List;
import org.openmali.vecmath2.Matrix3f;
import org.openmali.vecmath2.Tuple3f;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.ui.text2d.Text2D;

public class DirectedText {
    private List<TransformGroup> face_to_camera_transforms = new LinkedList<TransformGroup>();
    private TransformGroup tg;

    public DirectedText(TransformGroup tg) {
        this.tg = tg;
    }

    public void addText(TransformGroup ltg, String txt, Tuple3f pos, boolean face_to_camera) {
        Transform3D trans = new Transform3D(pos);
        trans.setScale(0.002f);
        TransformGroup ttg = new TransformGroup(trans);
        Text2D t2D = new Text2D(txt);
        t2D.setResolution(64);
        ttg.addChild(t2D);
        ltg.addChild(ttg);
        if (face_to_camera) {
            this.face_to_camera_transforms.add(ttg);
        }
    }

    public void updateTextDirections() {
        Matrix3f rotMat = new Matrix3f();
        this.tg.getTransform().getRotation(rotMat);
        rotMat.invert();
        for (TransformGroup trgr : this.face_to_camera_transforms) {
            Transform3D tr3d = trgr.getTransform();
            tr3d.setRotation(rotMat);
            trgr.setTransform(tr3d);
        }
    }
}

