/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.picking;

import java.util.ArrayList;
import java.util.List;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.devices.components.MouseButton;
import org.jagatoo.input.devices.components.MouseButtons;
import org.jagatoo.input.events.KeyPressedEvent;
import org.jagatoo.input.events.MouseButtonPressedEvent;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.picking.AllPickListener;
import org.xith3d.picking.NearestPickListener;
import org.xith3d.picking.PickListener;
import org.xith3d.picking.PickResult;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.ForegroundRenderPass;
import org.xith3d.render.RenderPass;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.GroupNode;
import org.xith3d.scenegraph.SceneGraph;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.scenegraph.View;
import org.xith3d.scenegraph.primitives.Ring;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.picking.PickingTestUtils;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Xith3DTest.Description(fulltext={"Simple Xith3D PickRender test for OpenGL's GL_SELECT picking."}, authors={"Yuri Vl. Gushchin (aka YVG)", "Marvin Froehlich (aka Qudus)", "Amos Wenger (aka BlueSky)", "Marvin Froehlich (aka Qudus)"})
public class GLSelectPickingRenderPassTest
extends Xith3DTest
implements PickListener {
    private Canvas3D canvas;
    private RenderPass renderPass;
    private List<GroupNode> pickGroups;

    @Override
    public void onKeyPressed(KeyPressedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
                break;
            }
            case SPACE: {
                if (this.renderPass.getConfig().getProjectionPolicy() == View.ProjectionPolicy.PERSPECTIVE_PROJECTION) {
                    this.renderPass.getConfig().setProjectionPolicy(View.ProjectionPolicy.PARALLEL_PROJECTION);
                    break;
                }
                this.renderPass.getConfig().setProjectionPolicy(View.ProjectionPolicy.PERSPECTIVE_PROJECTION);
            }
        }
    }

    @Override
    public void onMouseButtonPressed(MouseButtonPressedEvent e, MouseButton button) {
        if (button == MouseButtons.LEFT_BUTTON) {
            this.canvas.pickNearest(this.pickGroups, button, e.getX(), e.getY(), (NearestPickListener)this);
        } else if (button == MouseButtons.RIGHT_BUTTON) {
            this.canvas.pickAll(this.pickGroups, button, e.getX(), e.getY(), (AllPickListener)this);
        }
    }

    @Override
    public boolean testIntersectionsInWorldSpaceForPicking() {
        return false;
    }

    @Override
    public void onObjectPicked(PickResult nearest, Object userObject, long pickTime) {
        System.out.println("  Hit Shape3D: \"" + nearest.getNode().getName() + "\", distance=" + nearest.getMinimumDistance() + " position=" + nearest.getPos());
    }

    @Override
    public void onObjectsPicked(List<PickResult> results, Object userObject, long pickTime) {
        System.out.println("Detected " + results.size() + " hits");
        int i = 0;
        for (PickResult pr : results) {
            System.out.println("  Hit (" + i++ + "): Shape3D: \"" + pr.getNode().getName() + "\", distance=" + pr.getMinimumDistance() + " position=" + pr.getPos());
        }
    }

    @Override
    public void onPickingMissed(Object userObject, long pickTime) {
        System.out.println("Picking missed");
    }

    private void create2D(SceneGraph sceneGraph) {
        BranchGroup scene = new BranchGroup();
        TransformGroup tg = new TransformGroup();
        tg.getTransform().setTranslation(0.0f, 0.0f, 1.1f);
        Ring ring = new Ring(0.7f, 0.8f, 64, 5, false, 2);
        ring.setName("Ring");
        tg.addChild(ring);
        scene.addChild(tg);
        sceneGraph.addRenderPass(ForegroundRenderPass.createParallel(scene, View.CameraMode.VIEW_FIXED));
    }

    public GLSelectPickingRenderPassTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(0.0f, 0.0f, 3.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        this.pickGroups = new ArrayList<GroupNode>();
        BranchGroup rootBranch = PickingTestUtils.createSceneGraph(this.getAnimator());
        this.renderPass = env.addPerspectiveBranch(rootBranch);
        this.pickGroups.add(rootBranch);
        this.create2D(env);
        this.canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(this.canvas);
        this.canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(this.canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(this.canvas.getPeer());
        System.out.println("Hit ESC to exit, SPACE to toggle projection policy, click mouse on object to perform pick");
        System.out.println("Note that due to Linux workarounds planes with CULL_NONE are pickable only from one (face) side...");
    }

    public static void main(String[] args) throws Throwable {
        GLSelectPickingRenderPassTest test = new GLSelectPickingRenderPassTest(GLSelectPickingRenderPassTest.parseCommandLine(args));
        test.begin();
    }
}

