/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.picking;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.devices.components.Keys;
import org.jagatoo.input.devices.components.MouseButton;
import org.jagatoo.input.events.KeyPressedEvent;
import org.jagatoo.input.events.MouseButtonPressedEvent;
import org.openmali.spatial.bodies.Plane;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.TupleNf;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.input.FirstPersonInputHandler;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.picking.NearestPickListener;
import org.xith3d.picking.PickRay;
import org.xith3d.picking.PickResult;
import org.xith3d.picking.PickingLibrary;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.RenderPass;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.Group;
import org.xith3d.scenegraph.StaticTransform;
import org.xith3d.scenegraph.Transformable;
import org.xith3d.scenegraph.primitives.Line;
import org.xith3d.scenegraph.primitives.Rectangle;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"Simple Xith3D test for the PickRay class"}, authors={"Marvin Froehlich (aka Qudus)"})
public class PickRayTest
extends Xith3DTest
implements NearestPickListener {
    private Canvas3D canvas;
    private Group pickGroup;
    private Plane plane;
    private Line line;
    private PickRay pickRay;

    public void onKeyPressed(KeyPressedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
            }
        }
    }

    public void onMouseButtonPressed(MouseButtonPressedEvent e, MouseButton button) {
        this.pickRay.recalculate(e.getX(), e.getY());
        Point3f intersection = Point3f.fromPool();
        this.plane.intersects(this.pickRay, intersection);
        System.out.println(intersection);
        Point3f.toPool(intersection);
        Point3f end = Point3f.fromPool();
        Vector3f dir = Vector3f.fromPool();
        dir.set((TupleNf)this.pickRay.getDirection());
        dir.normalize();
        dir.mul(100.0f);
        end.add(this.pickRay.getOrigin(), dir);
        this.line.setCoordinates(this.pickRay.getOrigin(), dir);
        Vector3f.toPool(dir);
        Point3f.toPool(end);
        PickingLibrary.pickNearest(this.pickGroup, this.canvas, button, e.getX(), e.getY(), (NearestPickListener)this);
    }

    public boolean testIntersectionsInWorldSpaceForPicking() {
        return false;
    }

    public void onObjectPicked(PickResult nearest, Object userObject, long pickTime) {
        System.out.println("  Hit Shape3D: \"" + nearest.getNode().getName() + "\", distance=" + nearest.getMinimumDistance() + " position=" + nearest.getPos());
    }

    public void onPickingMissed(Object userObject, long pickTime) {
        System.out.println("You just picked nothing!");
    }

    private Group createSceneGraph() {
        Group g = new Group();
        Rectangle floor = new Rectangle(30.0f, 30.0f, Rectangle.ZeroPointLocation.CENTER_CENTER, "grass.jpg");
        floor.setName("Floor");
        StaticTransform.rotateX(floor, -1.5707964f);
        this.plane = new Plane(0.0f, 1.0f, 0.0f, 0.0f);
        g.addChild(floor);
        return g;
    }

    public PickRayTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(0.0f, 5.0f, 5.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        this.pickGroup = this.createSceneGraph();
        BranchGroup bg = new BranchGroup();
        bg.addChild(this.pickGroup);
        this.line = new Line(Point3f.ZERO, Colorf.RED);
        bg.addChild(this.line);
        RenderPass renderPass = env.addPerspectiveBranch(bg);
        this.canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(this.canvas);
        this.canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(this.canvas));
        this.pickRay = new PickRay(renderPass.getConfig(), this.canvas, 0, 0);
        InputSystem.getInstance().registerNewKeyboardAndMouse(this.canvas.getPeer());
        FirstPersonInputHandler fpHandler = new FirstPersonInputHandler((Transformable)env.getView(), env.getCanvas(), 0.5f, 0.5f, arguments.getMouseYInverted(), 0.5f);
        fpHandler.getBindingsManager().createDefaultBindings();
        fpHandler.getBindingsManager().unbind(Keys.SPACE);
        InputSystem.getInstance().addInputHandler(fpHandler);
        System.out.println("Hit ESC to exit, SPACE to toggle projection policy, click mouse on object to perform pick");
        System.out.println("Note that due to Linux workarounds planes with CULL_NONE are pickable only from one (face) side...");
    }

    public static void main(String[] args) throws Throwable {
        PickRayTest test = new PickRayTest(PickRayTest.parseCommandLine(args));
        test.begin();
    }
}

