/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.picking;

import java.util.List;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.devices.components.MouseButton;
import org.jagatoo.input.devices.components.MouseButtons;
import org.jagatoo.input.events.KeyPressedEvent;
import org.jagatoo.input.events.MouseButtonPressedEvent;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.loop.opscheduler.PickScheduler;
import org.xith3d.picking.AllPickListener;
import org.xith3d.picking.NearestPickListener;
import org.xith3d.picking.PickListener;
import org.xith3d.picking.PickResult;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.RenderPass;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.GroupNode;
import org.xith3d.scenegraph.View;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.picking.PickingTestUtils;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Xith3DTest.Description(fulltext={"Simple Xith3D scheduled picking test"}, authors={"Marvin Froehlich (aka Qudus)"})
public class ScheduledPickingTest
extends Xith3DTest
implements PickListener {
    private GroupNode pickGroup;
    private PickScheduler pickScheduler;
    private RenderPass renderPass;

    @Override
    public void onKeyPressed(KeyPressedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
                break;
            }
            case SPACE: {
                if (this.renderPass.getConfig().getProjectionPolicy() == View.ProjectionPolicy.PERSPECTIVE_PROJECTION) {
                    this.renderPass.getConfig().setProjectionPolicy(View.ProjectionPolicy.PARALLEL_PROJECTION);
                    break;
                }
                this.renderPass.getConfig().setProjectionPolicy(View.ProjectionPolicy.PERSPECTIVE_PROJECTION);
            }
        }
    }

    @Override
    public boolean testIntersectionsInWorldSpaceForPicking() {
        return false;
    }

    @Override
    public void onObjectPicked(PickResult nearest, Object userObject, long pickTime) {
        System.out.println("Nearest picked Shape3D: \"" + nearest.getNode().getName() + "\", distance=" + nearest.getMinimumDistance() + " position=" + nearest.getPos());
    }

    @Override
    public void onObjectsPicked(List<PickResult> pickResults, Object userObject, long pickTime) {
        System.out.println("Detected " + pickResults.size() + " hits");
        int i = 0;
        for (PickResult pr : pickResults) {
            System.out.println("  Hit (" + i++ + "): Shape3D: \"" + pr.getNode().getName() + "\", distance=" + pr.getMinimumDistance() + " position=" + pr.getPos());
        }
    }

    @Override
    public void onPickingMissed(Object userObject, long pickTime) {
        System.out.println("Nothing was picked!");
    }

    @Override
    public void onMouseButtonPressed(MouseButtonPressedEvent e, MouseButton button) {
        System.out.println("Picking at " + e.getX() + ", " + e.getY());
        if (button == MouseButtons.LEFT_BUTTON) {
            this.pickScheduler.pickNearest(this.pickGroup, button, e.getX(), e.getY(), (NearestPickListener)this);
        } else if (button == MouseButtons.RIGHT_BUTTON) {
            this.pickScheduler.pickAll(this.pickGroup, button, e.getX(), e.getY(), (AllPickListener)this);
        }
    }

    public ScheduledPickingTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(0.0f, 0.0f, 3.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, this);
        this.pickScheduler = env.getPickScheduler();
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        this.renderPass = env.addPerspectiveBranch(PickingTestUtils.createSceneGraph(this.getAnimator()));
        this.pickGroup = this.renderPass.getBranchGroup();
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
        System.out.println("Hit ESC to exit, SPACE to toggle projection policy, click mouse on object to perform pick");
        System.out.println("Note that due to Linux workarounds planes with CULL_NONE are pickable only from one (face) side...");
    }

    public static void main(String[] args) throws Throwable {
        ScheduledPickingTest test = new ScheduledPickingTest(ScheduledPickingTest.parseCommandLine(args));
        test.begin();
    }
}

